/* -*- Mode: C; indent-tabs-mode: nil; tab-width: 2 -*- */

#include <libdeja-dup.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gconf/gconf-client.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>




static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self);
static void __lambda0 (GtkAboutDialog* dlg, gint resp);
static void ___lambda0_gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self);
guint32 _dynamic_request_name2 (DBusGProxy* self, char* param1, guint32 param2, GError** error);
void _dynamic_release_name3 (DBusGProxy* self, char* param1, GError** error);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



void deja_dup_update_last_run_timestamp (GError** error) {
	GError * inner_error;
	GTimeVal _tmp0 = {0};
	GTimeVal cur_time;
	char* cur_time_str;
	GConfClient* _tmp1;
	GConfClient* client;
	inner_error = NULL;
	cur_time = (g_get_current_time (&_tmp0), _tmp0);
	g_get_current_time (&cur_time);
	cur_time_str = g_time_val_to_iso8601 (&cur_time);
	_tmp1 = NULL;
	client = (_tmp1 = gconf_client_get_default (), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gconf_client_set_string (client, DEJA_DUP_LAST_RUN_KEY, cur_time_str, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		cur_time_str = (g_free (cur_time_str), NULL);
		(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
		return;
	}
	cur_time_str = (g_free (cur_time_str), NULL);
	(client == NULL) ? NULL : (client = (g_object_unref (client), NULL));
}


char* deja_dup_get_trash_path (void) {
	return g_build_filename (g_get_user_data_dir (), "Trash", NULL);
}


GFile* deja_dup_parse_dir (const char* dir) {
	const char* _tmp0;
	char* s;
	GFile* _tmp21;
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0 = NULL;
	s = (_tmp0 = dir, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	if (_vala_strcmp0 (s, "$HOME") == 0) {
		char* _tmp2;
		const char* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		s = (_tmp2 = (_tmp1 = g_get_home_dir (), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), s = (g_free (s), NULL), _tmp2);
	} else {
		if (_vala_strcmp0 (s, "$DESKTOP") == 0) {
			char* _tmp4;
			const char* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			s = (_tmp4 = (_tmp3 = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3)), s = (g_free (s), NULL), _tmp4);
		} else {
			if (_vala_strcmp0 (s, "$DOCUMENTS") == 0) {
				char* _tmp6;
				const char* _tmp5;
				_tmp6 = NULL;
				_tmp5 = NULL;
				s = (_tmp6 = (_tmp5 = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), s = (g_free (s), NULL), _tmp6);
			} else {
				if (_vala_strcmp0 (s, "$DOWNLOAD") == 0) {
					char* _tmp8;
					const char* _tmp7;
					_tmp8 = NULL;
					_tmp7 = NULL;
					s = (_tmp8 = (_tmp7 = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD), (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)), s = (g_free (s), NULL), _tmp8);
				} else {
					if (_vala_strcmp0 (s, "$MUSIC") == 0) {
						char* _tmp10;
						const char* _tmp9;
						_tmp10 = NULL;
						_tmp9 = NULL;
						s = (_tmp10 = (_tmp9 = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC), (_tmp9 == NULL) ? NULL : g_strdup (_tmp9)), s = (g_free (s), NULL), _tmp10);
					} else {
						if (_vala_strcmp0 (s, "$PICTURES") == 0) {
							char* _tmp12;
							const char* _tmp11;
							_tmp12 = NULL;
							_tmp11 = NULL;
							s = (_tmp12 = (_tmp11 = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES), (_tmp11 == NULL) ? NULL : g_strdup (_tmp11)), s = (g_free (s), NULL), _tmp12);
						} else {
							if (_vala_strcmp0 (s, "$PUBLIC_SHARE") == 0) {
								char* _tmp14;
								const char* _tmp13;
								_tmp14 = NULL;
								_tmp13 = NULL;
								s = (_tmp14 = (_tmp13 = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE), (_tmp13 == NULL) ? NULL : g_strdup (_tmp13)), s = (g_free (s), NULL), _tmp14);
							} else {
								if (_vala_strcmp0 (s, "$TEMPLATES") == 0) {
									char* _tmp16;
									const char* _tmp15;
									_tmp16 = NULL;
									_tmp15 = NULL;
									s = (_tmp16 = (_tmp15 = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES), (_tmp15 == NULL) ? NULL : g_strdup (_tmp15)), s = (g_free (s), NULL), _tmp16);
								} else {
									if (_vala_strcmp0 (s, "$TRASH") == 0) {
										char* _tmp17;
										_tmp17 = NULL;
										s = (_tmp17 = deja_dup_get_trash_path (), s = (g_free (s), NULL), _tmp17);
									} else {
										if (_vala_strcmp0 (s, "$VIDEOS") == 0) {
											char* _tmp19;
											const char* _tmp18;
											_tmp19 = NULL;
											_tmp18 = NULL;
											s = (_tmp19 = (_tmp18 = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS), (_tmp18 == NULL) ? NULL : g_strdup (_tmp18)), s = (g_free (s), NULL), _tmp19);
										} else {
											if (!g_path_is_absolute (s)) {
												char* _tmp20;
												_tmp20 = NULL;
												s = (_tmp20 = g_build_filename (g_get_home_dir (), s, NULL), s = (g_free (s), NULL), _tmp20);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp21 = NULL;
	return (_tmp21 = g_file_new_for_path (s), s = (g_free (s), NULL), _tmp21);
}


GFile** deja_dup_parse_dir_list (GSList* dirs, int* result_length1) {
	GFile** _tmp3;
	gint rv_size;
	gint rv_length1;
	gint _tmp2;
	GFile** rv;
	gint i;
	GFile** _tmp7;
	if (dirs == NULL) {
		GFile** _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = g_new0 (GFile*, 0 + 1), *result_length1 = 0, _tmp0);
	}
	_tmp3 = NULL;
	rv = (_tmp3 = g_new0 (GFile*, (_tmp2 = g_slist_length (dirs)) + 1), rv_length1 = _tmp2, rv_size = rv_length1, _tmp3);
	i = 0;
	{
		GSList* s_collection;
		GSList* s_it;
		s_collection = dirs;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			const char* _tmp6;
			char* s;
			_tmp6 = NULL;
			s = (_tmp6 = (const char*) s_it->data, (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
			{
				gint _tmp5;
				GFile* _tmp4;
				_tmp4 = NULL;
				_tmp5 = i++;
				rv[_tmp5] = (_tmp4 = deja_dup_parse_dir (s), (rv[_tmp5] == NULL) ? NULL : (rv[_tmp5] = (g_object_unref (rv[_tmp5]), NULL)), _tmp4);
				s = (g_free (s), NULL);
			}
		}
	}
	_tmp7 = NULL;
	return (_tmp7 = rv, *result_length1 = rv_length1, _tmp7);
}


void deja_dup_show_uri (GtkWindow* parent, const char* link) {
	GError * inner_error;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (link != NULL);
	inner_error = NULL;
	{
		gtk_show_uri (NULL, link, (guint32) GDK_CURRENT_TIME, &inner_error);
		if (inner_error != NULL) {
			goto __catch26_g_error;
			goto __finally26;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			GtkMessageDialog* dlg;
			dlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (parent, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not display %s"), link, NULL));
			gtk_message_dialog_format_secondary_text (dlg, "%s", e->message, NULL);
			gtk_dialog_run ((GtkDialog*) dlg);
			gtk_object_destroy ((GtkObject*) dlg);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		}
	}
	__finally26:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


void deja_dup_handle_about_uri (GtkAboutDialog* about, const char* link) {
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	deja_dup_show_uri ((GtkWindow*) about, link);
}


void deja_dup_handle_about_mail (GtkAboutDialog* about, const char* link) {
	char* _tmp0;
	g_return_if_fail (about != NULL);
	g_return_if_fail (link != NULL);
	_tmp0 = NULL;
	deja_dup_show_uri ((GtkWindow*) about, _tmp0 = g_strdup_printf ("mailto:%s", link));
	_tmp0 = (g_free (_tmp0), NULL);
}


static void _deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_mail (about, link_);
}


static void _deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func (GtkAboutDialog* about, const char* link_, gpointer self) {
	deja_dup_handle_about_uri (about, link_);
}


static void __lambda0 (GtkAboutDialog* dlg, gint resp) {
	GObject* _tmp0;
	GObject* about_owner;
	g_return_if_fail (dlg != NULL);
	_tmp0 = NULL;
	about_owner = (_tmp0 = G_OBJECT (g_object_get_data ((GObject*) dlg, "owner")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	g_object_set_data (about_owner, "about-dlg", NULL);
	gtk_object_destroy ((GtkObject*) dlg);
	(about_owner == NULL) ? NULL : (about_owner = (g_object_unref (about_owner), NULL));
}


static void ___lambda0_gtk_dialog_response (GtkAboutDialog* _sender, gint response_id, gpointer self) {
	__lambda0 (_sender, response_id);
}


void deja_dup_show_about (GObject* owner, GtkWindow* parent) {
	GtkAboutDialog* _tmp0;
	GtkAboutDialog* about;
	GtkAboutDialog* _tmp1;
	char* _tmp2;
	g_return_if_fail (owner != NULL);
	_tmp0 = NULL;
	about = (_tmp0 = GTK_ABOUT_DIALOG (g_object_get_data (owner, "about-dlg")), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (about != NULL) {
		gtk_window_present ((GtkWindow*) about);
		(about == NULL) ? NULL : (about = (g_object_unref (about), NULL));
		return;
	}
	_tmp1 = NULL;
	about = (_tmp1 = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ()), (about == NULL) ? NULL : (about = (g_object_unref (about), NULL)), _tmp1);
	gtk_about_dialog_set_email_hook (_deja_dup_handle_about_mail_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_about_dialog_set_url_hook (_deja_dup_handle_about_uri_gtk_about_dialog_activate_link_func, NULL, NULL);
	gtk_window_set_title ((GtkWindow*) about, _ ("About Déjà Dup"));
	gtk_about_dialog_set_authors (about, DEJA_DUP_authors);
	gtk_about_dialog_set_translator_credits (about, _ ("translator-credits"));
	gtk_about_dialog_set_logo_icon_name (about, PACKAGE);
	gtk_about_dialog_set_version (about, VERSION);
	gtk_about_dialog_set_copyright (about, "© 2008—2009 Michael Terry");
	gtk_about_dialog_set_website (about, "http://mterry.name/deja-dup/");
	_tmp2 = NULL;
	gtk_about_dialog_set_license (about, _tmp2 = g_strdup_printf ("%s\n\n%s\n\n%s", _ ("This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version."), _ ("This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details."), _ ("You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.")));
	_tmp2 = (g_free (_tmp2), NULL);
	gtk_about_dialog_set_wrap_license (about, TRUE);
	g_object_set_data (owner, "about-dlg", about);
	g_object_set_data ((GObject*) about, "owner", owner);
	gtk_window_set_transient_for ((GtkWindow*) about, parent);
	g_signal_connect ((GtkDialog*) about, "response", (GCallback) ___lambda0_gtk_dialog_response, NULL);
	gtk_widget_show ((GtkWidget*) about);
	(about == NULL) ? NULL : (about = (g_object_unref (about), NULL));
}


guint32 _dynamic_request_name2 (DBusGProxy* self, char* param1, guint32 param2, GError** error) {
	guint32 result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


void _dynamic_release_name3 (DBusGProxy* self, char* param1, GError** error) {
	dbus_g_proxy_call_no_reply (self, "ReleaseName", G_TYPE_STRING, param1, G_TYPE_INVALID);
	if (*error) {
		return;
	}
}


gboolean deja_dup_set_bus_claimed (const char* busname, gboolean claim) {
	GError * inner_error;
	g_return_val_if_fail (busname != NULL, FALSE);
	inner_error = NULL;
	{
		DBusGConnection* conn;
		DBusGProxy* bus;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &inner_error);
		if (inner_error != NULL) {
			goto __catch27_g_error;
			goto __finally27;
		}
		bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
		if (claim) {
			char* _tmp0;
			guint32 _tmp1;
			guint32 result;
			/* Try to register service in session bus.
			 The flag '4' means do not add ourselves to the queue of applications
			 wanting the name, if this request fails.*/
			_tmp0 = NULL;
			result = (_tmp1 = _dynamic_request_name2 (bus, _tmp0 = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), (guint32) 4, &inner_error), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
			if (inner_error != NULL) {
				(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
				(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
				goto __catch27_g_error;
				goto __finally27;
			}
			if (result == DBUS_REQUEST_NAME_REPLY_EXISTS) {
				gboolean _tmp2;
				return (_tmp2 = FALSE, (conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL)), (bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL)), _tmp2);
			}
		} else {
			char* _tmp3;
			_tmp3 = NULL;
			_dynamic_release_name3 (bus, _tmp3 = g_strconcat ("net.launchpad.deja-dup.", busname, NULL), &inner_error);
			if (inner_error != NULL) {
				(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
				(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
				goto __catch27_g_error;
				goto __finally27;
			}
			_tmp3 = (g_free (_tmp3), NULL);
		}
		(conn == NULL) ? NULL : (conn = (dbus_g_connection_unref (conn), NULL));
		(bus == NULL) ? NULL : (bus = (g_object_unref (bus), NULL));
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("libdeja-dup.vala:179: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally27:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
	return TRUE;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




