/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __CONFIGCHOICE_H__
#define __CONFIGCHOICE_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "ConfigWidget.h"

G_BEGIN_DECLS


#define TYPE_CONFIG_CHOICE (config_choice_get_type ())
#define CONFIG_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_CHOICE, ConfigChoice))
#define CONFIG_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_CHOICE, ConfigChoiceClass))
#define IS_CONFIG_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_CHOICE))
#define IS_CONFIG_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_CHOICE))
#define CONFIG_CHOICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_CHOICE, ConfigChoiceClass))

typedef struct _ConfigChoice ConfigChoice;
typedef struct _ConfigChoiceClass ConfigChoiceClass;
typedef struct _ConfigChoicePrivate ConfigChoicePrivate;

/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _ConfigChoice {
	ConfigWidget parent_instance;
	ConfigChoicePrivate * priv;
	GtkComboBox* combo;
	gint gconf_col;
};

struct _ConfigChoiceClass {
	ConfigWidgetClass parent_class;
	void (*handle_changed) (ConfigChoice* self);
};


void config_choice_init (ConfigChoice* self, GtkTreeModel* model, gint gconf_col);
GValue* config_choice_get_current_value (ConfigChoice* self);
void config_choice_handle_changed (ConfigChoice* self);
ConfigChoice* config_choice_construct (GType object_type);
ConfigChoice* config_choice_new (void);
GType config_choice_get_type (void);


G_END_DECLS

#endif
