/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigFolder.h"
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <glib/gi18n-lib.h>




struct _ConfigFolderPrivate {
	GtkFileChooserButton* button;
};

#define CONFIG_FOLDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_FOLDER, ConfigFolderPrivate))
enum  {
	CONFIG_FOLDER_DUMMY_PROPERTY
};
static void config_folder_real_set_from_config (ConfigWidget* base);
static void config_folder_handle_selection_changed (ConfigFolder* self);
static void _config_folder_handle_selection_changed_gtk_file_chooser_selection_changed (GtkFileChooserButton* _sender, gpointer self);
static GObject * config_folder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_folder_parent_class = NULL;
static void config_folder_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ConfigFolder* config_folder_construct (GType object_type, const char* key) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigFolder * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigFolder* config_folder_new (const char* key) {
	return config_folder_construct (TYPE_CONFIG_FOLDER, key);
}


static void config_folder_real_set_from_config (ConfigWidget* base) {
	ConfigFolder * self;
	GError * inner_error;
	char* val;
	self = (ConfigFolder*) base;
	inner_error = NULL;
	val = NULL;
	{
		const char* _tmp0;
		char* _tmp2;
		const char* _tmp1;
		_tmp0 = gconf_client_get_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch6_g_error;
			goto __finally6;
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		val = (_tmp2 = (_tmp1 = _tmp0, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), val = (g_free (val), NULL), _tmp2);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigFolder.vala:46: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			val = (g_free (val), NULL);
			return;
		}
	}
	__finally6:
	if (inner_error != NULL) {
		val = (g_free (val), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	if (val == NULL) {
		char* _tmp3;
		_tmp3 = NULL;
		val = (_tmp3 = g_strdup (""), val = (g_free (val), NULL), _tmp3);
	}
	/* There should really be a better default, but I'm not sure
	 what.  The first mounted volume we see?  Create a directory
	 in $HOME called 'deja-dup'?*/
	if (_vala_strcmp0 (gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->button), val) != 0) {
		gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->button, val);
	}
	val = (g_free (val), NULL);
}


static void config_folder_handle_selection_changed (ConfigFolder* self) {
	GError * inner_error;
	char* val;
	const char* _tmp3;
	char* filename;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	val = NULL;
	{
		const char* _tmp0;
		char* _tmp2;
		const char* _tmp1;
		_tmp0 = gconf_client_get_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), &inner_error);
		if (inner_error != NULL) {
			goto __catch7_g_error;
			goto __finally7;
		}
		_tmp2 = NULL;
		_tmp1 = NULL;
		val = (_tmp2 = (_tmp1 = _tmp0, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), val = (g_free (val), NULL), _tmp2);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally7:
	if (inner_error != NULL) {
		val = (g_free (val), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	/* ignore*/
	_tmp3 = NULL;
	filename = (_tmp3 = gtk_file_chooser_get_filename ((GtkFileChooser*) self->priv->button), (_tmp3 == NULL) ? NULL : g_strdup (_tmp3));
	if (_vala_strcmp0 (filename, val) == 0) {
		val = (g_free (val), NULL);
		filename = (g_free (filename), NULL);
		return;
	}
	{
		gconf_client_set_string (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), filename, &inner_error);
		if (inner_error != NULL) {
			goto __catch8_g_error;
			goto __finally8;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigFolder.vala:75: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
		}
	}
	__finally8:
	if (inner_error != NULL) {
		val = (g_free (val), NULL);
		filename = (g_free (filename), NULL);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	val = (g_free (val), NULL);
	filename = (g_free (filename), NULL);
}


static void _config_folder_handle_selection_changed_gtk_file_chooser_selection_changed (GtkFileChooserButton* _sender, gpointer self) {
	config_folder_handle_selection_changed (self);
}


static GObject * config_folder_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigFolderClass * klass;
	GObjectClass * parent_class;
	ConfigFolder * self;
	klass = CONFIG_FOLDER_CLASS (g_type_class_peek (TYPE_CONFIG_FOLDER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_FOLDER (obj);
	{
		GtkFileChooserButton* _tmp0;
		_tmp0 = NULL;
		self->priv->button = (_tmp0 = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Select Folder"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), (self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL)), _tmp0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->button);
		config_widget_set_from_config ((ConfigWidget*) self);
		g_signal_connect_object ((GtkFileChooser*) self->priv->button, "selection-changed", (GCallback) _config_folder_handle_selection_changed_gtk_file_chooser_selection_changed, self, 0);
	}
	return obj;
}


static void config_folder_class_init (ConfigFolderClass * klass) {
	config_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigFolderPrivate));
	G_OBJECT_CLASS (klass)->constructor = config_folder_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_folder_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_folder_real_set_from_config;
}


static void config_folder_instance_init (ConfigFolder * self) {
	self->priv = CONFIG_FOLDER_GET_PRIVATE (self);
}


static void config_folder_finalize (GObject* obj) {
	ConfigFolder * self;
	self = CONFIG_FOLDER (obj);
	(self->priv->button == NULL) ? NULL : (self->priv->button = (g_object_unref (self->priv->button), NULL));
	G_OBJECT_CLASS (config_folder_parent_class)->finalize (obj);
}


GType config_folder_get_type (void) {
	static GType config_folder_type_id = 0;
	if (config_folder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigFolder), 0, (GInstanceInitFunc) config_folder_instance_init, NULL };
		config_folder_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigFolder", &g_define_type_info, 0);
	}
	return config_folder_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




