/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "ConfigList.h"
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <gconf/gconf.h>
#include <libdeja-dup.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>




struct _ConfigListPrivate {
	GtkTreeView* tree;
	GtkButton* add_button;
	GtkButton* remove_button;
};

#define CONFIG_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIG_LIST, ConfigListPrivate))
enum  {
	CONFIG_LIST_DUMMY_PROPERTY
};
static void config_list_real_set_from_config (ConfigWidget* base);
static void config_list_handle_selection_change (ConfigList* self, GtkTreeSelection* sel);
static void config_list_handle_add (ConfigList* self);
static void config_list_handle_remove (ConfigList* self);
static void _config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GObject * config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer config_list_parent_class = NULL;
static void config_list_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



ConfigList* config_list_construct (GType object_type, const char* key) {
	GParameter * __params;
	GParameter * __params_it;
	ConfigList * self;
	g_return_val_if_fail (key != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "key";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, key);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ConfigList* config_list_new (const char* key) {
	return config_list_construct (TYPE_CONFIG_LIST, key);
}


static void config_list_real_set_from_config (ConfigWidget* base) {
	ConfigList * self;
	GError * inner_error;
	GSList* slist;
	GFile** _tmp2;
	gint list_size;
	gint list_length1;
	gint _tmp1;
	GFile** list;
	GtkListStore* model;
	gint i;
	GFile* home;
	char* _tmp3;
	GFile* _tmp4;
	GFile* trash;
	self = (ConfigList*) base;
	inner_error = NULL;
	slist = NULL;
	{
		GSList* _tmp0;
		_tmp0 = gconf_client_get_list (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), GCONF_VALUE_STRING, &inner_error);
		if (inner_error != NULL) {
			goto __catch9_g_error;
			goto __finally9;
		}
		slist = _tmp0;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigList.vala:72: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			return;
		}
	}
	__finally9:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	_tmp2 = NULL;
	list = (_tmp2 = deja_dup_parse_dir_list (slist, &_tmp1), list_length1 = _tmp1, list_size = list_length1, _tmp2);
	model = NULL;
	g_object_get ((GObject*) self->priv->tree, "model", &model, NULL);
	gtk_list_store_clear (model);
	i = 0;
	home = g_file_new_for_path (g_get_home_dir ());
	_tmp3 = NULL;
	_tmp4 = NULL;
	trash = (_tmp4 = g_file_new_for_path (_tmp3 = deja_dup_get_trash_path ()), _tmp3 = (g_free (_tmp3), NULL), _tmp4);
	{
		GFile** f_collection;
		int f_collection_length1;
		int f_it;
		f_collection = list;
		f_collection_length1 = list_length1;
		for (f_it = 0; f_it < list_length1; f_it = f_it + 1) {
			GFile* _tmp15;
			GFile* f;
			_tmp15 = NULL;
			f = (_tmp15 = f_collection[f_it], (_tmp15 == NULL) ? NULL : g_object_ref (_tmp15));
			{
				char* s;
				GtkTreeIter iter = {0};
				char* _tmp11;
				GIcon* icon;
				s = NULL;
				if (g_file_equal (f, home)) {
					char* _tmp6;
					const char* _tmp5;
					_tmp6 = NULL;
					_tmp5 = NULL;
					s = (_tmp6 = (_tmp5 = _ ("Home Folder"), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)), s = (g_free (s), NULL), _tmp6);
				} else {
					if (g_file_equal (f, trash)) {
						char* _tmp8;
						const char* _tmp7;
						_tmp8 = NULL;
						_tmp7 = NULL;
						s = (_tmp8 = (_tmp7 = _ ("Trash"), (_tmp7 == NULL) ? NULL : g_strdup (_tmp7)), s = (g_free (s), NULL), _tmp8);
					} else {
						if (g_file_has_prefix (f, home)) {
							char* _tmp9;
							_tmp9 = NULL;
							s = (_tmp9 = g_file_get_relative_path (home, f), s = (g_free (s), NULL), _tmp9);
						} else {
							char* _tmp10;
							_tmp10 = NULL;
							s = (_tmp10 = g_file_get_path (f), s = (g_free (s), NULL), _tmp10);
						}
					}
				}
				_tmp11 = NULL;
				gtk_list_store_insert_with_values (model, &iter, i++, 0, _tmp11 = g_file_get_path (f), 1, s, -1);
				_tmp11 = (g_free (_tmp11), NULL);
				/* If the folder is the trash, look up icon especially.  For some
				 reason, gio doesn't do it for us.*/
				icon = NULL;
				if (g_file_equal (f, trash)) {
					GIcon* _tmp12;
					/* Until vala bug #564062 is fixed, we use append.  Else I'd use from_names*/
					_tmp12 = NULL;
					icon = (_tmp12 = (GIcon*) ((GThemedIcon*) g_themed_icon_new ("user-trash")), (icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL)), _tmp12);
					g_themed_icon_append_name ((G_THEMED_ICON (icon)), "folder");
				} else {
					{
						GFileInfo* info;
						GIcon* _tmp14;
						GIcon* _tmp13;
						info = g_file_query_info (f, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &inner_error);
						if (inner_error != NULL) {
							goto __catch10_g_error;
							goto __finally10;
						}
						_tmp14 = NULL;
						_tmp13 = NULL;
						icon = (_tmp14 = (_tmp13 = g_file_info_get_icon (info), (_tmp13 == NULL) ? NULL : g_object_ref (_tmp13)), (icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL)), _tmp14);
						(info == NULL) ? NULL : (info = (g_object_unref (info), NULL));
					}
					goto __finally10;
					__catch10_g_error:
					{
						GError * e;
						e = inner_error;
						inner_error = NULL;
						{
							g_warning ("ConfigList.vala:113: %s\n", e->message);
							(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
						}
					}
					__finally10:
					if (inner_error != NULL) {
						(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
						s = (g_free (s), NULL);
						(icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL));
						list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_object_unref), NULL);
						(model == NULL) ? NULL : (model = (g_object_unref (model), NULL));
						(home == NULL) ? NULL : (home = (g_object_unref (home), NULL));
						(trash == NULL) ? NULL : (trash = (g_object_unref (trash), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
						return;
					}
				}
				if (icon != NULL) {
					gtk_list_store_set (model, &iter, 2, icon, -1);
				}
				(f == NULL) ? NULL : (f = (g_object_unref (f), NULL));
				s = (g_free (s), NULL);
				(icon == NULL) ? NULL : (icon = (g_object_unref (icon), NULL));
			}
		}
	}
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_object_unref), NULL);
	(model == NULL) ? NULL : (model = (g_object_unref (model), NULL));
	(home == NULL) ? NULL : (home = (g_object_unref (home), NULL));
	(trash == NULL) ? NULL : (trash = (g_object_unref (trash), NULL));
}


static void config_list_handle_selection_change (ConfigList* self, GtkTreeSelection* sel) {
	gboolean empty;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sel != NULL);
	empty = gtk_tree_selection_count_selected_rows (sel) == 0;
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->remove_button, !empty);
}


static void config_list_handle_add (ConfigList* self) {
	GError * inner_error;
	GtkFileChooserDialog* dlg;
	GFile* folder;
	GSList* slist;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	dlg = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Choose folder"), GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL));
	if (gtk_dialog_run ((GtkDialog*) dlg) != GTK_RESPONSE_ACCEPT) {
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		return;
	}
	folder = g_file_new_for_path (gtk_file_chooser_get_filename ((GtkFileChooser*) dlg));
	gtk_widget_hide ((GtkWidget*) dlg);
	slist = NULL;
	{
		GSList* _tmp0;
		gboolean found;
		_tmp0 = gconf_client_get_list (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), GCONF_VALUE_STRING, &inner_error);
		if (inner_error != NULL) {
			goto __catch11_g_error;
			goto __finally11;
		}
		slist = _tmp0;
		found = FALSE;
		{
			GSList* s_collection;
			GSList* s_it;
			s_collection = slist;
			for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
				const char* _tmp1;
				char* s;
				_tmp1 = NULL;
				s = (_tmp1 = (const char*) s_it->data, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
				{
					GFile* sfile;
					sfile = g_file_new_for_path (s);
					if (g_file_equal (sfile, folder)) {
						found = TRUE;
						s = (g_free (s), NULL);
						(sfile == NULL) ? NULL : (sfile = (g_object_unref (sfile), NULL));
						break;
					}
					s = (g_free (s), NULL);
					(sfile == NULL) ? NULL : (sfile = (g_object_unref (sfile), NULL));
				}
			}
		}
		if (!found) {
			slist = g_slist_append (slist, g_file_get_path (folder));
			gconf_client_set_list (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), GCONF_VALUE_STRING, slist, &inner_error);
			if (inner_error != NULL) {
				goto __catch11_g_error;
				goto __finally11;
			}
		} else {
			GtkMessageDialog* msgdlg;
			char* _tmp2;
			msgdlg = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) self)), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Could not add the folder"), NULL));
			_tmp2 = NULL;
			gtk_message_dialog_format_secondary_text (msgdlg, _ ("%s is already in the list."), _tmp2 = g_file_get_path (folder), NULL);
			_tmp2 = (g_free (_tmp2), NULL);
			gtk_dialog_run ((GtkDialog*) msgdlg);
			gtk_object_destroy ((GtkObject*) msgdlg);
			(msgdlg == NULL) ? NULL : (msgdlg = (g_object_unref (msgdlg), NULL));
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigList.vala:170: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
			(folder == NULL) ? NULL : (folder = (g_object_unref (folder), NULL));
			return;
		}
	}
	__finally11:
	if (inner_error != NULL) {
		(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
		(folder == NULL) ? NULL : (folder = (g_object_unref (folder), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(dlg == NULL) ? NULL : (dlg = (g_object_unref (dlg), NULL));
	(folder == NULL) ? NULL : (folder = (g_object_unref (folder), NULL));
}


static void config_list_handle_remove (ConfigList* self) {
	GError * inner_error;
	GtkTreeSelection* _tmp0;
	GtkTreeSelection* sel;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	char* current;
	GFile* current_file;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	sel = (_tmp0 = gtk_tree_view_get_selection (self->priv->tree), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	model = NULL;
	if (!gtk_tree_selection_get_selected (sel, &model, &iter)) {
		(sel == NULL) ? NULL : (sel = (g_object_unref (sel), NULL));
		return;
	}
	current = NULL;
	gtk_tree_model_get (model, &iter, 0, &current, -1);
	current_file = g_file_new_for_path (current);
	{
		GSList* slist;
		GSList* siter;
		slist = gconf_client_get_list (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), GCONF_VALUE_STRING, &inner_error);
		if (inner_error != NULL) {
			goto __catch12_g_error;
			goto __finally12;
		}
		siter = slist;
		while (siter != NULL) {
			GFile* sfile;
			sfile = deja_dup_parse_dir ((const char*) siter->data);
			if (g_file_equal (sfile, current_file)) {
				slist = g_slist_remove_link (slist, siter);
				gconf_client_set_list (((ConfigWidget*) self)->client, config_widget_get_key ((ConfigWidget*) self), GCONF_VALUE_STRING, slist, &inner_error);
				if (inner_error != NULL) {
					(sfile == NULL) ? NULL : (sfile = (g_object_unref (sfile), NULL));
					goto __catch12_g_error;
					goto __finally12;
				}
				(sfile == NULL) ? NULL : (sfile = (g_object_unref (sfile), NULL));
				break;
			}
			siter = siter->next;
			(sfile == NULL) ? NULL : (sfile = (g_object_unref (sfile), NULL));
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_warning ("ConfigList.vala:202: %s\n", e->message);
			(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
			(sel == NULL) ? NULL : (sel = (g_object_unref (sel), NULL));
			current = (g_free (current), NULL);
			(current_file == NULL) ? NULL : (current_file = (g_object_unref (current_file), NULL));
			return;
		}
	}
	__finally12:
	if (inner_error != NULL) {
		(sel == NULL) ? NULL : (sel = (g_object_unref (sel), NULL));
		current = (g_free (current), NULL);
		(current_file == NULL) ? NULL : (current_file = (g_object_unref (current_file), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
	(sel == NULL) ? NULL : (sel = (g_object_unref (sel), NULL));
	current = (g_free (current), NULL);
	(current_file == NULL) ? NULL : (current_file = (g_object_unref (current_file), NULL));
}


static void _config_list_handle_add_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	config_list_handle_add (self);
}


static void _config_list_handle_remove_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	config_list_handle_remove (self);
}


static void _config_list_handle_selection_change_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	config_list_handle_selection_change (self, _sender);
}


static GObject * config_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	ConfigListClass * klass;
	GObjectClass * parent_class;
	ConfigList * self;
	klass = CONFIG_LIST_CLASS (g_type_class_peek (TYPE_CONFIG_LIST));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = CONFIG_LIST (obj);
	{
		GtkListStore* model;
		GtkTreeView* _tmp0;
		GtkCellRendererPixbuf* _tmp1;
		GtkCellRendererText* renderer;
		GtkButton* _tmp2;
		GtkButton* _tmp3;
		GtkHBox* hbox;
		GtkVBox* vbox;
		model = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_ICON, NULL);
		_tmp0 = NULL;
		self->priv->tree = (_tmp0 = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ()), (self->priv->tree == NULL) ? NULL : (self->priv->tree = (g_object_unref (self->priv->tree), NULL)), _tmp0);
		g_object_set ((GObject*) self->priv->tree, "model", model, "headers-visible", FALSE, NULL);
		_tmp1 = NULL;
		gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) (_tmp1 = g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ())), "gicon", 2, NULL);
		(_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL));
		renderer = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ());
		gtk_tree_view_insert_column_with_attributes (self->priv->tree, -1, NULL, (GtkCellRenderer*) renderer, "text", 1, NULL);
		_tmp2 = NULL;
		self->priv->add_button = (_tmp2 = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_ADD)), (self->priv->add_button == NULL) ? NULL : (self->priv->add_button = (g_object_unref (self->priv->add_button), NULL)), _tmp2);
		g_signal_connect_object (self->priv->add_button, "clicked", (GCallback) _config_list_handle_add_gtk_button_clicked, self, 0);
		_tmp3 = NULL;
		self->priv->remove_button = (_tmp3 = g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_REMOVE)), (self->priv->remove_button == NULL) ? NULL : (self->priv->remove_button = (g_object_unref (self->priv->remove_button), NULL)), _tmp3);
		g_signal_connect_object (self->priv->remove_button, "clicked", (GCallback) _config_list_handle_remove_gtk_button_clicked, self, 0);
		hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		vbox = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->add_button, FALSE, FALSE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) self->priv->remove_button, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) self->priv->tree);
		gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
		config_widget_set_from_config ((ConfigWidget*) self);
		config_list_handle_selection_change (self, gtk_tree_view_get_selection (self->priv->tree));
		g_signal_connect_object (gtk_tree_view_get_selection (self->priv->tree), "changed", (GCallback) _config_list_handle_selection_change_gtk_tree_selection_changed, self, 0);
		(model == NULL) ? NULL : (model = (g_object_unref (model), NULL));
		(renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL));
		(hbox == NULL) ? NULL : (hbox = (g_object_unref (hbox), NULL));
		(vbox == NULL) ? NULL : (vbox = (g_object_unref (vbox), NULL));
	}
	return obj;
}


static void config_list_class_init (ConfigListClass * klass) {
	config_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ConfigListPrivate));
	G_OBJECT_CLASS (klass)->constructor = config_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = config_list_finalize;
	CONFIG_WIDGET_CLASS (klass)->set_from_config = config_list_real_set_from_config;
}


static void config_list_instance_init (ConfigList * self) {
	self->priv = CONFIG_LIST_GET_PRIVATE (self);
}


static void config_list_finalize (GObject* obj) {
	ConfigList * self;
	self = CONFIG_LIST (obj);
	(self->priv->tree == NULL) ? NULL : (self->priv->tree = (g_object_unref (self->priv->tree), NULL));
	(self->priv->add_button == NULL) ? NULL : (self->priv->add_button = (g_object_unref (self->priv->add_button), NULL));
	(self->priv->remove_button == NULL) ? NULL : (self->priv->remove_button = (g_object_unref (self->priv->remove_button), NULL));
	G_OBJECT_CLASS (config_list_parent_class)->finalize (obj);
}


GType config_list_get_type (void) {
	static GType config_list_type_id = 0;
	if (config_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigList), 0, (GInstanceInitFunc) config_list_instance_init, NULL };
		config_list_type_id = g_type_register_static (TYPE_CONFIG_WIDGET, "ConfigList", &g_define_type_info, 0);
	}
	return config_list_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




