/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#ifndef __CONFIGWIDGET_H__
#define __CONFIGWIDGET_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define TYPE_CONFIG_WIDGET (config_widget_get_type ())
#define CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIG_WIDGET, ConfigWidget))
#define CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIG_WIDGET, ConfigWidgetClass))
#define IS_CONFIG_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIG_WIDGET))
#define IS_CONFIG_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIG_WIDGET))
#define CONFIG_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIG_WIDGET, ConfigWidgetClass))

typedef struct _ConfigWidget ConfigWidget;
typedef struct _ConfigWidgetClass ConfigWidgetClass;
typedef struct _ConfigWidgetPrivate ConfigWidgetPrivate;

/*
    Déjà Dup
    © 2008—2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
struct _ConfigWidget {
	GtkEventBox parent_instance;
	ConfigWidgetPrivate * priv;
	GConfClient* client;
};

struct _ConfigWidgetClass {
	GtkEventBoxClass parent_class;
	void (*set_from_config) (ConfigWidget* self);
};


void config_widget_set_from_config (ConfigWidget* self);
const char* config_widget_get_key (ConfigWidget* self);
GType config_widget_get_type (void);


G_END_DECLS

#endif
