/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */

#include "PreferencesDialog.h"
#include <stdlib.h>
#include <string.h>
#include <libdeja-dup.h>
#include <glib/gi18n-lib.h>
#include <BackendS3.h>
#include <BackendFile.h>
#include <BackendSSH.h>
#include "ToggleGroup.h"
#include "ConfigBackend.h"
#include "ConfigEntry.h"
#include "ConfigFolder.h"
#include "ConfigNumber.h"
#include "ConfigList.h"
#include "ConfigBool.h"
#include "ConfigPeriod.h"
#include "ConfigChoice.h"




struct _PreferencesDialogPrivate {
	GList** backend_widgets;
	gint backend_widgets_length1;
	gint backend_widgets_size;
	GtkSizeGroup* label_sizes;
	ToggleGroup* periodic_toggle;
};

#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
enum  {
	PREFERENCES_DIALOG_DUMMY_PROPERTY
};
static void _g_list_free_g_object_unref (GList* self);
#define PREFERENCES_DIALOG_FILE_LIST 0
#define PREFERENCES_DIALOG_S3_LIST 1
#define PREFERENCES_DIALOG_SSH_LIST 2
#define PREFERENCES_DIALOG_NUM_LISTS 3
static void preferences_dialog_handle_backend_changed (PreferencesDialog* self, ConfigBackend* backend, const char* val);
static void preferences_dialog_handle_response (PreferencesDialog* self, PreferencesDialog* dlg, gint response);
static void preferences_dialog_handle_link_clicked (PreferencesDialog* self, GtkButton* button);
static void _preferences_dialog_handle_response_gtk_dialog_response (PreferencesDialog* _sender, gint response_id, gpointer self);
static void _preferences_dialog_handle_backend_changed_config_choice_changed (ConfigBackend* _sender, const char* val, gpointer self);
static void _preferences_dialog_handle_link_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer preferences_dialog_parent_class = NULL;
static void preferences_dialog_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


PreferencesDialog* preferences_dialog_construct (GType object_type, GtkWindow* parent) {
	GParameter * __params;
	GParameter * __params_it;
	PreferencesDialog * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "transient-for";
	g_value_init (&__params_it->value, GTK_TYPE_WINDOW);
	g_value_set_object (&__params_it->value, parent);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


PreferencesDialog* preferences_dialog_new (GtkWindow* parent) {
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, parent);
}


static void preferences_dialog_handle_backend_changed (PreferencesDialog* self, ConfigBackend* backend, const char* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (val != NULL);
	{
		gint i;
		i = 0;
		for (; i < PREFERENCES_DIALOG_NUM_LISTS; (i = i + 1)) {
			gboolean show;
			gboolean _tmp0;
			show = FALSE;
			_tmp0 = FALSE;
			if (i == PREFERENCES_DIALOG_S3_LIST) {
				_tmp0 = _vala_strcmp0 (val, "s3") == 0;
			} else {
				_tmp0 = FALSE;
			}
			if (_tmp0) {
				show = TRUE;
			} else {
				gboolean _tmp1;
				_tmp1 = FALSE;
				if (i == PREFERENCES_DIALOG_FILE_LIST) {
					_tmp1 = _vala_strcmp0 (val, "file") == 0;
				} else {
					_tmp1 = FALSE;
				}
				if (_tmp1) {
					show = TRUE;
				} else {
					gboolean _tmp2;
					_tmp2 = FALSE;
					if (i == PREFERENCES_DIALOG_SSH_LIST) {
						_tmp2 = _vala_strcmp0 (val, "ssh") == 0;
					} else {
						_tmp2 = FALSE;
					}
					if (_tmp2) {
						show = TRUE;
					}
				}
			}
			{
				GList* w_collection;
				GList* w_it;
				w_collection = self->priv->backend_widgets[i];
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWidget* _tmp3;
					GtkWidget* w;
					_tmp3 = NULL;
					w = (_tmp3 = (GtkWidget*) w_it->data, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3));
					{
						gtk_widget_set_no_show_all (w, !show);
						if (show) {
							gtk_widget_show_all (w);
						} else {
							gtk_widget_hide (w);
						}
						(w == NULL) ? NULL : (w = (g_object_unref (w), NULL));
					}
				}
			}
		}
	}
}


static void preferences_dialog_handle_response (PreferencesDialog* self, PreferencesDialog* dlg, gint response) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	switch (response) {
		case GTK_RESPONSE_HELP:
		{
			deja_dup_show_uri ((GtkWindow*) dlg, "ghelp:deja-dup#deja-dup-prefs");
			break;
		}
		default:
		{
			gtk_main_quit ();
			break;
		}
	}
}


static void preferences_dialog_handle_link_clicked (PreferencesDialog* self, GtkButton* button) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	deja_dup_show_uri (GTK_WINDOW (gtk_widget_get_toplevel ((GtkWidget*) button)), "http://aws.amazon.com/s3/");
}


static void _preferences_dialog_handle_response_gtk_dialog_response (PreferencesDialog* _sender, gint response_id, gpointer self) {
	preferences_dialog_handle_response (self, _sender, response_id);
}


static void _preferences_dialog_handle_backend_changed_config_choice_changed (ConfigBackend* _sender, const char* val, gpointer self) {
	preferences_dialog_handle_backend_changed (self, _sender, val);
}


static void _preferences_dialog_handle_link_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	preferences_dialog_handle_link_clicked (self, _sender);
}


static GObject * preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	PreferencesDialogClass * klass;
	GObjectClass * parent_class;
	PreferencesDialog * self;
	klass = PREFERENCES_DIALOG_CLASS (g_type_class_peek (TYPE_PREFERENCES_DIALOG));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = PREFERENCES_DIALOG (obj);
	{
		GtkTable* table;
		gint row;
		GtkWidget* w;
		GtkLabel* label;
		GList** _tmp0;
		GtkSizeGroup* _tmp1;
		ConfigBackend* backend;
		GtkLabel* _tmp2;
		GtkWidget* _tmp3;
		GtkButton* button;
		GtkWidget* _tmp4;
		GtkTable* s3_table;
		GtkWidget* _tmp5;
		GtkLabel* _tmp7;
		char* _tmp6;
		GtkWidget* _tmp8;
		GtkLabel* _tmp10;
		char* _tmp9;
		GtkWidget* _tmp11;
		GtkTable* file_table;
		GtkWidget* _tmp12;
		GtkLabel* _tmp14;
		char* _tmp13;
		GtkWidget* _tmp15;
		GtkTable* ssh_table;
		GtkWidget* _tmp16;
		GtkLabel* _tmp18;
		char* _tmp17;
		GtkWidget* _tmp19;
		GtkLabel* _tmp21;
		char* _tmp20;
		GtkWidget* _tmp22;
		GtkLabel* _tmp24;
		char* _tmp23;
		GtkWidget* _tmp25;
		GtkLabel* _tmp27;
		char* _tmp26;
		GtkWidget* _tmp28;
		GtkWidget* _tmp29;
		GtkLabel* _tmp30;
		GtkWidget* _tmp31;
		GtkLabel* _tmp32;
		GtkWidget* _tmp33;
		ConfigBool* periodic_check;
		GtkWidget* _tmp34;
		GtkLabel* _tmp36;
		char* _tmp35;
		ToggleGroup* _tmp37;
		GValue _tmp39 = {0};
		GValue* _tmp38 = {0};
		GValue _tmp40 = {0};
		GValue val;
		g_object_set ((GObject*) self, "title", _ ("Déjà Dup Preferences"), "has-separator", FALSE, NULL);
		gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, GTK_STOCK_HELP, GTK_RESPONSE_HELP, NULL);
		g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _preferences_dialog_handle_response_gtk_dialog_response, self, 0);
		table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 0, (guint) 3, FALSE));
		g_object_set ((GObject*) table, "border-width", 3, NULL);
		row = 0;
		w = NULL;
		label = NULL;
		_tmp0 = NULL;
		self->priv->backend_widgets = (_tmp0 = g_new0 (GList*, PREFERENCES_DIALOG_NUM_LISTS + 1), self->priv->backend_widgets = (_vala_array_free (self->priv->backend_widgets, self->priv->backend_widgets_length1, (GDestroyNotify) _g_list_free_g_object_unref), NULL), self->priv->backend_widgets_length1 = PREFERENCES_DIALOG_NUM_LISTS, self->priv->backend_widgets_size = self->priv->backend_widgets_length1, _tmp0);
		_tmp1 = NULL;
		self->priv->label_sizes = (_tmp1 = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL), (self->priv->label_sizes == NULL) ? NULL : (self->priv->label_sizes = (g_object_unref (self->priv->label_sizes), NULL)), _tmp1);
		backend = g_object_ref_sink (config_backend_new (DEJA_DUP_BACKEND_KEY));
		g_signal_connect_object ((ConfigChoice*) backend, "changed", (GCallback) _preferences_dialog_handle_backend_changed_config_choice_changed, self, 0);
		_tmp2 = NULL;
		label = (_tmp2 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("_Backup location:"))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp2);
		g_object_set ((GObject*) label, "mnemonic-widget", backend, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, (GtkWidget*) backend, (guint) 1, (guint) 2, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp3 = NULL;
		w = (_tmp3 = (GtkWidget*) g_object_ref_sink ((GtkImage*) gtk_image_new_from_stock (GTK_STOCK_HELP, GTK_ICON_SIZE_BUTTON)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp3);
		button = g_object_ref_sink ((GtkButton*) gtk_button_new ());
		g_signal_connect_object (button, "clicked", (GCallback) _preferences_dialog_handle_link_clicked_gtk_button_clicked, self, 0);
		gtk_container_add ((GtkContainer*) button, w);
		gtk_table_attach (table, (GtkWidget*) button, (guint) 2, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 3, (guint) 3);
		_tmp4 = NULL;
		self->priv->backend_widgets[PREFERENCES_DIALOG_S3_LIST] = g_list_append (self->priv->backend_widgets[PREFERENCES_DIALOG_S3_LIST], (_tmp4 = (GtkWidget*) button, (_tmp4 == NULL) ? NULL : g_object_ref (_tmp4)));
		row = row + 1;
		s3_table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 1, (guint) 3, FALSE));
		_tmp5 = NULL;
		w = (_tmp5 = (GtkWidget*) g_object_ref_sink (config_entry_new (DEJA_DUP_S3_ID_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp5);
		_tmp7 = NULL;
		_tmp6 = NULL;
		label = (_tmp7 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp6 = g_strdup_printf ("    %s", _ ("S3 Access Key I_D:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp7);
		_tmp6 = (g_free (_tmp6), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (s3_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 0, (guint) 1, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (s3_table, w, (guint) 1, (guint) 3, (guint) 0, (guint) 1, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp8 = NULL;
		w = (_tmp8 = (GtkWidget*) g_object_ref_sink (config_entry_new (DEJA_DUP_S3_FOLDER_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp8);
		_tmp10 = NULL;
		_tmp9 = NULL;
		label = (_tmp10 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp9 = g_strdup_printf ("    %s", _ ("_Folder:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp10);
		_tmp9 = (g_free (_tmp9), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (s3_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 1, (guint) 2, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (s3_table, w, (guint) 1, (guint) 3, (guint) 1, (guint) 2, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, (GtkWidget*) s3_table, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		_tmp11 = NULL;
		self->priv->backend_widgets[PREFERENCES_DIALOG_S3_LIST] = g_list_append (self->priv->backend_widgets[PREFERENCES_DIALOG_S3_LIST], (_tmp11 = (GtkWidget*) s3_table, (_tmp11 == NULL) ? NULL : g_object_ref (_tmp11)));
		row = row + 1;
		file_table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 1, (guint) 3, FALSE));
		_tmp12 = NULL;
		w = (_tmp12 = (GtkWidget*) g_object_ref_sink (config_folder_new (DEJA_DUP_FILE_PATH_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp12);
		_tmp14 = NULL;
		_tmp13 = NULL;
		label = (_tmp14 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp13 = g_strdup_printf ("    %s", _ ("_Folder:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp14);
		_tmp13 = (g_free (_tmp13), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (file_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 0, (guint) 1, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (file_table, w, (guint) 1, (guint) 3, (guint) 0, (guint) 1, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, (GtkWidget*) file_table, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		_tmp15 = NULL;
		self->priv->backend_widgets[PREFERENCES_DIALOG_FILE_LIST] = g_list_append (self->priv->backend_widgets[PREFERENCES_DIALOG_FILE_LIST], (_tmp15 = (GtkWidget*) file_table, (_tmp15 == NULL) ? NULL : g_object_ref (_tmp15)));
		row = row + 1;
		ssh_table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 4, (guint) 3, FALSE));
		_tmp16 = NULL;
		w = (_tmp16 = (GtkWidget*) g_object_ref_sink (config_entry_new (DEJA_DUP_SSH_USERNAME_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp16);
		_tmp18 = NULL;
		_tmp17 = NULL;
		label = (_tmp18 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp17 = g_strdup_printf ("    %s", _ ("_Username:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp18);
		_tmp17 = (g_free (_tmp17), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (ssh_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 0, (guint) 1, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (ssh_table, w, (guint) 1, (guint) 3, (guint) 0, (guint) 1, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp19 = NULL;
		w = (_tmp19 = (GtkWidget*) g_object_ref_sink (config_entry_new (DEJA_DUP_SSH_SERVER_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp19);
		_tmp21 = NULL;
		_tmp20 = NULL;
		label = (_tmp21 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp20 = g_strdup_printf ("    %s", _ ("_Server:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp21);
		_tmp20 = (g_free (_tmp20), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (ssh_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 1, (guint) 2, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (ssh_table, w, (guint) 1, (guint) 3, (guint) 1, (guint) 2, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp22 = NULL;
		w = (_tmp22 = (GtkWidget*) g_object_ref_sink (config_number_new (DEJA_DUP_SSH_PORT_KEY, 1, 100000)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp22);
		_tmp24 = NULL;
		_tmp23 = NULL;
		label = (_tmp24 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp23 = g_strdup_printf ("    %s", _ ("_Port:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp24);
		_tmp23 = (g_free (_tmp23), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (ssh_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 2, (guint) 3, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (ssh_table, w, (guint) 1, (guint) 3, (guint) 2, (guint) 3, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp25 = NULL;
		w = (_tmp25 = (GtkWidget*) g_object_ref_sink (config_entry_new (DEJA_DUP_SSH_DIRECTORY_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp25);
		_tmp27 = NULL;
		_tmp26 = NULL;
		label = (_tmp27 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp26 = g_strdup_printf ("    %s", _ ("_Folder:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp27);
		_tmp26 = (g_free (_tmp26), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (ssh_table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) 3, (guint) 4, 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (ssh_table, w, (guint) 1, (guint) 3, (guint) 3, (guint) 4, GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, (GtkWidget*) ssh_table, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
		_tmp28 = NULL;
		self->priv->backend_widgets[PREFERENCES_DIALOG_SSH_LIST] = g_list_append (self->priv->backend_widgets[PREFERENCES_DIALOG_SSH_LIST], (_tmp28 = (GtkWidget*) ssh_table, (_tmp28 == NULL) ? NULL : g_object_ref (_tmp28)));
		row = row + 1;
		_tmp29 = NULL;
		w = (_tmp29 = (GtkWidget*) g_object_ref_sink (config_list_new (DEJA_DUP_INCLUDE_LIST_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp29);
		_tmp30 = NULL;
		label = (_tmp30 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("I_nclude:"))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp30);
		g_object_set ((GObject*) label, "use-underline", TRUE, "xalign", 0.0f, "yalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 3, (guint) 3);
		row = row + 1;
		_tmp31 = NULL;
		w = (_tmp31 = (GtkWidget*) g_object_ref_sink (config_list_new (DEJA_DUP_EXCLUDE_LIST_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp31);
		_tmp32 = NULL;
		label = (_tmp32 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("E_xclude:"))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp32);
		g_object_set ((GObject*) label, "use-underline", TRUE, "xalign", 0.0f, "yalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, (guint) 3, (guint) 3);
		row = row + 1;
		_tmp33 = NULL;
		w = (_tmp33 = (GtkWidget*) g_object_ref_sink (config_bool_new (DEJA_DUP_ENCRYPT_KEY, _ ("_Encrypt backup files"))), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp33);
		gtk_table_attach (table, w, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		row = row + 1;
		periodic_check = g_object_ref_sink (config_bool_new (DEJA_DUP_PERIODIC_KEY, _ ("_Automatically backup on a regular schedule")));
		gtk_table_attach (table, (GtkWidget*) periodic_check, (guint) 0, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		row = row + 1;
		_tmp34 = NULL;
		w = (_tmp34 = (GtkWidget*) g_object_ref_sink (config_period_new (DEJA_DUP_PERIODIC_PERIOD_KEY)), (w == NULL) ? NULL : (w = (g_object_unref (w), NULL)), _tmp34);
		_tmp36 = NULL;
		_tmp35 = NULL;
		label = (_tmp36 = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp35 = g_strdup_printf ("    %s", _ ("How _often to backup:")))), (label == NULL) ? NULL : (label = (g_object_unref (label), NULL)), _tmp36);
		_tmp35 = (g_free (_tmp35), NULL);
		g_object_set ((GObject*) label, "mnemonic-widget", backend, "use-underline", TRUE, "xalign", 0.0f, NULL);
		gtk_size_group_add_widget (self->priv->label_sizes, (GtkWidget*) label);
		gtk_table_attach (table, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) row, (guint) (row + 1), 0, GTK_FILL, (guint) 3, (guint) 3);
		gtk_table_attach (table, w, (guint) 1, (guint) 3, (guint) row, (guint) (row + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 3, (guint) 3);
		_tmp37 = NULL;
		self->priv->periodic_toggle = (_tmp37 = toggle_group_new ((Togglable*) periodic_check), (self->priv->periodic_toggle == NULL) ? NULL : (self->priv->periodic_toggle = (g_object_unref (self->priv->periodic_toggle), NULL)), _tmp37);
		toggle_group_add_dependent (self->priv->periodic_toggle, (GtkWidget*) label);
		toggle_group_add_dependent (self->priv->periodic_toggle, w);
		toggle_group_check (self->priv->periodic_toggle);
		row = row + 1;
		val = (_tmp40 = G_IS_VALUE (&(*(_tmp38 = config_choice_get_current_value ((ConfigChoice*) backend)))) ? (g_value_init (&_tmp39, G_VALUE_TYPE (&(*(_tmp38 = config_choice_get_current_value ((ConfigChoice*) backend))))), g_value_copy (&(*(_tmp38 = config_choice_get_current_value ((ConfigChoice*) backend))), &_tmp39), _tmp39) : (*(_tmp38 = config_choice_get_current_value ((ConfigChoice*) backend))), (_tmp38 == NULL) ? NULL : (_tmp38 = (g_free (_tmp38), NULL)), _tmp40);
		preferences_dialog_handle_backend_changed (self, backend, g_value_get_string (&val));
		gtk_container_add ((GtkContainer*) ((GtkDialog*) self)->vbox, (GtkWidget*) table);
		(table == NULL) ? NULL : (table = (g_object_unref (table), NULL));
		(w == NULL) ? NULL : (w = (g_object_unref (w), NULL));
		(label == NULL) ? NULL : (label = (g_object_unref (label), NULL));
		(backend == NULL) ? NULL : (backend = (g_object_unref (backend), NULL));
		(button == NULL) ? NULL : (button = (g_object_unref (button), NULL));
		(s3_table == NULL) ? NULL : (s3_table = (g_object_unref (s3_table), NULL));
		(file_table == NULL) ? NULL : (file_table = (g_object_unref (file_table), NULL));
		(ssh_table == NULL) ? NULL : (ssh_table = (g_object_unref (ssh_table), NULL));
		(periodic_check == NULL) ? NULL : (periodic_check = (g_object_unref (periodic_check), NULL));
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	return obj;
}


static void preferences_dialog_class_init (PreferencesDialogClass * klass) {
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->constructor = preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}


static void preferences_dialog_instance_init (PreferencesDialog * self) {
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void preferences_dialog_finalize (GObject* obj) {
	PreferencesDialog * self;
	self = PREFERENCES_DIALOG (obj);
	self->priv->backend_widgets = (_vala_array_free (self->priv->backend_widgets, self->priv->backend_widgets_length1, (GDestroyNotify) _g_list_free_g_object_unref), NULL);
	(self->priv->label_sizes == NULL) ? NULL : (self->priv->label_sizes = (g_object_unref (self->priv->label_sizes), NULL));
	(self->priv->periodic_toggle == NULL) ? NULL : (self->priv->periodic_toggle = (g_object_unref (self->priv->periodic_toggle), NULL));
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType preferences_dialog_get_type (void) {
	static GType preferences_dialog_type_id = 0;
	if (preferences_dialog_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "PreferencesDialog", &g_define_type_info, 0);
	}
	return preferences_dialog_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




