/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dumb memory allocation routines
 *
 *  Copyright (C) 1996 Maurizio Plaza
 *                1996 Jakub Jelinek
 *                2004 Thiemo Seufer
 */

#include "delo.h"

extern char _malloc_start;
static char *malloc_ptr = &_malloc_start;
static char *last_alloc = NULL;

void *malloc_aligned(size_t size, size_t align)
{
	if (align < 8)
		align = 8;
	--align;
	last_alloc = (char *)((((size_t)malloc_ptr) + align) & ~align);
	malloc_ptr = last_alloc + size;
	return last_alloc;
}

void *malloc(size_t size)
{
	return malloc_aligned(size, 8);
}

void free(void *m)
{
	if (m == last_alloc)
		malloc_ptr = last_alloc;
}

void *realloc(UNUSED void *p, UNUSED size_t size)
{
	return NULL; /* We do not support this. */
}
