/* csoundplayback.cpp
 *
 * CSound playback functions, 
 * runs csound with -g -W flags (creates wav file)
 * for Denemo, a GTK Frontend to GNU Lilypond
 *
 * (c) 2002 Adam Tee 
 */

#include "csoundplayback.h"
#include "exportcsound.h"
#include "prefops.h"
#include "utils.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#include <errno.h>

struct callbackdata {
  GtkWidget *entry;
  GtkWidget *csoundpath;
  GtkWidget *rt;
  struct scoreinfo *si;
};

static GString *orcfilename;

void csoundplayback(gpointer callback_data, guint callback_action,
		     GtkWidget *widget)
{
  GtkWidget *dialog;
  GtkWidget *entry;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *csoundentry;
  GtkWidget *rt;
  GtkWidget *okbutton;
  GtkWidget *cancelbutton;
  static struct callbackdata cbdata;
  struct scoreinfo *si = (struct scoreinfo *)callback_data;
  

  dialog = gtk_dialog_new();
  

  table = gtk_table_new(2,3,TRUE);
  label = gtk_label_new(_("Orchestra File"));
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0,1,0,1);
  gtk_widget_show(label);

  entry = gtk_entry_new();
  if(orcfilename)
    gtk_entry_set_text(GTK_ENTRY(entry), orcfilename->str);
  gtk_table_attach_defaults(GTK_TABLE(table),entry, 1,2,0,1);
  gtk_widget_show(entry);


  label = gtk_label_new(_("CSound Path"));
  gtk_table_attach_defaults(GTK_TABLE(table),label, 0,1,1,2);
  gtk_widget_show(label);

  csoundentry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(csoundentry), "csound -d -W");
  gtk_table_attach_defaults(GTK_TABLE(table),csoundentry, 1,2,1,2);
  gtk_widget_show(csoundentry);


  label = gtk_label_new(_("RealTime playback"));
  gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,2,3);
  gtk_widget_show(label);

  rt = gtk_check_button_new();
  gtk_table_attach_defaults(GTK_TABLE(table),rt,1,2,2,3);
  gtk_widget_show(rt);

  
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), table, TRUE, TRUE,0);
  gtk_widget_show(table);

  cbdata.entry = entry;
  cbdata.si = si;
  cbdata.csoundpath = csoundentry;
  cbdata.rt = rt;

  okbutton = gtk_button_new_with_label(_("OK"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), okbutton,
		     TRUE, TRUE,0);
  gtk_signal_connect(GTK_OBJECT(okbutton), "clicked",
		     GTK_SIGNAL_FUNC(csoundplay),
		     &cbdata);
  gtk_signal_connect_object(GTK_OBJECT(okbutton),"clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_destroy),
			    GTK_OBJECT(dialog));
  gtk_widget_show(okbutton);
  
  cancelbutton = gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), cancelbutton,
		     TRUE, TRUE,0);
  gtk_signal_connect_object(GTK_OBJECT(cancelbutton),"clicked",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			    GTK_OBJECT(dialog));
  gtk_widget_show(cancelbutton);

  gtk_widget_grab_focus(entry);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
  gtk_widget_show(dialog);
}


void csoundplay(GtkWidget *widget, gpointer data) 
{
  static GString *filename;
  static GString *passtosystem;
  static GString *outputfile;


  pid_t pid;
  struct callbackdata *cbdata = (struct callbackdata *)data;
  struct scoreinfo *si = (struct scoreinfo *)cbdata->si;
  gchar *orcname = (gchar*)gtk_entry_get_text(GTK_ENTRY(cbdata->entry));
  gchar *csound = (gchar*)gtk_entry_get_text(GTK_ENTRY(cbdata->csoundpath));
  gboolean realtime = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cbdata->rt));
  
  if(!filename)
    {
      filename = g_string_new(locatedotdenemo());
      g_string_append(filename, "/denemocsoundplayback");
      if(realtime)
	outputfile = g_string_new("devaudio");
      else {
	outputfile = g_string_new(locatedotdenemo());
	g_string_append(outputfile, "/denemocsoundplayback.wav");
      }
      passtosystem = g_string_new(NULL);
      orcfilename = g_string_new(NULL);
    }

  g_string_assign(orcfilename, orcname);

  
#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork();
#endif

  if(pid == -1)
    {
      fprintf(stderr, "%s: Failed to fork()\n", strerror(errno));
      return;
    }
  else if(pid == 0)
    {
      int status = 0;
      exportcsound(filename->str,si,si->start, si->end);

      g_string_assign(passtosystem, csound);
      g_string_append(passtosystem, " ");
      g_string_append(passtosystem, orcfilename->str);
      g_string_append(passtosystem, " ");
      g_string_append(passtosystem, filename->str);
      g_string_append(passtosystem, " -o ");
      g_string_append(passtosystem, outputfile->str);
      
      status = system(passtosystem->str);
      
      if(!status) {

	g_string_assign(passtosystem, si->prefs->audioplayer->str);
	g_string_append(passtosystem, " ");
	g_string_append(passtosystem, outputfile->str);

	system(passtosystem->str);
      }
      _exit(0);
    }

}
