/* drawlilydir.cpp
 *
 * Functions for drawing stemming directives
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Adam Tee
 */

#include "utils.h"		/* Includes <gdk.h> */
#include <denemo/denemo.h>
#include <string.h>


void
draw_lily_dir (GdkPixmap * pixmap, GdkGC * gc, GdkFont * font,
	       gint xx, gint y, mudelaobject * theobj)
{

  static GdkFont *lily_directive_font = NULL;

  if (!lily_directive_font)
    {
      lily_directive_font =
	gdk_fontset_load
	("-*-helvetica-medium-r-normal-*-12-*-*-*-*-*-iso8859-*");
      if(lily_directive_font)
	lily_directive_font = font;
    }
 
  gdk_draw_text (pixmap, lily_directive_font, gc, xx, y - 4, 
		 ((lilydirective *)theobj->object)->directive->str, 
		 ((lilydirective *)theobj->object)->directive->len);
  
    
}
