/**
 * exportcsound.cpp
 *
 * Functions for exporting in CSound Score format
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2002 Adam Tee
 */

#include "frogio.h"
#include "exportcsound.h"
#include "utils.h"

gchar pitch2char(int pitch)
{
  gchar note = 'c';
  switch(offsettonumber(pitch))
    {
    case 0:
      note = 'c';
      break;
    case 1:
      note = 'd';
      break;
    case 2:
      note = 'e';
      break;
    case 3:
      note = 'f';
      break;
    case 4:
      note = 'g';
      break;
    case 5:
      note = 'a';
      break;
    case 6:
      note = 'b';
      break;
     default:
      note = ' ';
      break;
    }

  return(note);
}



float duration2time(int duration, int dots, int tempo)
{
  float realtimeduration = 0.0;

  realtimeduration = (durationtofloat(duration,dots) * 60) / tempo;

  return realtimeduration;
}

float pitchtopch(gchar pitch, int enshift, int octave)
{
  float pch = 0.0;

  /*Set pitch value */
  if(pitch == 'c')
    pch = .00;
  else if(pitch == 'd')
    pch = .02;
  else if(pitch == 'e')
    pch = .04;
  else if(pitch == 'f')
    pch = .05;
  else if(pitch == 'g')
    pch = .07;
  else if(pitch == 'a')
    pch = .09;
  else if(pitch == 'b')
    pch = .11;
  /* Set enharmonic accidental*/
  if(enshift == 1)
    pch += .01;
  else if( enshift == 2)
    pch += .02;
  else if(enshift == -1)
    pch -=.01;
  else if(enshift == -2)
    pch -= .02;
  /* Set octave */
  if(octave == 0)
    pch += 4.00;
  else if(octave == 1) 
    pch += 5.00;
  else if(octave == 2)
    pch += 6.00;
  else if(octave == 3)
    pch += 7.00;
  else if(octave == 4)
    pch += 8.00;
  else if(octave == 5)
    pch += 9.00;
  else if(octave == 6)
    pch += 10.00;
  else if(octave == 7)
    pch += 11.00;



  return pch;
}


int exportcsound(gchar *thefilename, struct scoreinfo *si, gint start,
		  gint end)
{
  FILE *fp;
  staffnode *curstaff = NULL;
  staff *curstaffstruct = NULL, *extravoice = NULL;
  
  gint i = 0;

  if((fp = fopen((char *)thefilename, "w")) == NULL)
    {
      g_print(_("Cannot open file %s"),thefilename);
      return -1;
    }
  
  fprintf(fp,"f 1 0 8192 10 1;  A SINE WAVE\n");

  for(curstaff = si->thescore, i=1; curstaff; curstaff = curstaff->next, i++)
    {
      curstaffstruct = (staff *)curstaff->data;
      write_stave(fp, curstaffstruct, i,start, end, si);
      fprintf(fp,"\n");
    }
  fprintf(fp,"e");
  fclose(fp);
  return 0;
}

int write_stave(FILE *fp, staff *curstaffstruct, gint i, gint start, gint end,
		struct scoreinfo *si)
{
  measurenode *curmeasure;
  objnode *curobj;
  mudelaobject *mudelaitem;
  float current_time = 0.0;
  float duration = 0.0, total_duration;
  float prevdur = 0.0;
  GList *node = NULL;
  gboolean is_tied = FALSE;
  
  
  for(curmeasure = (measurenode *)curstaffstruct->measures;
      curmeasure; curmeasure = curmeasure->next)
    {
      for(curobj =(objnode *)curmeasure->data; curobj; curobj = curobj->next)
	{
	  mudelaitem = (mudelaobject *)curobj->data;
	  note *newnote = NULL;
	  switch(mudelaitem->type)
	    {
	    case CHORD:
	      
	      node = ((chord *)mudelaitem->object)->tones;
	      

	      duration = 
		duration2time(((chord *)mudelaitem->object)->baseduration,
			      ((chord *)mudelaitem->object)->numdots,
			      si->tempo);
	     
	      /*if(((chord *)mudelaitem->object)->has_stacatto_p)
		duration = total_duration * 0.5;
	      else if(((chord *)mudelaitem->object)->has_tenuto_p)
		duration = total_duration;
	      else 
	      duration = total_duration * 0.75;*/
		
	      if(((chord *)mudelaitem->object)->is_tied) 
		{
		  is_tied = !is_tied;
		  prevdur = duration;
		}
	      else
		{
		  if(node != NULL)
		    {
		      for(;node; node = node->next)
			{
			  newnote = (note *)node->data;
			  int octave = pitchtooctave(newnote->mid_c_offset);
			  float pitch  = 
			    pitchtopch(pitch2char(newnote->mid_c_offset),
				       newnote->enshift,
				       octave);
			  if(is_tied) {
			    fprintf(fp,"i %d %.4f %.3f 7000 %.2f\n", i, 
				    current_time-prevdur,
				    (0.99*(duration+prevdur)), pitch);
			    //current_time += prevdur;
			    prevdur = 0.0;
			    is_tied = FALSE;
			  }
			  else {
			    fprintf(fp,"i %d %.4f %.3f 8000 %.2f\n", i, 
				    current_time,
				    (0.99*duration), pitch);
			    
			  }
			}
		    }
		  else 
		    {
		      is_tied = FALSE;
		      prevdur = 0.0;
		    
		    }
		}
	      
	      current_time += duration;
	      break;
	    case TUPOPEN:
	    case TUPCLOSE:
	    case CLEF:
	    case TIMESIG:
	    case KEYSIG:
	    case BARLINE:
	    case LILYDIRECTIVE:
	    case COMMENT:
	    case STEMDIRECTIVE:
	    case MEASUREBREAK:
	    case DYNAMIC:
	    case GRACE_START:
	    case GRACE_END:
	    default:
	      break;
	    }
	}
    }
  return 0;
} 
