/* view.h
 * Header file for functions for creating new views of 
 * the main window
 * 
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 2003 Adam Tee
 */

#ifndef VIEW_H
#define VIEW_H
#include "commandfuncs.h"
#include "config.h"
#include "draw.h"		/* Which includes gtk.h */
#include <denemo/denemo.h>
#include "dialogs.h"
#include "exportmudela.h"
#include "file.h"
#include "gcs.h"
#include "kbd-custom.h"
#include "kbd-interface.h"
#include "keyresponses.h"
#include "contexts.h"
#include "help.h"
#include "midi.h"
#include "mousing.h"
#include "moveviewport.h"
#include "prefops.h"
#include "scoreops.h"
#include "selectops.h"
#include "staffops.h"
#include "utils.h"
#include "lilydirectives.h"
#include "dynamic.h"
#include "lyric.h"
#include "figure.h"
#include "changenotehead.h"
#include "articulations.h"
#include "csoundplayback.h"
#include "print.h"
#include "barline.h"
#include "plugin.h"
#include "runsilent.h"

void newview(void);
void createview(gpointer data, guint callback_action, GtkWidget *widget);
void closeit (GtkWidget * widget, gpointer data);
void close_application (GtkWidget * widget, GdkEvent * event, gpointer data);
void closewrapper (gpointer data, guint callback_action, GtkWidget * widget);
void openinnew(gpointer data, guint callback_action, GtkWidget *widget);
void close_view( GtkWidget *widget, gpointer data);
void closeview(gpointer data, guint callback_action, GtkWidget *widget);
#endif 
