/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef IMLIB
#include <Imlib.h>
#endif

#include "pixmap.h"
#include "gif.h"
#include "global.h"
#include "color.h"
#include <stdlib.h>
#include <stdio.h>
#include <X11/xpm.h>

GC pgc=0,pgcs=0;

#define COLORARRAY 70

void EvaluatePixels(Pixmap *p,Pixmap *s,unsigned long pixel,int npoints,XPoint *points)
{
  if (npoints>0) {
    if (pixel>0xff000000) {
      if (s!=0)
        XDrawPoints(GetDisplay(),*s,pgcs,points,npoints,CoordModeOrigin);
    } else {
      XSetForeground(GetDisplay(),pgc,pixel);
      XDrawPoints(GetDisplay(),*p,pgc,points,npoints,CoordModeOrigin);      
    }
  }
}


void MakePixmapFromXpmImage(XpmImage *I,Pixmap *p,Pixmap *s)
{
  XColor color;
  unsigned long i,x,y;
  unsigned long *pixel;
  int shape;
  XPoint **pointmatrix;
  int *npoints;  

  pixel=malloc(sizeof(unsigned long)*(I->ncolors));
  pointmatrix=malloc(sizeof(XPoint*)*(I->ncolors));
  npoints=malloc(sizeof(int)*I->ncolors);
  shape=False;
  for (i=0;i<(I->ncolors);i++) {
    npoints[i]=0;
    pointmatrix[i]=malloc(sizeof(XPoint)*COLORARRAY);
    if (XParseColor(GetDisplay(),XDefaultColormap(GetDisplay(),XDefaultScreen(GetDisplay())),
		    (I->colorTable)[i].c_color,&color)==0) {
      pixel[i]=0xffffffff;
      shape=True;
    } else
      pixel[i]=GetBestColor(color.red,color.green,color.blue);
  }

  *p=XCreatePixmap(GetDisplay(),XDefaultRootWindow(GetDisplay()),I->width,I->height,
		   XDefaultDepth(GetDisplay(),0));

  if (pgc==0)
    pgc=XCreateGC(GetDisplay(),*p,0,0);
  if (s!=NULL && shape==True) {
    *s=XCreatePixmap(GetDisplay(),XDefaultRootWindow(GetDisplay()),I->width,I->height,1);
    if (pgcs==0)
      pgcs=XCreateGC(GetDisplay(),*s,0,0);
    XSetForeground(GetDisplay(),pgcs,1);
    XFillRectangle(GetDisplay(),*s,pgcs,0,0,I->width,I->height);
    XSetForeground(GetDisplay(),pgcs,0);
  } else
    if (s!=NULL)
      *s=0;
  i=0;
  for (y=0;y<(I->height);y++) {
    for (x=0;x<(I->width);x++) {
      pointmatrix[I->data[i]][npoints[I->data[i]]].x=x;
      pointmatrix[I->data[i]][npoints[I->data[i]]].y=y;
      npoints[I->data[i]]++;
      if (npoints[I->data[i]]==COLORARRAY) {
	EvaluatePixels(p,s,pixel[I->data[i]],npoints[I->data[i]],pointmatrix[I->data[i]]);
	npoints[I->data[i]]=0;
      }
      i++;
    }
  }
  for (i=0;i<(I->ncolors);i++) {
    EvaluatePixels(p,s,pixel[i],npoints[i],pointmatrix[i]);
    free(pointmatrix[i]);
  }

  free(npoints);
  free(pointmatrix);
  free(pixel);
}

void ShrinkXpmImage(int newsizex,int newsizey,XpmImage *I,XpmImage *Idestingation)
{
  int getr,getg,getb;
  int *shrinknumbers;
  double *shrinkred;
  double *shrinkgreen;
  double *shrinkblue;
  int *myshape;
  XColor *mycolor;
  int i,k,r,g,b,x,y;

  mycolor=malloc(I->ncolors*sizeof(XColor));
  myshape=malloc(I->ncolors*sizeof(int));

  Idestingation->width=newsizex;
  Idestingation->height=newsizey;
  Idestingation->cpp=1;
  Idestingation->ncolors=65;
  Idestingation->colorTable=malloc(65*sizeof(XpmColor));
  Idestingation->data=malloc(newsizex*newsizey*sizeof(int));

  shrinknumbers=malloc(newsizex*newsizey*sizeof(int));
  shrinkred  =malloc(newsizex*newsizey*sizeof(double));
  shrinkgreen=malloc(newsizex*newsizey*sizeof(double));
  shrinkblue =malloc(newsizex*newsizey*sizeof(double));

  for (r=0;r<4;r++) {
    getr=(r<<2)|r;
    for (g=0;g<4;g++) {
      getg=(g<<2)|g;
      for (b=0;b<4;b++) {
        getb=(b<<2)|b;
        i=r*16+g*4+b;
        (Idestingation->colorTable)[i].string=NULL;
        (Idestingation->colorTable)[i].symbolic=NULL;
        (Idestingation->colorTable)[i].m_color=NULL;
        (Idestingation->colorTable)[i].g4_color=NULL;
        (Idestingation->colorTable)[i].g_color=NULL;
        (Idestingation->colorTable)[i].c_color=malloc(5);
        sprintf((Idestingation->colorTable)[i].c_color,"#%x%x%x",getr,getg,getb);
      }
    }
  }
  (Idestingation->colorTable)[64].string=NULL;
  (Idestingation->colorTable)[64].symbolic=NULL;
  (Idestingation->colorTable)[64].m_color=NULL;
  (Idestingation->colorTable)[64].g4_color=NULL;
  (Idestingation->colorTable)[64].g_color=NULL;
  (Idestingation->colorTable)[64].c_color=malloc(5);
  sprintf((Idestingation->colorTable)[64].c_color,"None");
  
  for (i=0;i<(I->ncolors);i++) {
    if (XParseColor(GetDisplay(),XDefaultColormap(GetDisplay(),XDefaultScreen(GetDisplay())),
		    (I->colorTable)[i].c_color,&(mycolor[i]))==0) 
      myshape[i]=True;
    else
      myshape[i]=False;
  }
  for (i=0;i<newsizey*newsizex;i++) {
    shrinknumbers[i]=0;
    shrinkred[i]=0.0; 
    shrinkgreen[i]=0.0; 
    shrinkblue[i]=0.0; 
  }
  k=0;
  for (y=0;y<(I->height);y++) {
    for (x=0;x<(I->width);x++) {
      if (myshape[I->data[k]]==False) {
	i=(int)((newsizex-1)*(double)x/(I->width-1))+newsizex*
	  (int)((newsizey-1)*(double)y/(I->height-1));
        shrinknumbers[i]++;
        shrinkred[i]=shrinkred[i]+mycolor[I->data[k]].red; 
        shrinkgreen[i]=shrinkgreen[i]+mycolor[I->data[k]].green; 
        shrinkblue[i]=shrinkblue[i]+mycolor[I->data[k]].blue; 
      }
      k++;
    }
  }
  for (i=0;i<newsizey*newsizex;i++) {
    if (shrinknumbers[i]==0)
      Idestingation->data[i]=64;
    else
      Idestingation->data[i]=(((int)(shrinkred[i]/shrinknumbers[i])>>14)<<4)|
	                     (((int)(shrinkgreen[i]/shrinknumbers[i])>>14)<<2)|
	                     ( (int)(shrinkblue[i]/shrinknumbers[i])>>14);
  }

  free(mycolor);
  free(myshape);
  free(shrinknumbers);
  free(shrinkred);
  free(shrinkgreen);
  free(shrinkblue);
}

int LoadPixmap(char *filename,int little,Pixmap *p,Pixmap *s)
{
#ifdef IMLIB
  static ImlibData *hImlib = 0;
  ImlibImage *image;

  if(!hImlib) hImlib=Imlib_init(GetDisplay());
  image = Imlib_load_image(hImlib, filename);
  if (image) {
    if (little==0)
      Imlib_render(hImlib, image, image->rgb_width, image->rgb_height);
    else
      Imlib_render(hImlib, image, little, little);
    *p=(Pixmap)Imlib_copy_image(hImlib, image);
    if (s!=NULL)
      *s=(Pixmap)Imlib_copy_mask(hImlib, image);
    Imlib_destroy_image(hImlib, image);
    return 0;
  } else 
    return -1;
#else
  XpmImage I;
  XpmImage I2;
  int ret;

  ret=XpmReadFileToXpmImage(filename,&I,NULL);
  if (ret==0){
    if (little==0)
      MakePixmapFromXpmImage(&I,p,s);
    else {
      ShrinkXpmImage(little,little,&I,&I2);
      MakePixmapFromXpmImage(&I2,p,s);
      XpmFreeXpmImage(&I2);
    }
    XpmFreeXpmImage(&I);
  } else {
    *p=0;
    if (s!=NULL)
      *s=0;
  }
  return (ret);
#endif
}

int DataPixmap(char **data,Pixmap *p,Pixmap *s)
{
  XpmImage I;
  int ret;

  ret=XpmCreateXpmImageFromData(data,&I,NULL);
  if (ret==0){
    MakePixmapFromXpmImage(&I,p,s);
    XpmFreeXpmImage(&I);
  } else {
    *p=0;
    if (s!=NULL)
      *s=0;
  }
  return (ret);
}
