#!/usr/bin/env ruby

require 'xapian'

if ARGV.size != 1
  $stderr.puts "Usage: #{$0} PATH_TO_DATABASE"
  exit 99
end

# Open the database for update, creating a new database if necessary.
database = Xapian::WritableDatabase.new(ARGV[0], Xapian::DB_CREATE_OR_OPEN)

indexer = Xapian::TermGenerator.new()
stemmer = Xapian::Stem.new("english")
indexer.stemmer = stemmer

para = ''
while line = $stdin.gets()
  line.strip!()
  if line.empty?
    if not para.empty?
      # We've reached the end of a paragraph, so index it.
      doc = Xapian::Document.new()
      doc.data = para

      indexer.document = doc
      indexer.index_text(para)

      # Add the document to the database
      database.add_document(doc)
      para = ''
    end # if not para.empty?
  else # line not empty
    para += ' ' if para != ''
    para += line
  end # if line empty
end

