/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/logger/intending_file_logger.cpp
 *
 * @brief [LEVEL: beta] Implementation of the @ref ::diagnostics::Intending_File_Logger class
 *
 * $Id: intending_file_logger.cpp,v 1.4 2005/06/23 09:54:21 esdentem Exp $
 *
 * @author Christian Schallhart
 */
#include <diagnostics/logger/intending_file_logger.hpp>

#include <diagnostics/frame/logging_config_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

Intending_File_Logger::~Intending_File_Logger()
{
}

Intending_File_Logger::Intending_File_Logger(::std::string const & file_name) :
    Intending_Stream_Logger(m_file_stream),
    m_file_stream(file_name.c_str(),::std::ios::app)
{
    if(!m_file_stream.good()) throw Logging_Config_Exception("Could not open file '" + file_name + "'");
}

Intending_File_Logger::Intending_File_Logger(::std::string const & file_name, ::std::ofstream::openmode const mode) :
    Intending_Stream_Logger(m_file_stream),
    m_file_stream(file_name.c_str(),mode)
{
    if(!m_file_stream.good()) throw Logging_Config_Exception("Could not open file '" + file_name + "'");
}


void Intending_File_Logger::close()
{
    m_file_stream.close();
}


DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
