/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_logger.ts.cpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::testing::Dummy_Logger
 */


#include <diagnostics/util/dummy_logger.ts.hpp>

#include <diagnostics/frame/record.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

Dummy_Logger::Dummy_Logger() 
    : m_records(),
      m_is_closed(0)
{
}
    
void Dummy_Logger::log(Record const & record)
{
    m_records.push_back(record);
}

void Dummy_Logger::close()
{
    ++m_is_closed;
}


TEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
