/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

struct s_lista_cefv {
	gchar *definicion;
	gchar *rama;
	gchar *archivo;
	GtkCTreeNode *nodo;
	struct s_lista_cefv *anterior;
	struct s_lista_cefv *siguiente;
	struct s_lista_cefv *hijos;
};

//*******************************************************************

GtkCTreeNode *cefv_clases;
GtkCTreeNode *cefv_estructuras;
GtkCTreeNode *cefv_funciones;
GtkCTreeNode *cefv_bariables;
GtkCTreeNode *cefv_enumeraciones;
GtkCTreeNode *cefv_uniones;
GtkCTreeNode *cefv_tipos;
struct s_lista_cefv *lista_cefv;
gboolean cefv_congelar_lista_combo; // esto impide que el evento de que la seleccion de la lista de funciones a sido cambiado se ejecute constantemente durante su actualizacion
GList *cefv_lista_combo;

//*******************************************************************

void cefv_inicializar(void);

void cefv_crear(void);

void cefv_anadir(gchar *tag_line);

int cefv_analizar_archivo(gchar *nombre);

void cefv_eliminar_archivo(gchar *nombre);
