/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void gen_salir(void)
{
	edit_cerrar();
	pref_cerrar();
	xmlFreeDoc(proyecto.xml);
	g_free(proyecto.archivo);
	if (texto_busqueda_actual != NULL)
		g_free(texto_busqueda_actual);
	g_free(pro_proyecto_cargar);
	gtk_main_quit();
}

void gen_cerrar_ventana(GtkWidget *widget)
{
	GtkWidget *ventana;
	
	ventana=gtk_widget_get_toplevel(widget);
	gtk_widget_destroy(ventana);
}

void gen_anadir(GtkWidget *widget)
{
	GtkCTreeNode *nodo_arbol;
	GtkWidget *ventana;
	gchar *archivo;
	guint cont;
	gchar *destino;
	
	ventana=gtk_widget_get_toplevel(widget);
	archivo=gtk_file_selection_get_filename(GTK_FILE_SELECTION(ventana));
	for (cont=0;archivo[cont]!=0;cont++);
	for (;archivo[cont]!='/';cont--);
	cont++;
	
	if (!edit_repetido(archivo+cont)) {
		nodo_arbol=arch_anadir(archivo+cont);
		edit_anadir(archivo,nodo_arbol);
		pro_anadir(archivo+cont);
		pro_guardar();
		destino=pro_nombre_completo_archivo(archivo+cont,FALSE);
		edit_ver(archivo+cont);
		if (strcmp(destino,archivo)) {
			edit_actual->modificado=TRUE;
			edit_guardar();
		}
		g_free(destino);
	} else {
		ventana=create_repe_ventana();
		gtk_widget_show(ventana);
	}
}

guint gen_comando(gchar *comando, gchar *mensaje)
{
	FILE *tuberia;
	guint salida;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;

	DEBUG_MSG(->gen_comando);
	gen_limpiar_mensajes();
	if (mensaje!=NULL) {
		g_print("%s",mensaje);
	} else {
		g_print("%s",comando);
	}
	tuberia=popen(comando,"r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
			if (letra=='\n') {
				if (gen_es_salida_grep(cadena)) {
					g_printerr("%s",cadena);
				} else {
					g_print("%s",cadena);
				}
				g_free(cadena);
				temporal=NULL;
				cadena=NULL;
			}
		}
	} while (mas);	
	if (cadena!=NULL) {
		g_free(cadena);
	}
	salida=pclose(tuberia);
	DEBUG_MSG(<-gen_comando);
	return salida;
}

void gen_nuevo(GtkWidget *widget)
{
	GtkWidget *ventana;
	GtkEditable *entrada;
	gchar *nombre;
	gchar *archivo;
	GtkCTreeNode *nodo_arbol;
	gchar *cabecera;
	gchar *defines;
	gchar *header;
	FILE *file;
	gint tipo;
	gint cont;
	gboolean todos_creados;
	gboolean guardar;
	
	DEBUG_MSG(->gen_nuevo);
	guardar=FALSE;
	ventana=gtk_widget_get_toplevel(widget);
	entrada=GTK_EDITABLE(lookup_widget(ventana,"nuevo_entrada"));
	nombre=gtk_editable_get_chars(entrada,0,-1);
	
	do {
		todos_creados=TRUE;
		tipo=gen_tipo_archivo(nombre);
		if (!edit_repetido(nombre)) {
			DEBUG_MSG(el archivo no existe);
			archivo=pro_nombre_completo_archivo(nombre,FALSE);
			cabecera=pro_cabecera_gnu();
			if ((cabecera!=NULL) && (tipo!=0)) {
				file=fopen(archivo,"a+");
				fwrite(cabecera,1,strlen(cabecera),file);
				fclose(file);
				g_free(cabecera);
			}
			if ((tipo==2) && (pro_defines())) {
				header=g_strdup(nombre);
				for (cont=0;header[cont]!=0;cont++) {
					if ((header[cont]>='a') && (header[cont]<='z')) {
						header[cont]=header[cont]-32;
					}
					if (header[cont]=='.') {
						header[cont]='_';
					}
				}
				defines=g_strdup_printf("#ifndef %s\n#define %s\n\n\n\n#endif\n",header,header);
				file=fopen(archivo,"a+");
				fwrite(defines,1,strlen(defines),file);
				fclose(file);
				g_free(defines);
				g_free(header);
			}
			nodo_arbol=arch_anadir(nombre);
			edit_anadir(archivo,nodo_arbol);
			pro_anadir(nombre);
			guardar=TRUE;
			gen_cerrar_ventana(widget);
		} else {
			ventana=create_repe_ventana();
			gtk_widget_show(ventana);
		}
		if ((pro_crear_h()) && (tipo==1)) {
			todos_creados=FALSE;
			for (cont=0;nombre[cont]!='.';cont++);
			nombre[cont+1]='h';
			nombre[cont+2]=0;
		}
	} while (!todos_creados);
	if (guardar) {
		pro_guardar();
	}
	g_free(nombre);
	DEBUG_MSG(<-gen_nuevo);
}

guint gen_tipo_archivo(gchar *nombre)
{
	// 0=otros, 1=fuentes, 2=cabeceras
	
	guint cont;
	
	for (cont=0;(nombre[cont]!='.') && (nombre[cont]!=0);cont++);
	if (nombre[cont]==0) {
		return 0;
	}
	cont++;
	if (!g_strcasecmp(nombre+cont,"c")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"cpp")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"c++")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"cc")) {
		return 1;
	}
	if (!g_strcasecmp(nombre+cont,"h")) {
		return 2;
	}
	if (!g_strcasecmp(nombre+cont,"hh")) {
		return 2;
	}
	return 0;
}

void gen_ayuda(enum e_ayuda ayuda)
{
	gchar *comando;
	pid_t pid;
	gchar *argumentos[3];
	
	if ((pid=fork())==0) {
		comando=NULL;
		switch (ayuda) {
			case GTK:
				if (preferencias.ayuda_gtk) {
					comando=g_strdup(preferencias.ayuda_gtk);
				} else {
					comando=g_strdup("info:gtk");
				}
				break;
			case XML:
				comando=g_strdup(preferencias.ayuda_xml);
				break;
			case GLIB:
				if (preferencias.ayuda_glib) {
					comando=g_strdup(preferencias.ayuda_glib);
				} else {
					comando=g_strdup("info:glib");
				}
				break;
			case ORBIT:
				comando=g_strdup(preferencias.ayuda_orbit);
				break;
			case GNOME:
				comando=g_strdup(preferencias.ayuda_gnome);
				break;
			case GNOMEUI:
				comando=g_strdup(preferencias.ayuda_gnomeui);
				break;
			case GNORBA:
				comando=g_strdup(preferencias.ayuda_gnorba);
				break;
		};
		argumentos[0]=g_strdup("gnome-help-browser");
		argumentos[1]=comando;
		argumentos[2]=NULL;
		execvp("gnome-help-browser",argumentos);
	}
}

void gen_eliminar(void)
{
	GtkLabel *etiqueta;
	
	if (edit_actual!=NULL) {
		arch_eliminar(edit_actual->nombre);
		pro_eliminar(edit_actual->nombre);
		cefv_eliminar_archivo(edit_actual->nombre);
		edit_eliminar(edit_actual->nombre);
		gtk_editable_delete_text(GTK_EDITABLE(edit_editor),0,gtk_extext_get_length(edit_editor));
		gtk_editable_set_editable(GTK_EDITABLE(edit_editor),FALSE);
		etiqueta=GTK_LABEL(lookup_widget(david_ventana,"editor_etiqueta"));
		gtk_label_set(etiqueta,_("Files"));
	}
}

void gen_cargar_proyecto(void)
{
	GtkWidget *combo;
	xmlNodePtr xmlnode;
	GtkCTreeNode *nodo_arbol;
	GtkCList *arbol;
	gchar *nombre;
	gchar *archivo;

	arch_crear();
	cefv_crear();
	
	arbol=GTK_CLIST(lookup_widget(david_ventana,"archivos_arbol"));
	gtk_clist_freeze(arbol);
	xmlnode=NULL;
	do {
		nombre=pro_fuentes(&xmlnode);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE);
			nodo_arbol=arch_anadir(nombre);
			edit_anadir(archivo,nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	
	xmlnode=NULL;
	do {
		nombre=pro_cabeceras(&xmlnode);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE);
			nodo_arbol=arch_anadir(nombre);
			edit_anadir(archivo,nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	
	cefv_congelar_lista_combo=TRUE;
	xmlnode=NULL;
	do {
		nombre=pro_otros(&xmlnode);
		if (nombre!=NULL) {
			archivo=pro_nombre_completo_archivo(nombre,FALSE);
			nodo_arbol=arch_anadir(nombre);
			edit_anadir(archivo,nodo_arbol);
			g_free(nombre);
			g_free(archivo);
		}
	} while (nombre!=NULL);
	gtk_clist_thaw(arbol);
	
	if (cefv_lista_combo!=NULL) {
		combo=lookup_widget(david_ventana,"funciones_combo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),cefv_lista_combo);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),"");
		cefv_congelar_lista_combo=FALSE;
	}
}

void gen_recargar(void)
{
	typedef struct s_cargados {
		gchar *nombre;
		gint pestana;
		struct s_cargados *siguiente;	
	} s_cargados;
	
	struct s_lista_archivos *archivos;
	s_cargados *cargados,*ultimo;
	gchar *nombre_proyecto,*nombre_temp;
	gint ultima_pestana;
	GtkWidget *widget;

	DEBUG_MSG(->gen_recargar);
	if (proyecto.xml!=NULL) {
		nombre_proyecto=pro_nombre();
		nombre_temp=g_strdup_printf("%s.davidprj",nombre_proyecto);
		g_free(nombre_proyecto);
		nombre_proyecto=pro_nombre_completo_archivo(nombre_temp,FALSE);
		g_free(nombre_temp);
		// primero creamos una lista con los archivos abiertos, y la pestaa en la que estan
		archivos=raiz_lista_archivos;
		cargados=NULL;
		ultimo=NULL;
		while (archivos!=NULL) {
			if (archivos->pestana!=-1) {
				if (cargados==NULL) {
					cargados=malloc(sizeof(s_cargados));
					ultimo=cargados;
				} else {
					ultimo->siguiente=malloc(sizeof(s_cargados));
					ultimo=ultimo->siguiente;
				}
				ultimo->nombre=g_strdup(archivos->nombre);
				ultimo->pestana=archivos->pestana;
				ultimo->siguiente=NULL;
			}
			archivos=archivos->siguiente;
		}
		
		// ahora recargamos el proyecto
		gen_abrir_proyecto(nombre_proyecto);
		g_free(nombre_proyecto);
		
		// ponemos cada archivo en su pestaa
		ultima_pestana=2;
		if (cargados!=NULL) {
			ultimo=cargados;
			while (ultimo!=NULL) {
				if (ultimo->pestana==ultima_pestana) {
					edit_ver(ultimo->nombre);
					on_mover_a_pestana_nueva1_activate(NULL,NULL);
					ultimo=cargados;
					ultima_pestana++;
				} else {
					ultimo=ultimo->siguiente;
				}
			}
			ultimo=cargados;
			while (ultimo!=NULL) {
				if (ultimo->pestana==0) {
					edit_ver(ultimo->nombre);
				}
				ultimo=ultimo->siguiente;
			}
		}
		widget=lookup_widget(david_ventana,"archivos_notebook");
		gtk_notebook_set_page(GTK_NOTEBOOK(widget),0);
		
		// eliminamos la lista creada
		while (cargados!=NULL) {
			g_free(cargados->nombre);
			ultimo=cargados;
			cargados=cargados->siguiente;
			g_free(ultimo);
		}
	}
	DEBUG_MSG(<-gen_recargar);
}

void gen_limpiar(void)
{
	GtkLabel *etiqueta;
	GtkWidget *notebook;
	gint cont;
	GtkCombo *historico_funciones;

	gen_limpiar_mensajes();
	DEBUG_MSG(->gen_limpiar);

	gtk_editable_set_editable(GTK_EDITABLE(edit_editor),TRUE);
	gtk_editable_set_editable(GTK_EDITABLE(edit_funciones),TRUE);
	gtk_extext_freeze(edit_editor);
	gtk_extext_freeze(edit_funciones);
	gtk_editable_delete_text(GTK_EDITABLE(edit_editor),0,gtk_extext_get_length(edit_editor));
	gtk_editable_delete_text(GTK_EDITABLE(edit_funciones),0,gtk_extext_get_length(edit_funciones));
	gtk_extext_thaw(edit_editor);
	gtk_extext_thaw(edit_funciones);
	gtk_editable_set_editable(GTK_EDITABLE(edit_editor),FALSE);
	gtk_editable_set_editable(GTK_EDITABLE(edit_funciones),FALSE);
	notebook=lookup_widget(david_ventana,"archivos_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook),0);
	for (cont=edit_total_pestanas;cont!=1;cont--) {
		gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),cont);
	}
	edit_total_pestanas=1;
	historico_funciones=GTK_COMBO(lookup_widget(david_ventana,"historico_funciones_combo"));
	gtk_combo_set_popdown_strings(historico_funciones,NULL);
	gtk_entry_set_text(GTK_ENTRY(historico_funciones->entry),"");

	etiqueta=GTK_LABEL(lookup_widget(david_ventana,"editor_etiqueta"));
	gtk_label_set(etiqueta,_("Files"));
	etiqueta=GTK_LABEL(lookup_widget(david_ventana,"fila_etiqueta"));
	gtk_label_set(etiqueta,_("Row: 1"));
	edit_mensaje("");
	if (proyecto.xml!=NULL) {
		xmlFreeDoc(proyecto.xml);
		edit_cerrar();
		g_free(proyecto.archivo);
	}
	if (proyecto.xml_viejo!=NULL) {
		xmlFreeDoc(proyecto.xml_viejo);
	}
	pro_inicializar();
	edit_inicializar();
	buscar_inicializar();
	cefv_inicializar();
	DEBUG_MSG(<-gen_limpiar);
}

void gen_crear_proyecto(GtkWidget *widget)
{
	gen_limpiar();
	pro_crear();
	pro_actualizar(widget);
	arch_crear();
	cefv_crear();
}

void gen_abrir_proyecto(gchar *nombre)
{
	GtkWidget *ventana, *menu, *widget;
	GtkCTree *arbol;
	xmlNodePtr nodo,nodonuevo;
	gint cont;
	gchar *ultimo;
	
	gen_limpiar();
	proyecto.archivo=g_strdup(nombre);
	if (pro_abrir()) {
		nodo=buscar_nodo_xml(preferencias.xml->root, "ultimos");
		nodonuevo=xmlNewNode(NULL,"ultimo");
		nodonuevo->parent=nodo;
		nodonuevo->next=nodo->childs;
		nodo->childs=nodonuevo;
		if (nodonuevo->next!=NULL) {
			nodonuevo->next->prev=nodonuevo;
		}
		xmlNodeSetContent(nodonuevo,proyecto.archivo);
		/*Creamos un menuitem para este ultimo proyecto en el menu File*/
		/*Si es el primero, habra que poner el separador tambien*/
		if (separador_recientes == FALSE) {
			widget = gtk_menu_item_new();
			menu = lookup_widget (david_ventana, "new2");
			menu = menu->parent;
			gtk_menu_insert(GTK_MENU(menu), widget, PRIMER_PROYECTO_RECIENTE);
			gtk_widget_show(widget);
			//Como el separador solo hay que ponerlo una vez, activamos un flag 
			separador_recientes = TRUE;		
		}
		menu = lookup_widget (david_ventana, "new2");
		menu = menu->parent;
		widget = gtk_menu_item_new_with_label (proyecto.archivo);
		gtk_menu_insert(GTK_MENU(menu), widget,PRIMER_PROYECTO_RECIENTE);
		/*Le asociamos la callback... sera la misma para todos */
		gtk_signal_connect(GTK_OBJECT(widget), "activate", 
			GTK_SIGNAL_FUNC(gen_recent_project_open), NULL);
		gtk_widget_show(widget);
		cont=1;
		nodo=nodo->childs;
		while (nodo->next!=NULL) {
			nodo=nodo->next;
			ultimo=xmlNodeGetContent(nodo);
			if (!strcmp(ultimo,proyecto.archivo)) {
				/*El proyecto ya existia entre los ultimos abiertos, asi que eliminamos el nodo viejo*/
				nodonuevo=nodo;
				nodo=nodo->prev;
				xmlUnlinkNode(nodonuevo);
				xmlFreeNode(nodonuevo);
				/*Quitamos el menuitem correspondiente del menu File*/
				/*Obtenemos el menuitem*/
				gtk_menu_set_active(GTK_MENU(menu), PRIMER_PROYECTO_RECIENTE+cont);
				widget = gtk_menu_get_active(GTK_MENU(menu));
				/*y lo eliminamos*/
				gtk_widget_destroy(widget);
				cont--;
			}
			g_free(ultimo);
			cont++;
		}
		if (cont==6) {
			xmlUnlinkNode(nodo);
			xmlFreeNode(nodo);
			/*Quitamos el menuitem correspondiente del menu File*/
			/*Obtenemos el menuitem*/
			gtk_menu_set_active(GTK_MENU(menu), PRIMER_PROYECTO_RECIENTE+cont);
			widget = gtk_menu_get_active(GTK_MENU(menu));
			/*y lo eliminamos*/
			gtk_widget_destroy(widget);
		}
		pref_guardar();
		pref_xml_struct();
		gen_cargar_proyecto();
		arbol=GTK_CTREE(lookup_widget(david_ventana,"cefv_arbol"));
		gtk_clist_thaw(GTK_CLIST(arbol));
	} else {
		xmlFreeDoc(proyecto.xml);
		proyecto.xml=NULL;
		g_free(proyecto.archivo);
		proyecto.archivo=NULL;
		ventana=create_no_proyecto_ventana();
		gtk_widget_show(ventana);
	}
}

void gen_mensajes_stderr(gchar *mensaje)
{
	GtkText *mensajes;
	GdkColor color;
	
	color.red=50000;
	color.green=1000;
	color.blue=1000;
	mensajes=GTK_TEXT(lookup_widget(david_ventana,"mensajes_texto"));
	
	gtk_text_insert(mensajes,NULL,&color,NULL,mensaje,-1);
}

void gen_mensajes_stdout(gchar *mensaje)
{
	GtkText *mensajes;
	mensajes=GTK_TEXT(lookup_widget(david_ventana,"mensajes_texto"));
	
	gtk_text_insert(mensajes,NULL,NULL,NULL,mensaje,-1);
}

void gen_limpiar_mensajes(void)
{
	GtkEditable *mensajes;
	
	mensajes=GTK_EDITABLE(lookup_widget(david_ventana,"mensajes_texto"));
	gtk_editable_delete_text(mensajes,0,-1);
}

gboolean gen_existe_fichero(gchar *nombre)
{
	FILE *archivo;
	
	archivo=fopen(nombre,"r");
	if (archivo==NULL) {
		return FALSE;
	} else {
		fclose(archivo);
		return TRUE;
	}
}

void gen_anular_funciones(void)
{
	GtkWidget *widget;
	
	if (!ejecutables.lpr) {
		widget=lookup_widget(david_ventana,"imprimir_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"imprimir1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("lpr was not found in your path, you will need it to print with DiaSCE\n"));
	}
	if (!ejecutables.grep) {
		g_printerr(_("grep was not found in your path, you will need it to search in multiple files\n"));
	}
	if (!ejecutables.gcc) {
		widget=lookup_widget(david_ventana,"compilar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"compile1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"make_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"make1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("gcc was not found in your path, you will need it to compile with DiaSCE\n"));
	}
	if (!ejecutables.gdb) {
		widget=lookup_widget(david_ventana,"ddd_button");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"ddd1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("gdb was not found in your path, you will need it to debug with DiaSCE\n"));
	}
	if (!ejecutables.ddd) {
		widget=lookup_widget(david_ventana,"ddd_button");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"ddd1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("ddd was not found in your path, you will need it to debug with DiaSCE\n"));
	}
	if (!ejecutables.glade) {
		widget=lookup_widget(david_ventana,"glade_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"glade1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("glade was not found in your path, you will nedd it do create GUIs with a graphic enviroment with DiaSCE\n"));
	}
	if (!ejecutables.ctags) {
		widget=lookup_widget(david_ventana,"abrir_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"project1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"abrir1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"nuevo1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("ctags was not found in your path, you will need it for DiaSCE to work properly\n"));
	}
	if (!ejecutables.memprof) {
		widget=lookup_widget(david_ventana,"memprof_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"memprof2");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("MemProf was not found in your path\n"));
	}
	if (!ejecutables.gnome_terminal) {
		widget=lookup_widget(david_ventana,"ejecutar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"run1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("GnomeTerminal was not found in your path, you will need it to run your executable from DiaSCE\n"));
	}
	if (!ejecutables.make) {
		widget=lookup_widget(david_ventana,"ejecutar_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"run1");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"make_boton");
		gtk_widget_set_sensitive(widget,FALSE);
		widget=lookup_widget(david_ventana,"make1");
		gtk_widget_set_sensitive(widget,FALSE);
		g_printerr(_("make was not found in your path, you will need it to compile with DiaSCE\n"));
	}
}

/*****************************************************************************************************************
Esta funcion es la encargada de aadir en el menu "File" la lista con los ultimos proyectos abiertos,
para un acceso mas rapido a ellos
*****************************************************************************************************************/
void gen_ultimos_proyectos (void)
{
	xmlNodePtr nodo;
	gchar *recent;
	GtkWidget *widget, *menu;
	int i = 0;
	
	menu=NULL;
	
	/* Nos posicionamos en el nodo "ultimos" del fichero .david. Los childs de este nodo contienen
	los ultimos proyectos abiertos*/
	nodo = buscar_nodo_xml (preferencias.xml->root, "ultimos");
	if (nodo != NULL) {
		/*nos situamos en el primer child*/
		nodo = nodo->childs;
		/*si hay alguno, aadimos un separator primero*/
		if (nodo != NULL) {
			widget = gtk_menu_item_new();
			menu = lookup_widget (david_ventana, "new2");
			menu = menu->parent;
			gtk_menu_insert(GTK_MENU(menu), widget, PRIMER_PROYECTO_RECIENTE);
			gtk_widget_show(widget);
			//Como el separador solo hay que ponerlo una vez, activamos un flag 
			separador_recientes = TRUE;		
		} else {
			separador_recientes = FALSE;
		}
		while (nodo != NULL) {
			recent = xmlNodeGetContent (nodo);
			/*Creamos un nuevo menuitem, cuya label es el nombre de uno de los ultimos proyectos abiertos*/
			widget = gtk_menu_item_new_with_label (recent);
			gtk_menu_insert(GTK_MENU(menu), widget,PRIMER_PROYECTO_RECIENTE+i);
			/*Le asociamos la callback... sera la misma para todos */
			gtk_signal_connect(GTK_OBJECT(widget), "activate", 
				GTK_SIGNAL_FUNC(gen_recent_project_open), NULL);
			gtk_widget_show(widget);
			g_free(recent);
			nodo = nodo->next;
			i = i+1;
		}
	}
}

/*****************************************************************************************
Funcion encargada de abrir un proyecto reciente. Esta asociada a los menuitems
de ultimos proyectos, en el menu File. Recoge el label del menuitem que le ha llamado
en user_data y abre el proyecto indicado por ese label.
*****************************************************************************************/
void gen_recent_project_open (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *ventana;
	gchar *archivo;
	gint ret;
	
	archivo=NULL;
	
	if (GTK_BIN(menuitem)->child) {
		GtkWidget *child = GTK_BIN(menuitem)->child;
		if (GTK_IS_LABEL(child)) {
		gchar *text;
		
		gtk_label_get (GTK_LABEL(child),&text);
		archivo = g_strdup (text);	
		g_print("%s\n",archivo);
		}
		if (edit_comprobar_perdida_datos()) {
			g_free(pro_proyecto_cargar);
			pro_proyecto_cargar=g_strdup(archivo);
			ventana = gen_create_perdidas_ventana();
			ret = gnome_dialog_run_and_close (GNOME_DIALOG(ventana));
			switch (ret) {
				case 0: //Boton "si"
					gen_abrir_proyecto(archivo);
					break;
				case 1: //Boton "no"
					break;
				default:	//El usuario ha cerrado la ventana desde el gestor de ventanas
					break;
			}
			//Creo que no hace falta
			//gtk_widget_destroy(ventana); 
		} else {
			gen_abrir_proyecto(archivo);
		}
		g_free (archivo);
	}
}

gboolean gen_es_salida_grep(gchar *salida)
{
	int cont,dos_puntos,cont1,cont2;
	gboolean es_salida_grep;
	
	cont=0;
	dos_puntos=0;
	cont1=0;
	cont2=0;
	
	while (salida[cont]!='\n') {
		if (salida[cont]==':') {
			dos_puntos++;
			if (dos_puntos==1) cont1=cont;
			if (dos_puntos==2) cont2=cont;
		}
		cont++;
	}

	es_salida_grep=FALSE;
	if (dos_puntos==2) {
		es_salida_grep=TRUE;
		for (cont=cont1+1;cont<cont2;cont++) {
			if ((salida[cont]<'0') || (salida[cont]>'9')) es_salida_grep=FALSE;
		if (salida[cont2+1]=='\n') es_salida_grep=FALSE;
		}
	};
	return es_salida_grep;
}

/**********************************************************************************************
* Esta funcion crea la ventana que indica al usuario que hay ficheros modificados   *
* sin guardar y que si continua se perderan esos datos. Muestra la lista de ficheros  *
* modificados que no han sido guardados, y devuelve un puntero a la ventana        *
* que luego podra ser mostrada con una llamada a gnome_run_dialog                     *
***********************************************************************************************/
GtkWidget *gen_create_perdidas_ventana (void)
{
	GtkWidget *widget;
	struct s_lista_archivos *nodo;
	gchar *archivos_modificados, *tmp, *mensaje;

	//Primero creamos una cadena que contenga una lista de los archivos modificados
	//que no han sido guardados
	archivos_modificados = g_strdup("");
	nodo = raiz_lista_archivos;
	while (nodo != NULL) {
		if (nodo->modificado == TRUE) {
			tmp = g_strdup(archivos_modificados);
			g_free(archivos_modificados);
			archivos_modificados = g_strconcat (tmp,nodo->nombre,"\n",NULL);
			g_free(tmp);
		}
		nodo = nodo->siguiente;
	}
	//Generamos el mensaje
	mensaje = g_strconcat(
		_("Warning! The following files have unsaved changes:\n\n"), 
		archivos_modificados,
		_("\nIf you continue, data will be lost.\n\nDo you still want to continue?\n"),
		NULL); 
	//una vez que tenemos la lista, generamos la ventana con el mensaje:
	widget = gnome_message_box_new(
		mensaje, 
		GNOME_MESSAGE_BOX_WARNING,
		GNOME_STOCK_BUTTON_YES,
		GNOME_STOCK_BUTTON_NO,
		NULL);
	g_free(archivos_modificados);
	g_free(mensaje);
	//y retornamos un puntero a la ventana
	return widget;
}

/**********************************************************************************
 * esta funcion hace que se atiendan a los eventos pendientes antes de *
 * devolver el control a gtk_main(). De esta forma se puede refrescar la   *
 * pantalla en sitios donde se retenga el control de programa durante      *
 * mucho timepo, como durante la compilacion.                                     *
 **********************************************************************************/
void gen_refrescar(void)
{
	while (gtk_events_pending()) {
		gtk_main_iteration();
	}
}

/**********************************************************************************
 esta funcion sera colgada de la seal CHILD para que haga un wait
 cada vez que un hijo muera. De esta forma se evita que aparezcan
 como "zombi"
 **********************************************************************************/
void gen_hijo_muerto(void)
{
	wait(NULL);
	signal(SIGCHLD,(void *)gen_hijo_muerto);
}

void gen_localizar_automake(void)
{	
	FILE *tuberia;
	gchar letra;
	gchar *cadena;
	gchar *temporal;
	guint mas;
	gchar *prefix_end;

	DEBUG_MSG(->gen_localizar_automake);
	if ((!ejecutables.which) || (!ejecutables.automake)) {
		prefix_automake=g_strdup("/usr");
		DEBUG_MSG(<-gen_localizar_automake 1);
		return;
	}

	tuberia=popen("which automake","r");
	temporal=NULL;
	cadena=NULL;
	do {
		mas=fread(&letra,1,1,tuberia);
		if (mas) {
			if (temporal!=NULL) {
				cadena=g_strdup_printf("%s%c",temporal,letra);
				g_free(temporal);
				temporal=cadena;
			} else {
				cadena=g_strdup_printf("%c",letra);
				temporal=cadena;
			}
		}
	} while (mas);
	
	prefix_end=strstr(cadena,"/bin/automake");
	if (prefix_end!=NULL) {
		prefix_end[0]=0;
		prefix_automake=g_strdup(cadena);
	} else{
		prefix_automake=g_strdup("/usr");
	}
	
	if (cadena!=NULL) {
		g_free(cadena);
	}
	pclose(tuberia);
	DEBUG_MSG(<-gen_localizar_automake);
}
