/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

void pref_crear(void)
{
	xmlNodePtr xmlnode;
	xmlNodePtr nodo;
	struct passwd *info;
	gchar *directorio;
	gchar *color;
	
	DEBUG_MSG(->pref_crear);
	preferencias.xml=xmlNewDoc("1.0");
	xmlnode=xmlNewNode(NULL,"Preferencias_david");
	(preferencias.xml)->root=xmlnode;
	xmlNewProp(xmlnode,"version",VERSION_PREFERENCIAS);
	
	xmlNewChild(xmlnode,NULL,"general",NULL);
	xmlNewChild(xmlnode,NULL,"editor",NULL);
	xmlNewChild(xmlnode,NULL,"documentacion",NULL);
	xmlNewChild(xmlnode,NULL,"colores",NULL);
	xmlNewChild(xmlnode,NULL,"ultimos",NULL);
	
	//preferencias de general
	xmlnode=xmlnode->childs;
	xmlNewProp(xmlnode,"nombre",NULL);
	xmlNewProp(xmlnode,"e-mail",NULL);
	info=getpwuid(getuid());
	directorio=g_strdup_printf("%s/",info->pw_dir);
	xmlNewProp(xmlnode,"directorio",directorio);
	g_free(directorio);
	xmlNewProp(xmlnode,"texto_barras","0");
	
	//preferencias de editor
	xmlnode=xmlnode->next;
	xmlNewProp(xmlnode,"auto","1");
	xmlNewProp(xmlnode,"super","1");
	xmlNewProp(xmlnode,"llaves","1");
	xmlNewProp(xmlnode,"tabulador","5");
	
	//preferencias de documentacion
	xmlnode=xmlnode->next;
	xmlNewChild(xmlnode,NULL,"gtk",NULL);
	xmlNewChild(xmlnode,NULL,"xml",NULL);
	xmlNewChild(xmlnode,NULL,"glib",NULL);
	xmlNewChild(xmlnode,NULL,"orbit",NULL);
	xmlNewChild(xmlnode,NULL,"gnome",NULL);
	xmlNewChild(xmlnode,NULL,"gnomeui",NULL);
	xmlNewChild(xmlnode,NULL,"gnorba",NULL);
	
	//preferencias de colores
	xmlnode=xmlnode->next;
	nodo=xmlNewChild(xmlnode,NULL,"c_fondo",NULL);
	color=g_strdup_printf("%i",c_fondo.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_fondo.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_fondo.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_nada",NULL);
	color=g_strdup_printf("%i",c_nada.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_nada.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_nada.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_comentario",NULL);
	color=g_strdup_printf("%i",c_comentario.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_comentario.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_comentario.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_directiva",NULL);
	color=g_strdup_printf("%i",c_directiva.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_directiva.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_directiva.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cs",NULL);
	color=g_strdup_printf("%i",c_cadena_cs.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cs.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cs.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cd",NULL);
	color=g_strdup_printf("%i",c_cadena_cd.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cd.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_cadena_cd.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_etiqueta",NULL);
	color=g_strdup_printf("%i",c_etiqueta.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_etiqueta.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_etiqueta.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_entero",NULL);
	color=g_strdup_printf("%i",c_entero.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_entero.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_entero.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_real",NULL);
	color=g_strdup_printf("%i",c_real.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_real.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_real.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_hexadecimal",NULL);
	color=g_strdup_printf("%i",c_hexadecimal.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_hexadecimal.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_hexadecimal.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);
	nodo=xmlNewChild(xmlnode,NULL,"c_octal",NULL);
	color=g_strdup_printf("%i",c_octal.red);
	xmlSetProp(nodo,"rojo",color);
	g_free(color);
	color=g_strdup_printf("%i",c_octal.green);
	xmlSetProp(nodo,"verde",color);
	g_free(color);
	color=g_strdup_printf("%i",c_octal.blue);
	xmlSetProp(nodo,"azul",color);
	g_free(color);

	DEBUG_MSG(<-pref_crear);
}

/* esta funicon tiene que ser llamada despues de edit_inicializar() para que los punteros a los colores de la estructura de preferencias
   esten asignados */
void pref_abrir(guint estado)
{
	struct passwd *info;
	gchar *archivoconf;
	gchar *version;
	xmlNodePtr nodo;
	xmlNodePtr xmlnode;
	gchar *tmp;
	gchar *color;
	gboolean crear;
	
	crear=FALSE;

	if (estado==0) {
		DEBUG_MSG(abriendo preferencias);
		preferencias.nombre=NULL;
		preferencias.e_mail=NULL;
		preferencias.directorio=NULL;
		preferencias.ayuda_gtk=NULL;
		preferencias.ayuda_xml=NULL;
		preferencias.ayuda_glib=NULL;
		preferencias.ayuda_orbit=NULL;
		preferencias.ayuda_gnome=NULL;
		preferencias.ayuda_gnomeui=NULL;
		preferencias.ayuda_gnorba=NULL;
		preferencias.ultimos[0]=NULL;
		preferencias.ultimos[1]=NULL;
		preferencias.ultimos[2]=NULL;
		preferencias.ultimos[3]=NULL;
		preferencias.ultimos[4]=NULL;
		preferencias.inc_xml=NULL;
		preferencias.inc_gtk=NULL;
		preferencias.inc_orbit=NULL;
		preferencias.inc_x11=NULL;
		preferencias.inc_gnome=NULL;
		preferencias.inc_glib=NULL;
		preferencias.inc_gnomeui=NULL;
		preferencias.inc_gnorba=NULL;
		preferencias.inc_audiofile=NULL;
		preferencias.inc_esd=NULL;
		preferencias.inc_gmodule=NULL;
		preferencias.inc_imlib=NULL;
		preferencias.lib_xml=NULL;
		preferencias.lib_gtk=NULL;
		preferencias.lib_orbit=NULL;
		preferencias.lib_x11=NULL;
		preferencias.lib_gnome=NULL;
		preferencias.lib_glib=NULL;
		preferencias.lib_gnomeui=NULL;
		preferencias.lib_gnorba=NULL;
		preferencias.lib_audiofile=NULL;
		preferencias.lib_esd=NULL;
		preferencias.lib_gmodule=NULL;
		preferencias.lib_imlib=NULL;
		preferencias.lib_electric_fence=NULL;
		info=getpwuid(getuid());
		archivoconf=g_strdup_printf("%s/.david",info->pw_dir);
		preferencias.xml=xmlParseFile(archivoconf);
		g_free(archivoconf);
		if (preferencias.xml==NULL) {
			pref_crear();
			crear=TRUE;
		} else {
			version=xmlGetProp((preferencias.xml)->root,"version");
			if (!g_strcasecmp(version,"0.1")) {
				xmlSetProp((preferencias.xml)->root,"version","0.3");
				crear=TRUE;
			}
			if (!g_strcasecmp(version,"0.2")) {
				xmlSetProp((preferencias.xml)->root,"version","0.3");
				nodo=buscar_nodo_xml(preferencias.xml->root,"includes");
				nodo=nodo->childs->next->next->next->next;
				tmp=xmlNodeGetContent(nodo);
				xmlNodeSetContent(nodo,NULL);
				xmlNewChild(nodo,NULL,"gnome",tmp);
				xmlNewChild(nodo,NULL,"gnomesupport",NULL);
				g_free(tmp);
				crear=FALSE;
			}
			g_free(version);
			version=xmlGetProp((preferencias.xml)->root,"version");
			if (!g_strcasecmp(version,"0.3")) {
				xmlSetProp((preferencias.xml)->root,"version","0.5");
				nodo=(preferencias.xml)->root->childs->next;
				xmlNewProp(nodo,"tabulador","5");
				nodo=nodo->next;
				xmlnode=xmlNewNode(NULL,"colores");
				xmlnode->parent=nodo->parent;
				xmlnode->next=nodo->next;
				xmlnode->prev=nodo;
				nodo->next->prev=xmlnode;
				nodo->next=xmlnode;
				
				nodo=xmlNewChild(xmlnode,NULL,"c_fondo",NULL);
				color=g_strdup_printf("%i",c_fondo.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_fondo.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_fondo.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_nada",NULL);
				color=g_strdup_printf("%i",c_nada.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_nada.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_nada.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_comentario,",NULL);
				color=g_strdup_printf("%i",c_comentario.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_comentario.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_comentario.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_directiva",NULL);
				color=g_strdup_printf("%i",c_directiva.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_directiva.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_directiva.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cs",NULL);
				color=g_strdup_printf("%i",c_cadena_cs.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_cadena_cs.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_cadena_cs.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_cadena_cd",NULL);
				color=g_strdup_printf("%i",c_cadena_cd.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_cadena_cd.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_cadena_cd.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_etiqueta",NULL);
				color=g_strdup_printf("%i",c_etiqueta.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_etiqueta.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_etiqueta.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_entero",NULL);
				color=g_strdup_printf("%i",c_entero.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_entero.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_entero.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_real",NULL);
				color=g_strdup_printf("%i",c_real.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_real.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_real.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_hexadecimal",NULL);
				color=g_strdup_printf("%i",c_hexadecimal.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_hexadecimal.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_hexadecimal.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);
				nodo=xmlNewChild(xmlnode,NULL,"c_octal",NULL);
				color=g_strdup_printf("%i",c_octal.red);
				xmlSetProp(nodo,"rojo",color);
				g_free(color);
				color=g_strdup_printf("%i",c_octal.green);
				xmlSetProp(nodo,"verde",color);
				g_free(color);
				color=g_strdup_printf("%i",c_octal.blue);
				xmlSetProp(nodo,"azul",color);
				g_free(color);

				nodo=buscar_nodo_xml(preferencias.xml->root,"includes");
				nodo=nodo->childs->next->next->next->next->next;
				tmp=xmlNodeGetContent(nodo);
				xmlNodeSetContent(nodo,NULL);
				xmlNewChild(nodo,NULL,"glib",tmp);
				g_free(tmp);
				xmlNewChild(nodo,NULL,"glibconfig",NULL);
				nodo=nodo->parent;
				xmlNewChild(nodo,NULL,"gnomeui",NULL);
				xmlNewChild(nodo,NULL,"gnorba",NULL);
				nodo=nodo->next;
				xmlNewChild(nodo,NULL,"gnomeui",NULL);
				xmlNewChild(nodo,NULL,"gnorba",NULL);
				crear=FALSE;
			}
			g_free(version);
			version=xmlGetProp((preferencias.xml)->root,"version");
			if (!g_strcasecmp(version,"0.5")) {
				xmlSetProp((preferencias.xml)->root,"version","0.6");
				nodo=(preferencias.xml)->root->childs;
				xmlNewProp(nodo,"texto_barras","0");
				nodo=buscar_nodo_xml(preferencias.xml->root,"includes");
				nodo=nodo->childs->next->next->next->next;
				xmlnode=nodo->childs;
				xmlUnlinkNode(xmlnode);
				xmlFreeNode(xmlnode);
				xmlnode=nodo->childs;
				xmlUnlinkNode(xmlnode);
				xmlFreeNode(xmlnode);
				nodo=nodo->next;
				xmlnode=nodo->childs;
				xmlUnlinkNode(xmlnode);
				xmlFreeNode(xmlnode);
				xmlnode=nodo->childs;
				xmlUnlinkNode(xmlnode);
				xmlFreeNode(xmlnode);
				nodo=nodo->parent;
				xmlNewChild(nodo,NULL,"audiofile",NULL);
				xmlNewChild(nodo,NULL,"esd",NULL);
				xmlNewChild(nodo,NULL,"gmodule",NULL);
				xmlNewChild(nodo,NULL,"imlib",NULL);
				nodo=nodo->next;
				xmlNewChild(nodo,NULL,"audiofile",NULL);
				xmlNewChild(nodo,NULL,"esd",NULL);
				xmlNewChild(nodo,NULL,"gmodule",NULL);
				xmlNewChild(nodo,NULL,"imlib",NULL);
				
				nodo=buscar_nodo_xml(preferencias.xml->root,"documentacion");
				xmlNewChild(nodo,NULL,"gnome",NULL);
				xmlNewChild(nodo,NULL,"gnomeui",NULL);
				xmlNewChild(nodo,NULL,"gnorba",NULL);
				nodo=nodo->next;
				xmlnode=xmlNewNode(NULL,"ultimos");
				xmlnode->parent=nodo->parent;
				xmlnode->next=nodo->next;
				xmlnode->prev=nodo;
				nodo->next=xmlnode;
				crear=FALSE;
			}
			g_free(version);
			version=xmlGetProp((preferencias.xml)->root,"version");
			if (!g_strcasecmp(version,"0.6")) {
				xmlSetProp((preferencias.xml)->root,"version","0.99");
				nodo=(preferencias.xml)->root->childs;
				nodo=buscar_nodo_xml(preferencias.xml->root,"librerias");
				xmlNewChild(nodo,NULL,"electric_fence",NULL);
				crear=FALSE;
			}
			g_free(version);
		}
		det_autodetectar(preferencias.xml,crear,estado);
		pref_xml_struct();
		chdir(preferencias.directorio);
	} else {
		det_autodetectar(preferencias.xml,FALSE,estado);
		if (estado==ULTIMA_FASE_AUTODETECCION) {
			pref_xml_struct();
			pref_guardar();
		}
	}
}

void pref_guardar(void)
{
	struct passwd *info;
	gchar *archivoconf;

	info=getpwuid(getuid());
	archivoconf=g_strdup_printf("%s/.david",info->pw_dir);
	xmlSaveFile(archivoconf,preferencias.xml);
	g_free(archivoconf);
}

void pref_actualizar(GtkWidget *widget)
{	
	GtkWidget *fuente;
	xmlNodePtr xmlnode;
	gchar *texto;
	guint cont;
	gchar *directorio;
	struct passwd *info;
	gushort gamma;
	
	widget=gtk_widget_get_toplevel(widget);
	xmlnode=(preferencias.xml)->root->childs;
	
	//propiedades generales
	fuente=lookup_widget(widget,"nombre_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"nombre",texto);
	g_free(texto);

	fuente=lookup_widget(widget,"e_mail_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlSetProp(xmlnode,"e-mail",texto);
	g_free(texto);
	
	fuente=lookup_widget(widget,"directorio_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	if (texto[0]==0) {
		info=getpwuid(getuid());
		directorio=g_strdup_printf("%s/",info->pw_dir);
	} else {
		for (cont=0;texto[cont]!=0;cont++);
		if (texto[cont-1]!='/') {
			directorio=g_strdup_printf("%s/",texto);
		} else {
			directorio=g_strdup(texto);
		}
	}
	g_free(texto);
	xmlSetProp(xmlnode,"directorio",directorio);
	g_free(directorio);
	fuente=lookup_widget(widget,"texto_barras_checkbutton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"texto_barras","1");
	} else {
		xmlSetProp(xmlnode,"texto_barras","0");
	}

	//propiedades editor
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"auto_indentacion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"auto","1");
	} else {
		xmlSetProp(xmlnode,"auto","0");
	}
	
	fuente=lookup_widget(widget,"super_indentacion_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"super","1");
	} else {
		xmlSetProp(xmlnode,"super","0");
	}
	
	fuente=lookup_widget(widget,"cerrar_llaves_boton");
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fuente))) {
		xmlSetProp(xmlnode,"llaves","1");
	} else {
		xmlSetProp(xmlnode,"llaves","0");
	}
	
	fuente=lookup_widget(widget,"tabulador_size");
	texto=g_strdup_printf("%i",gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(fuente)));
	xmlSetProp(xmlnode,"tabulador",texto);
	g_free(texto);

	//propiedades ayuda
	xmlnode=xmlnode->next->childs;
	fuente=lookup_widget(widget,"gtk_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"xml_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"glib_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"orbit_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);

	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"gnome_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"gnomeui_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);
	
	xmlnode=xmlnode->next;
	fuente=lookup_widget(widget,"gnorba_doc_entrada");
	texto=gtk_editable_get_chars(GTK_EDITABLE(fuente),0,-1);
	xmlNodeSetContent(xmlnode,texto);
	g_free(texto);

	//propiedades colores
	xmlnode=xmlnode->parent->next->childs;
	fuente=lookup_widget(widget,"fondo_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_fondo.red,&c_fondo.green,&c_fondo.blue,&gamma);
	texto=g_strdup_printf("%i",c_fondo.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_fondo.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_fondo.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"texto_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_nada.red,&c_nada.green,&c_nada.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_nada.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_nada.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_nada.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"comentarios_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_comentario.red,&c_comentario.green,&c_comentario.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_comentario.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_comentario.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_comentario.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"defines_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_directiva.red,&c_directiva.green,&c_directiva.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_directiva.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_directiva.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_directiva.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"caracteres_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_cadena_cs.red,&c_cadena_cs.green,&c_cadena_cs.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_cadena_cs.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cs.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cs.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"cadenas_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_cadena_cd.red,&c_cadena_cd.green,&c_cadena_cd.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_cadena_cd.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cd.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_cadena_cd.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"reservadas_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_etiqueta.red,&c_etiqueta.green,&c_etiqueta.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_etiqueta.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_etiqueta.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_etiqueta.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"naturales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_entero.red,&c_entero.green,&c_entero.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_entero.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_entero.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_entero.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"reales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_real.red,&c_real.green,&c_real.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_real.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_real.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_real.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"hexadecimales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_hexadecimal.red,&c_hexadecimal.green,&c_hexadecimal.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_hexadecimal.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_hexadecimal.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_hexadecimal.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);
	fuente=lookup_widget(widget,"octales_color");
	gnome_color_picker_get_i16(GNOME_COLOR_PICKER(fuente),&c_octal.red,&c_octal.green,&c_octal.blue,&gamma);
	xmlnode=xmlnode->next;
	texto=g_strdup_printf("%i",c_octal.red);
	xmlSetProp(xmlnode,"rojo",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_octal.green);
	xmlSetProp(xmlnode,"verde",texto);
	g_free(texto);
	texto=g_strdup_printf("%i",c_octal.blue);
	xmlSetProp(xmlnode,"azul",texto);
	g_free(texto);

	pref_guardar();
	pref_xml_struct();
}

void pref_mostrar(GtkWidget *widget)
{
	GtkWidget *fuente;

	DEBUG_MSG(->pref_mostrar);
	
	widget=gtk_widget_get_toplevel(widget);
	
	//propiedades generales
	if (preferencias.nombre != NULL) {
		fuente=lookup_widget(widget,"nombre_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.nombre);
	}
	if (preferencias.e_mail != NULL) {
		fuente=lookup_widget(widget,"e_mail_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.e_mail);
	}
	if (preferencias.directorio != NULL) {
		fuente=lookup_widget(widget,"directorio_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.directorio);
	}
	fuente=lookup_widget(widget,"texto_barras_checkbutton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.texto_barras);
	
	//propiedades editor
	fuente=lookup_widget(widget,"auto_indentacion_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.auto_indentacion);
	fuente=lookup_widget(widget,"super_indentacion_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.super_indentacion);
	fuente=lookup_widget(widget,"cerrar_llaves_boton");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fuente),preferencias.completar_llaves);
	fuente=lookup_widget(widget,"tabulador_size");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(fuente),preferencias.tabulador);
	
	//propiedades ayuda
	if (preferencias.ayuda_gtk != NULL) {
		fuente=lookup_widget(widget,"gtk_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_gtk);
	}	
	if (preferencias.ayuda_xml != NULL) {
		fuente=lookup_widget(widget,"xml_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_xml);
	}
	if (preferencias.ayuda_glib != NULL) {
		fuente=lookup_widget(widget,"glib_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_glib);
	}
	if (preferencias.ayuda_orbit != NULL) {
		fuente=lookup_widget(widget,"orbit_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_orbit);
	}
	if (preferencias.ayuda_gnome != NULL) {
		fuente=lookup_widget(widget,"gnome_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_gnome);
	}
	if (preferencias.ayuda_gnomeui != NULL) {
		fuente=lookup_widget(widget,"gnomeui_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_gnomeui);
	}
	if (preferencias.ayuda_gnorba != NULL) {
		fuente=lookup_widget(widget,"gnorba_doc_entrada");
		gtk_entry_set_text(GTK_ENTRY(fuente),preferencias.ayuda_gnorba);
	}
	
	//propiedades colores
	fuente=lookup_widget(widget,"texto_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_nada.red,c_nada.green,c_nada.blue,0);
	fuente=lookup_widget(widget,"defines_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_directiva.red,c_directiva.green,c_directiva.blue,0);
	fuente=lookup_widget(widget,"reservadas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_etiqueta.red,c_etiqueta.green,c_etiqueta.blue,0);
	fuente=lookup_widget(widget,"comentarios_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_comentario.red,c_comentario.green,c_comentario.blue,0);
	fuente=lookup_widget(widget,"cadenas_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cd.red,c_cadena_cd.green,c_cadena_cd.blue,0);
	fuente=lookup_widget(widget,"caracteres_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_cadena_cs.red,c_cadena_cs.green,c_cadena_cs.blue,0);
	fuente=lookup_widget(widget,"naturales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_entero.red,c_entero.green,c_entero.blue,0);
	fuente=lookup_widget(widget,"reales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_real.red,c_real.green,c_real.blue,0);
	fuente=lookup_widget(widget,"hexadecimales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_hexadecimal.red,c_hexadecimal.green,c_hexadecimal.blue,0);
	fuente=lookup_widget(widget,"octales_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_octal.red,c_octal.green,c_octal.blue,0);
	fuente=lookup_widget(widget,"fondo_color");
	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(fuente),c_fondo.red,c_fondo.green,c_fondo.blue,0);
	DEBUG_MSG(<-pref_mostrar);
}

void pref_xml_struct(void)
{
	xmlNodePtr xmlnode;
	gchar *texto;
	
	DEBUG_MSG(->pref_xml_struct);
	xmlnode=preferencias.xml->root->childs;

	texto=xmlGetProp(xmlnode,"nombre");
	g_free(preferencias.nombre);
	preferencias.nombre=texto;
	texto=xmlGetProp(xmlnode,"e-mail");
	g_free(preferencias.e_mail);
	preferencias.e_mail=texto;
	texto=xmlGetProp(xmlnode,"directorio");
	g_free(preferencias.directorio);
	preferencias.directorio=texto;
	texto=xmlGetProp(xmlnode,"texto_barras");
	preferencias.texto_barras=texto[0]-48;
	g_free(texto);

	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"auto");
	preferencias.auto_indentacion=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"super");
	preferencias.super_indentacion=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"llaves");
	preferencias.completar_llaves=texto[0]-48;
	g_free(texto);
	texto=xmlGetProp(xmlnode,"tabulador");
	preferencias.tabulador=atoi(texto);
	g_free(texto);
	
	xmlnode=xmlnode->next->childs;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_gtk);
	preferencias.ayuda_gtk=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_xml);
	preferencias.ayuda_xml=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_glib);
	preferencias.ayuda_glib=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_orbit);
	preferencias.ayuda_orbit=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_gnome);
	preferencias.ayuda_gnome=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_gnomeui);
	preferencias.ayuda_gnomeui=texto;
	xmlnode=xmlnode->next;
	texto=xmlNodeGetContent(xmlnode);
	g_free(preferencias.ayuda_gnorba);
	preferencias.ayuda_gnorba=texto;
	
	xmlnode=xmlnode->parent->next->childs;
	texto=xmlGetProp(xmlnode,"rojo");
	c_fondo.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_fondo.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_fondo.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_nada.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_nada.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_nada.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_comentario.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_comentario.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_comentario.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_directiva.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_directiva.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_directiva.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_cadena_cs.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_cadena_cs.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_cadena_cs.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_cadena_cd.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_cadena_cd.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_cadena_cd.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_etiqueta.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_etiqueta.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_etiqueta.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_entero.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_entero.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_entero.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_real.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_real.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_real.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_hexadecimal.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_hexadecimal.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_hexadecimal.blue=atoi(texto);
	g_free(texto);
	xmlnode=xmlnode->next;
	texto=xmlGetProp(xmlnode,"rojo");
	c_octal.red=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"verde");
	c_octal.green=atoi(texto);
	g_free(texto);
	texto=xmlGetProp(xmlnode,"azul");
	c_octal.blue=atoi(texto);
	g_free(texto);
	
	xmlnode=xmlnode->parent->next->childs;
	if (xmlnode!=NULL) {
		preferencias.ultimos[0]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[1]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[2]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[3]=xmlNodeGetContent(xmlnode);
		xmlnode=xmlnode->next;
	}
	if (xmlnode!=NULL) {
		preferencias.ultimos[4]=xmlNodeGetContent(xmlnode);
	}
	
	xmlnode=(preferencias.xml)->root->last->prev->childs;
	g_free(preferencias.inc_xml);
	preferencias.inc_xml=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_gtk);
	preferencias.inc_gtk=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_orbit);
	preferencias.inc_orbit=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_x11);
	preferencias.inc_x11=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_gnome);
	preferencias.inc_gnome=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_glib);
	preferencias.inc_glib=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_gnomeui);
	preferencias.inc_gnomeui=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_gnorba);
	preferencias.inc_gnorba=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_audiofile);
	preferencias.inc_audiofile=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_esd);
	preferencias.inc_esd=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_gmodule);
	preferencias.inc_gmodule=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.inc_imlib);
	preferencias.inc_imlib=xmlNodeGetContent(xmlnode);

	xmlnode=xmlnode->parent->next->childs;
	g_free(preferencias.lib_xml);
	preferencias.lib_xml=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_gtk);
	preferencias.lib_gtk=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_orbit);
	preferencias.lib_orbit=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_x11);
	preferencias.lib_x11=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_gnome);
	preferencias.lib_gnome=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_glib);
	preferencias.lib_glib=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_gnomeui);
	preferencias.lib_gnomeui=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_gnorba);
	preferencias.lib_gnorba=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_audiofile);
	preferencias.lib_audiofile=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_esd);
	preferencias.lib_esd=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_gmodule);
	preferencias.lib_gmodule=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_imlib);
	preferencias.lib_imlib=xmlNodeGetContent(xmlnode);
	xmlnode=xmlnode->next;
	g_free(preferencias.lib_electric_fence);
	preferencias.lib_electric_fence=xmlNodeGetContent(xmlnode);
	
	DEBUG_MSG(<-pref_xml_struct);
}

void pref_cerrar(void)
{
	xmlFreeDoc(preferencias.xml);
	g_free(preferencias.nombre);
	g_free(preferencias.e_mail);
	g_free(preferencias.directorio);
	g_free(preferencias.ayuda_gtk);
	g_free(preferencias.ayuda_xml);
	g_free(preferencias.ayuda_glib);
	g_free(preferencias.ayuda_orbit);
	g_free(preferencias.ayuda_gnome);
	g_free(preferencias.ayuda_gnomeui);
	g_free(preferencias.ayuda_gnorba);
	g_free(preferencias.inc_xml);
	g_free(preferencias.inc_gtk);
	g_free(preferencias.inc_orbit);
	g_free(preferencias.inc_x11);
	g_free(preferencias.inc_gnome);
	g_free(preferencias.inc_glib);
	g_free(preferencias.inc_audiofile);
	g_free(preferencias.inc_esd);
	g_free(preferencias.inc_gmodule);
	g_free(preferencias.inc_imlib);
	g_free(preferencias.lib_xml);
	g_free(preferencias.lib_gtk);
	g_free(preferencias.lib_orbit);
	g_free(preferencias.lib_x11);
	g_free(preferencias.lib_gnome);
	g_free(preferencias.lib_glib);
	g_free(preferencias.lib_audiofile);
	g_free(preferencias.lib_esd);
	g_free(preferencias.lib_gmodule);
	g_free(preferencias.lib_imlib);
	g_free(preferencias.lib_electric_fence);
}

void pref_aplicar(void)
{
	GtkWidget *widget1,*widget2,*message_box;
	struct s_lista_archivos *archivos,*actual;
	int tipo, result;
	
	widget1=lookup_widget(david_ventana,"barra1_toolbar");
	widget2=lookup_widget(david_ventana,"barra2_toolbar");
	if (preferencias.texto_barras) {
		gtk_toolbar_set_style(GTK_TOOLBAR(widget1),GTK_TOOLBAR_BOTH);
		gtk_toolbar_set_style(GTK_TOOLBAR(widget2),GTK_TOOLBAR_BOTH);
	} else {
		gtk_toolbar_set_style(GTK_TOOLBAR(widget1),GTK_TOOLBAR_ICONS);
		gtk_toolbar_set_style(GTK_TOOLBAR(widget2),GTK_TOOLBAR_ICONS);
	}
	edit_cambiar_reglas_coloreado();
	edit_aplicar_reglas_coloreado(edit_editor);
	edit_aplicar_reglas_coloreado(edit_funciones);
	archivos=raiz_lista_archivos;
	while (archivos!=NULL) {
		if (archivos->pestana>1) {
			edit_aplicar_reglas_coloreado(archivos->editor);
		}
		archivos=archivos->siguiente;
	}
	edit_estilo=gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(edit_editor)));
//	edit_estilo=gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(edit_funciones)));
	gtk_style_ref(edit_estilo);
	edit_estilo->bg[GTK_STATE_NORMAL]=c_fondo;
	edit_estilo->text[GTK_STATE_NORMAL]=c_nada;
	gtk_widget_set_style(GTK_WIDGET(edit_editor),edit_estilo);
	gtk_extext_set_tab_width(edit_editor, preferencias.tabulador);
	gtk_widget_set_style(GTK_WIDGET(edit_funciones),edit_estilo);
	gtk_extext_set_tab_width(edit_funciones, preferencias.tabulador);
	archivos=raiz_lista_archivos;
	while (archivos!=NULL) {
		if (archivos->pestana>1) {
			gtk_widget_set_style(GTK_WIDGET(archivos->editor),edit_estilo);
			gtk_extext_set_tab_width(archivos->editor, preferencias.tabulador);
		}
		archivos=archivos->siguiente;
	}
	gtk_extext_highlight_set(GTK_EXTEXT_HIGHLIGHT(edit_funciones),TRUE);
	archivos=raiz_lista_archivos;
	while (archivos!=NULL) {
		if (archivos->pestana!=-1) {
			tipo=gen_tipo_archivo(archivos->nombre);
			if (tipo==1 || tipo==2) {
				actual=edit_actual;
				edit_actual=archivos;
				edit_ver(archivos->nombre);
				edit_actual=actual;
			}
		}
		archivos=archivos->siguiente;
	}
	result = mkdir (preferencias.directorio,0x1ed);
	if (result == -1) {
		if (errno != EEXIST) {
			message_box = gnome_message_box_new(_("Can't create the working directory. Check if you have the right permissions or if the parent directory exists. "),
				GNOME_MESSAGE_BOX_ERROR,
				GNOME_STOCK_BUTTON_OK,
				NULL);
			gtk_window_set_default_size(GTK_WINDOW(message_box), 200, 100);
			gtk_window_set_modal(GTK_WINDOW(message_box), TRUE);
			gnome_dialog_run_and_close (GNOME_DIALOG(message_box));
			gtk_widget_destroy (message_box);
		}
	}
}
