/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/

#line 1 "cmdline.opt"
/* This file is part of GNU Dico. -*- c -*-
   Copyright (C) 1998, 1999, 2000, 2008, 2010 Sergey Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#include <dicod.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <getopt.h>
#include <gettext.h>

#line 25 "cmdline.opt"

#line 25
void print_help(void);
#line 25
void print_usage(void);
#line 139 "cmdline.opt"

#line 139
/* Option codes */
#line 139
enum {
#line 139
	_OPTION_INIT=255,
#line 139
	#line 28 "cmdline.opt"

#line 28
	OPTION_CONFIG,
#line 40 "cmdline.opt"

#line 40
	OPTION_STDERR,
#line 46 "cmdline.opt"

#line 46
	OPTION_SYSLOG,
#line 58 "cmdline.opt"

#line 58
	OPTION_PREPROCESSOR,
#line 64 "cmdline.opt"

#line 64
	OPTION_NO_PREPROCESSOR,
#line 95 "cmdline.opt"

#line 95
	OPTION_NO_TRANSCRIPT,
#line 108 "cmdline.opt"

#line 108
	OPTION_SOURCE_INFO,
#line 114 "cmdline.opt"

#line 114
	OPTION_TRACE_GRAMMAR,
#line 120 "cmdline.opt"

#line 120
	OPTION_TRACE_LEX,
#line 126 "cmdline.opt"

#line 126
	OPTION_CONFIG_HELP,
#line 139 "cmdline.opt"

#line 139
	OPTION_USAGE,
#line 139 "cmdline.opt"

#line 139
	OPTION_VERSION,

#line 139 "cmdline.opt"
	MAX_OPTION
#line 139
};
#line 139
static struct option long_options[] = {
#line 139
	#line 28 "cmdline.opt"

#line 28
	{ "config", required_argument, 0, OPTION_CONFIG },
#line 34 "cmdline.opt"

#line 34
	{ "foreground", no_argument, 0, 'f' },
#line 40 "cmdline.opt"

#line 40
	{ "stderr", no_argument, 0, OPTION_STDERR },
#line 46 "cmdline.opt"

#line 46
	{ "syslog", no_argument, 0, OPTION_SYSLOG },
#line 58 "cmdline.opt"

#line 58
	{ "preprocessor", required_argument, 0, OPTION_PREPROCESSOR },
#line 64 "cmdline.opt"

#line 64
	{ "no-preprocessor", no_argument, 0, OPTION_NO_PREPROCESSOR },
#line 70 "cmdline.opt"

#line 70
	{ "include-dir", required_argument, 0, 'I' },
#line 77 "cmdline.opt"

#line 77
	{ "single-process", no_argument, 0, 's' },
#line 83 "cmdline.opt"

#line 83
	{ "inetd", no_argument, 0, 'i' },
#line 89 "cmdline.opt"

#line 89
	{ "transcript", no_argument, 0, 'T' },
#line 95 "cmdline.opt"

#line 95
	{ "no-transcript", no_argument, 0, OPTION_NO_TRANSCRIPT },
#line 101 "cmdline.opt"

#line 101
	{ "debug", required_argument, 0, 'x' },
#line 108 "cmdline.opt"

#line 108
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 114 "cmdline.opt"

#line 114
	{ "trace-grammar", no_argument, 0, OPTION_TRACE_GRAMMAR },
#line 120 "cmdline.opt"

#line 120
	{ "trace-lex", no_argument, 0, OPTION_TRACE_LEX },
#line 126 "cmdline.opt"

#line 126
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 133 "cmdline.opt"

#line 133
	{ "lint", no_argument, 0, 't' },
#line 139 "cmdline.opt"

#line 139
	{ "help", no_argument, 0, 'h' },
#line 139 "cmdline.opt"

#line 139
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 139 "cmdline.opt"

#line 139
	{ "version", no_argument, 0, OPTION_VERSION },

#line 139 "cmdline.opt"
	{0, 0, 0, 0}
#line 139
};
#line 139
static struct opthelp {
#line 139
        const char *opt;
#line 139
        const char *arg;
#line 139
        int is_optional;
#line 139
        const char *descr;
#line 139
} opthelp[] = {
#line 139
	#line 30 "cmdline.opt"

#line 30
	{ "--config", N_("FILE"), 0, N_("Read this configuration file.") },
#line 36 "cmdline.opt"

#line 36
	{ "-f, --foreground", NULL, 0, N_("Operate in foreground.") },
#line 42 "cmdline.opt"

#line 42
	{ "--stderr", NULL, 0, N_("Output diagnostic to stderr.") },
#line 48 "cmdline.opt"

#line 48
	{ "--syslog", NULL, 0, N_("Output diagnostic to syslog (default).") },
#line 54 "cmdline.opt"

#line 54
	{ "-E", NULL, 0, N_("Preprocess configuration file and exit") },
#line 60 "cmdline.opt"

#line 60
	{ "--preprocessor", N_("PROG"), 0, N_("Use PROG as a preprocessor for config file.") },
#line 66 "cmdline.opt"

#line 66
	{ "--no-preprocessor", NULL, 0, N_("Do not use external preprocessor.") },
#line 73 "cmdline.opt"

#line 73
	{ "-I, --include-dir", N_("DIR"), 0, N_("Add the directory DIR to the list of directories to be searched for preprocessor include files") },
#line 79 "cmdline.opt"

#line 79
	{ "-s, --single-process", NULL, 0, N_("Single-process mode.") },
#line 85 "cmdline.opt"

#line 85
	{ "-i, --inetd", NULL, 0, N_("Inetd mode.") },
#line 91 "cmdline.opt"

#line 91
	{ "-T, --transcript", NULL, 0, N_("Enable session transcript.") },
#line 97 "cmdline.opt"

#line 97
	{ "--no-transcript", NULL, 0, N_("Disable session transcript.") },
#line 103 "cmdline.opt"

#line 103
	{ "-x, --debug", N_("LEVEL-SPEC"), 0, N_("Set debug verbosity level.") },
#line 110 "cmdline.opt"

#line 110
	{ "--source-info", NULL, 0, N_("Include source line information in the debugging output.") },
#line 116 "cmdline.opt"

#line 116
	{ "--trace-grammar", NULL, 0, N_("Trace parsing of configuration file.") },
#line 122 "cmdline.opt"

#line 122
	{ "--trace-lex", NULL, 0, N_("Trace config file lexer.") },
#line 128 "cmdline.opt"

#line 128
	{ "--config-help", NULL, 0, N_("Show configuration file summary.") },
#line 135 "cmdline.opt"

#line 135
	{ "-t, --lint", NULL, 0, N_("Check configuration file syntax and exit.") },
#line 139 "cmdline.opt"

#line 139
	{ NULL, NULL, 0, N_("Other options") },
#line 139 "cmdline.opt"

#line 139
	{ "-h, --help", NULL, 0, N_("Give this help list") },
#line 139 "cmdline.opt"

#line 139
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 139 "cmdline.opt"

#line 139
	{ "--version", NULL, 0, N_("Print program version") },

#line 139 "cmdline.opt"
};
#line 25 "cmdline.opt"

#line 25
const char *program_version = "dicod" " (" PACKAGE_STRING ")";
#line 25
static char doc[] = N_("A DICT daemon.");
#line 25
static char args_doc[] = N_("");
#line 25
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 25
		    
#line 25
#define DESCRCOLUMN 30
#line 25
#define RMARGIN 79
#line 25
#define GROUPCOLUMN 2
#line 25
#define USAGECOLUMN 13
#line 25
		    
#line 25
static void
#line 25
indent (size_t start, size_t col)
#line 25
{
#line 25
  for (; start < col; start++)
#line 25
    putchar (' ');
#line 25
}
#line 25
		    
#line 25
static void
#line 25
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 25
{
#line 25
  while (*descr)
#line 25
    {
#line 25
      size_t s = 0;
#line 25
      size_t i;
#line 25
      size_t width = rmargin - lmargin;
#line 25

#line 25
      for (i = 0; ; i++)
#line 25
	{
#line 25
	  if (descr[i] == 0 || isspace (descr[i]))
#line 25
	    {
#line 25
	      if (i > width)
#line 25
		break;
#line 25
	      s = i;
#line 25
	      if (descr[i] == 0)
#line 25
		break;
#line 25
	    }
#line 25
	}
#line 25
      printf ("%*.*s\n", s, s, descr);
#line 25
      descr += s;
#line 25
      if (*descr)
#line 25
	{
#line 25
	  indent (0, lmargin);
#line 25
	  descr++;
#line 25
	}
#line 25
    }
#line 25
}
#line 25

#line 25
void
#line 25
print_help(void)
#line 25
{
#line 25
  unsigned i;
#line 25
  
#line 25
  printf ("%s %s [%s]... %s\n", _("Usage:"), "dicod", _("OPTION"),
#line 25
	  gettext (args_doc)); 
#line 25
  if (doc[0])
#line 25
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 25
  putchar ('\n');
#line 25

#line 25
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 25
    {
#line 25
      unsigned n;
#line 25
      if (opthelp[i].opt)
#line 25
	{
#line 25
	  n = printf ("  %s", opthelp[i].opt);
#line 25
	  if (opthelp[i].arg)
#line 25
	    {
#line 25
	      char *cb, *ce;
#line 25
	      if (strlen (opthelp[i].opt) == 2)
#line 25
		{
#line 25
		  if (!opthelp[i].is_optional)
#line 25
		    {
#line 25
		      putchar (' ');
#line 25
		      n++;
#line 25
		    }
#line 25
		}
#line 25
	      else
#line 25
		{
#line 25
		  putchar ('=');
#line 25
		  n++;
#line 25
		}
#line 25
	      if (opthelp[i].is_optional)
#line 25
		{
#line 25
		  cb = "[";
#line 25
		  ce = "]";
#line 25
		}
#line 25
	      else
#line 25
		cb = ce = "";
#line 25
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 25
	    }
#line 25
	  if (n >= DESCRCOLUMN)
#line 25
	    {
#line 25
	      putchar ('\n');
#line 25
	      n = 0;
#line 25
	    }
#line 25
	  indent (n, DESCRCOLUMN);
#line 25
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 25
	}
#line 25
      else
#line 25
	{
#line 25
	  if (i)
#line 25
	    putchar ('\n');
#line 25
	  indent (0, GROUPCOLUMN);
#line 25
	  print_option_descr (gettext (opthelp[i].descr),
#line 25
			      GROUPCOLUMN, RMARGIN);
#line 25
	  putchar ('\n');
#line 25
	}
#line 25
    }
#line 25
  
#line 25
  putchar ('\n');
#line 25
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 25
  putchar ('\n');
#line 25
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 25
}
#line 25

#line 25
void
#line 25
print_usage(void)
#line 25
{
#line 25
  unsigned i;
#line 25
  int f = 0;
#line 25
  unsigned n;
#line 25
  char buf[RMARGIN+1];
#line 25

#line 25
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 25
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 25

#line 25
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "dicod");
#line 25

#line 25
  /* Print a list of short options without arguments. */
#line 25
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 25
    {
#line 25
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 25
	  && opthelp[i].arg == NULL)
#line 25
	{
#line 25
	  if (f == 0)
#line 25
	    {
#line 25
	      ADDC('[');
#line 25
	      ADDC('-');
#line 25
	      f = 1;
#line 25
	    }
#line 25
	  ADDC(opthelp[i].opt[1]);
#line 25
	}
#line 25
    }
#line 25
  if (f)
#line 25
    ADDC(']');
#line 25

#line 25
  /* Print a list of short options with arguments. */
#line 25
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 25
    {
#line 25
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 25
	  && opthelp[i].arg)
#line 25
	{
#line 25
	  size_t len = 5 
#line 25
	                + strlen (opthelp[i].arg)
#line 25
			   + (opthelp[i].is_optional ? 2 : 1);
#line 25
	  if (n + len > RMARGIN) FLUSH;
#line 25
	  buf[n++] = ' '; 
#line 25
	  buf[n++] = '['; 
#line 25
	  buf[n++] = '-';
#line 25
	  buf[n++] = opthelp[i].opt[1];
#line 25
	  if (opthelp[i].is_optional)
#line 25
	    {
#line 25
	      buf[n++] = '[';
#line 25
	      strcpy (&buf[n], opthelp[i].arg);
#line 25
	      n += strlen (opthelp[i].arg);
#line 25
	      buf[n++] = ']';
#line 25
	    }
#line 25
	  else
#line 25
	    {
#line 25
	      buf[n++] = ' ';
#line 25
	      strcpy (&buf[n], opthelp[i].arg);
#line 25
	      n += strlen (opthelp[i].arg);
#line 25
	    }
#line 25
	  buf[n++] = ']';
#line 25
	}
#line 25
    }
#line 25

#line 25
  /* Print a list of long options */
#line 25
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 25
    {
#line 25
      if (opthelp[i].opt && opthelp[i].descr)
#line 25
	{
#line 25
	  size_t len;
#line 25
	  const char *longopt;
#line 25

#line 25
	  if (opthelp[i].opt[1] == '-')
#line 25
	    longopt = opthelp[i].opt;
#line 25
	  else if (opthelp[i].opt[2] == ',')
#line 25
	    longopt = opthelp[i].opt + 4;
#line 25
	  else
#line 25
	    continue;
#line 25

#line 25
	  len = 3 + strlen (longopt)
#line 25
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 25
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 25
	  if (n + len > RMARGIN) FLUSH;
#line 25
	  buf[n++] = ' '; 
#line 25
	  buf[n++] = '['; 
#line 25
	  strcpy (&buf[n], longopt);
#line 25
	  n += strlen (longopt);
#line 25
	  if (opthelp[i].arg)
#line 25
	    {
#line 25
	      buf[n++] = '=';
#line 25
	      if (opthelp[i].is_optional)
#line 25
		{
#line 25
		  buf[n++] = '[';
#line 25
		  strcpy (&buf[n], opthelp[i].arg);
#line 25
		  n += strlen (opthelp[i].arg);
#line 25
		  buf[n++] = ']';
#line 25
		}
#line 25
	      else
#line 25
		{
#line 25
		  strcpy (&buf[n], opthelp[i].arg);
#line 25
		  n += strlen (opthelp[i].arg);
#line 25
		}
#line 25
	    }
#line 25
	  buf[n++] = ']';
#line 25
	}
#line 25
    }
#line 25
  FLUSH;
#line 25
  
#line 25
}
#line 25

#line 25
const char version_etc_copyright[] =
#line 25
  /* Do *not* mark this string for translation.  %s is a copyright
     symbol suitable for this locale, and %d is the copyright
     year.  */
#line 25
  "Copyright %s 2005, 2006, 2007, 2008 Sergey Poznyakoff";
#line 25

#line 25
void
#line 25
print_version_only(const char *program_version, FILE *stream)
#line 25
{
#line 25
	fprintf (stream, "%s\n", program_version);
#line 25
	/* TRANSLATORS: Translate "(C)" to the copyright symbol
	   (C-in-a-circle), if this symbol is available in the user's
	   locale.  Otherwise, do not translate "(C)"; leave it as-is.  */
#line 25
	fprintf (stream, version_etc_copyright, _("(C)"));
#line 25
	fputc ('\n', stream);
#line 25
}
#line 25

#line 25
void
#line 25
print_version(const char *program_version, FILE *stream)
#line 25
{
#line 25
	print_version_only(program_version, stream);
#line 25
	
#line 25
	fputs (_("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n"),
#line 25
	       stream);
#line 25
	
#line 25
}
#line 25

#line 139 "cmdline.opt"

#line 139


void
get_options (int argc, char *argv[], struct dicod_conf_override *conf)
{
    
#line 144
 {
#line 144
  int c;
#line 144

#line 144
  while ((c = getopt_long(argc, argv, "fEI:siTx:th",
#line 144
                          long_options, NULL)) != EOF)
#line 144
    {
#line 144
      switch (c)
#line 144
        {
#line 144
        default:
#line 144
	   exit(EX_USAGE);	   exit(1);
#line 144
	#line 30 "cmdline.opt"
	 case OPTION_CONFIG:
#line 30
          {
#line 30

   config_file = optarg;

#line 32
             break;
#line 32
          }
#line 36 "cmdline.opt"
	 case 'f':
#line 36
          {
#line 36

   foreground = 1;

#line 38
             break;
#line 38
          }
#line 42 "cmdline.opt"
	 case OPTION_STDERR:
#line 42
          {
#line 42

   log_to_stderr = 1;

#line 44
             break;
#line 44
          }
#line 48 "cmdline.opt"
	 case OPTION_SYSLOG:
#line 48
          {
#line 48

   log_to_stderr = 0;

#line 50
             break;
#line 50
          }
#line 54 "cmdline.opt"
	 case 'E':
#line 54
          {
#line 54

   mode = MODE_PREPROC;

#line 56
             break;
#line 56
          }
#line 60 "cmdline.opt"
	 case OPTION_PREPROCESSOR:
#line 60
          {
#line 60

   preprocessor = optarg;

#line 62
             break;
#line 62
          }
#line 66 "cmdline.opt"
	 case OPTION_NO_PREPROCESSOR:
#line 66
          {
#line 66

   preprocessor = NULL;

#line 68
             break;
#line 68
          }
#line 73 "cmdline.opt"
	 case 'I':
#line 73
          {
#line 73

   add_include_dir(optarg); 

#line 75
             break;
#line 75
          }
#line 79 "cmdline.opt"
	 case 's':
#line 79
          {
#line 79

   single_process = 1;

#line 81
             break;
#line 81
          }
#line 85 "cmdline.opt"
	 case 'i':
#line 85
          {
#line 85

   mode = MODE_INETD;

#line 87
             break;
#line 87
          }
#line 91 "cmdline.opt"
	 case 'T':
#line 91
          {
#line 91

   conf->transcript = 1;

#line 93
             break;
#line 93
          }
#line 97 "cmdline.opt"
	 case OPTION_NO_TRANSCRIPT:
#line 97
          {
#line 97

   conf->transcript = 0;

#line 99
             break;
#line 99
          }
#line 103 "cmdline.opt"
	 case 'x':
#line 103
          {
#line 103

   debug_level_str = optarg;
   debug_level = atoi(optarg);

#line 106
             break;
#line 106
          }
#line 110 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 110
          {
#line 110

  debug_source_info = 1;

#line 112
             break;
#line 112
          }
#line 116 "cmdline.opt"
	 case OPTION_TRACE_GRAMMAR:
#line 116
          {
#line 116

   config_gram_trace(1);

#line 118
             break;
#line 118
          }
#line 122 "cmdline.opt"
	 case OPTION_TRACE_LEX:
#line 122
          {
#line 122

   config_lex_trace(1);

#line 124
             break;
#line 124
          }
#line 128 "cmdline.opt"
	 case OPTION_CONFIG_HELP:
#line 128
          {
#line 128

   config_help();
   exit(0);

#line 131
             break;
#line 131
          }
#line 135 "cmdline.opt"
	 case 't':
#line 135
          {
#line 135

   config_lint_option = 1;

#line 137
             break;
#line 137
          }
#line 139 "cmdline.opt"
	 case 'h':
#line 139
          {
#line 139

#line 139
		print_help ();
#line 139
                exit (0);
#line 139
	 
#line 139
             break;
#line 139
          }
#line 139 "cmdline.opt"
	 case OPTION_USAGE:
#line 139
          {
#line 139

#line 139
		print_usage ();
#line 139
		exit (0);
#line 139
	 
#line 139
             break;
#line 139
          }
#line 139 "cmdline.opt"
	 case OPTION_VERSION:
#line 139
          {
#line 139

#line 139
		/* Give version */
#line 139
		print_version(program_version, stdout);
#line 139
		exit (0);
#line 139
         
#line 139
             break;
#line 139
          }

#line 144 "cmdline.opt"
        }
#line 144
    }
#line 144
  
#line 144
 }   
#line 144

}
