#ifndef DICOMINFO_H_INCLUDED
#define DICOMINFO_H_INCLUDED
// 	$Id: dicomInfo.h,v 1.13 2006/08/24 19:34:42 valerio Exp $

//============================================================================
// CTN software is curtesy of
//
//		Mallinckrodt Institute of Radiology
//		Washington University in St. Louis MO
//		http://wuerlim.wustl.edu/
//
//============================================================================

//****************************************************************************
//
// Modification History (most recent first)
// mm/dd/yy  Who  What
//
// 08/15/06  VPL  GPL'ed it
// 03/22/05  VPL  Allow processing of multiple series
//                Add NYU License agreement
// 01/17/03  VPL  
//
//****************************************************************************

#ifdef LINUX
#define ARCHITECTURE "LITTLE_ENDIAN_ARCHITECTURE"
#define OS "LINUX"
#elif OSX
#define ARCHITECTURE "BIG_ENDIAN_ARCHITECTURE"
#define OS "OSX"
#endif

#define SHORTSIZE 16
#define LONGSIZE 32

#include <list>
#include <math.h>

#include "dinifti.h"

#include "ctn/dicom.h"
#include "ctn/lst.h"
#include "ctn/dicom_objects.h"
#include "ctn/utility.h"
#include "ctn/condition.h"

string &DeSpace(string &strng);

class DICOMImage
{
public:
	DICOMImage(const char *path);
	
	void AdjustSet(int numSlices, int imgDiff)
    {
		numSlices_ = numSlices;
		imageNum_ -= numSlices * (ACQNum_ - 1) + imgDiff;
	}
	void AdjustSet(bool sagDir, bool corDir, bool traDir, int numSlices, int imgDiff);
	
	string &ImagePath()             { return imgPath_; }
	int ImageNumber() const			{ return imageNum_; }
	bool Mosaic() const				{ return mosaic_; }
	bool D3() const                 { return d3_; }
	int NumSlices() const			{ return numSlices_; }
    int NumGroups() const           { return numGroups_; }
	float SliceThickness() const   	{ return sliceThickness_; }
	float SliceSpacing() const     	{ return sliceSpacing_; }
	string &Comments()			 	{ return comments_; }
	int Columns() const				{ return columns_; }
	int Rows() const			 	{ return rows_; }
	int NumChannels() const		 	{ return numChannels_; }
	float XFOV() const		 	    { return xFOV_; }
	float YFOV() const				{ return yFOV_; }
	float Time() const		 		{ return time_; }
	int RepetitionTime() const		{ return repTime_; }
	string &SeriesID()      		{ return seriesID_; }
	int FrequencyDim() const        { return (phaseEncoding_ == 2 ? 1 : 2); }
	int PhaseDim() const            { return phaseEncoding_; }
	string &SeriesDescription() 	{ return seriesDescription_; }
	int ACQNumber() const	        { return ACQNum_; }
	float RowSagCos() const    	 	{ return rowCosines_.at(0); }
	float RowCorCos() const        	{ return rowCosines_.at(1); }
	float RowTraCos() const		 	{ return rowCosines_.at(2); }
	float ColSagCos() const    	 	{ return colCosines_.at(0); }
	float ColCorCos() const    	 	{ return colCosines_.at(1); }
	float ColTraCos() const    	 	{ return colCosines_.at(2); }
  
	float SagNorm() const 		 	{ return sagNorm_; }
	float CorNorm() const 		 	{ return corNorm_; }
	float TraNorm() const 		 	{ return traNorm_; }

	float SagPos(int a = 0) const  	{ return sagPos_.at(a); }
	float CorPos(int a = 0) const  	{ return corPos_.at(a); }
	float TraPos(int a = 0) const  	{ return traPos_.at(a); }

	bool operator!() const		 	{ return error_; }
	operator void*() const		 	{ return error_ ? (void *)0 : (void *)this; }

	bool ReadSlice(U16 *data, int slice);
	bool ReadVolume();
	void FreeVolume()	 	     	{ if ( volumeData_ != NULL) delete [] volumeData_; volumeData_ = NULL; }

private:

	bool error_;

	bool OpenFile(const char *path);
	
	bool GetImageNumber();
	bool GetACQNumber();
	bool GetMosaic();
	bool GetD3();
	bool GetNumSlices();
	bool GetNumGroups();
	bool GetSliceThickness();
	bool GetSliceSpacing();
	bool GetComments();
	bool GetPosNorm();
	bool GetPosNormSiemens(char *storage);
	bool GetColumns();
	bool GetRows();
	bool GetNumChannels();
	bool GetFOV();
	bool GetTime();
	bool GetRepetitionTime();
	bool GetImgOrientation();
	bool GetSeriesID();
	bool GetPhaseEncoding();
	bool GetManufacturer();
	bool GetSeriesDescription();
	bool MosaicAdjustments();
	
	U32 GetData(DCM_TAG tag, char **storage);
	bool GetData(DCM_TAG tag, U32 *storage);
	bool GetData(DCM_TAG tag, U16 *storage);
	char *GetShadowSet();
  
	DCM_OBJECT *handle_;
	string imgPath_;
	int imageNum_;
	int numGroups_;
	bool mosaic_;
	bool d3_;
	float sliceThickness_;
	float sliceSpacing_;
	string comments_;
	int ACQNum_;
	int columns_;
	int rows_;
	int numChannels_;
	float xFOV_;
	float yFOV_;
	float time_;
	int repTime_;
	int phaseEncoding_;
	unsigned short *volumeData_;
	string seriesID_;
	string seriesDescription_;

	enum MANUFACTURER {SIEMENS, GE, UNDEFINED};
	MANUFACTURER manufacturer_;
	
	char *shadowSet_;
  
	vector<float> rowCosines_;
	vector<float> colCosines_;
	float sagNorm_;
	float corNorm_;
	float traNorm_;
	vector<float> sagPos_;
	vector<float> corPos_;
	vector<float> traPos_;
  
	// Next are used only with Mosaics
  
	int numSlices_;
	int mosaicGridSize_;
};

// Define a few usefull things:
//
//	IMAGELIST: a list of DICOMImage objects, each describing and image
//  IMAGEMAP: a map of IMAGELISTs to timepoints, one list per time point
//  SERIESMAP: a map of IMAGEMAPs to series, one map per series

typedef list<DICOMImage> IMAGELIST;
typedef map<int, IMAGELIST *> IMAGEMAP;

struct SeriesInfo
{
	SeriesInfo() : mosaic(false), maxImgNum(0), minImgNum(0), maxAcqNum(0), numSlices(0) {}

	string outName;
	bool mosaic;
	int maxImgNum;
	int minImgNum;
	int maxAcqNum;
	int numSlices;
	IMAGEMAP imageMap;
};

typedef map<string, SeriesInfo> SERIESMAP;

#endif
