#ifndef DINIFTI_H_INCLUDED
#define DINIFTI_H_INCLUDED
//  $Id: dinifti.h,v 1.8 2006/10/04 18:57:54 valerio Exp $	

//============================================================================
// CTN software is curtesy of
//
//		Mallinckrodt Institute of Radiology
//		Washington University in St. Louis MO
//		http://wuerlim.wustl.edu/
//
//============================================================================

//****************************************************************************
//
// Modification History (most recent first)
// mm/dd/yy  Who  What
//
// 10/04/06  Add DiniftiOptions class and verbose mode
//           (contributed by Michael Hanke)
// 08/15/06  VPL  GPL'ed it
// 03/22/05  VPL  Allow processing of multiple series
//                Add NYU License agreement
// 01/24/05  VPL  
//
//****************************************************************************

#include <sys/types.h>
#include <dirent.h>
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <iomanip>
#include <unistd.h>
#include <vector>
#include <list>
#include <map>
#include <sstream>

using namespace std;
using std::cin;
using std::cout;
using std::cerr;
using std::endl;
using std::setw;
using std::ofstream;
using std::ios;
using std::string;

typedef string::size_type size_type;

#define OUT_BUFFER_SIZE 1024*1024

// Need to do some prototyping to help us
class DiniftiOptions;
class DICOMImage;
struct SeriesInfo;

typedef list<DICOMImage> IMAGELIST;
typedef map<int, IMAGELIST *> IMAGEMAP;
typedef map<string, SeriesInfo> SERIESMAP;

enum OUTPUT_TYPE { ANALYZE, NIfTI_SINGLE, NIfTI_DUAL, NIfTI_ASCII };

void StoreImageFiles(vector<string> &dicomFiles, SERIESMAP &seriesMap, char *outName, DiniftiOptions opts);

void ProcessSeries(SeriesInfo &seriesInfo, DiniftiOptions opts);

class DiniftiOptions
{
public:
	DiniftiOptions()
		:useSerDesc(false),
		 verbose(false),
		 numSlices(0),
		 compressed(false),
		 niftiFormat(NIfTI_SINGLE)
	{}
	bool useSerDesc;
	bool verbose;
	int numSlices;
	bool compressed;
	OUTPUT_TYPE niftiFormat;
};


#endif
