/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Diggler.
 *
 * The Initial Developer of the Original Code is Adam Lock.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 *   Adam Lock <adamlock@netscape.com>
 *   Chris Neale <orbit@cdn.gs>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const kPREF_DIGGLER           = "diggler."
const kPREF_DIGGLER_POPUP_CONTROLS = kPREF_DIGGLER + "popup_controls";
const kPREF_DIGGLER_TAB_CONTROLS   = kPREF_DIGGLER + "tab_controls";
const kPREF_DIGGLER_IMAGE_CONTROLS = kPREF_DIGGLER + "image_controls"

const kPREF_DOM_POPUP       = "dom.disable_open_during_load";
const kPREF_IMAGE_BEHAVIOUR = "network.image.imageBehavior"

// This is our pref observer which makes sure that various prefs are read and
// kept up to date. It saves having to lookup this stuff each time when it 
// rarely changes.

var prefObserver =
{
  addPrefListener: function ()
  {
    try {
      if (this.pref == null) {
        var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                    .getService(Components.interfaces.nsIPrefService);
        this.pref = prefService.getBranch(null);
      }
      var pbi = this.pref.QueryInterface(Components.interfaces.nsIPrefBranchInternal);
      pbi.addObserver(kPREF_DIGGLER, this, false);
    } catch(ex) {
      dump("Diggler failed to observe prefs: " + ex + "\n");
    }
    this.syncPrefs();
  },

  syncPrefs: function()
  {
    // Fill in prefs with their default values first
    this.showPopupMenuItems = true;
    this.showTabMenuItems = true;
    this.showImageMenuItems = true;
    this.imageBehaviour = 0;
    this.showPopups = true;
    
    try {
      // Diggler prefs
      this.showPopupMenuItems = this.pref.getBoolPref(kPREF_DIGGLER_POPUP_CONTROLS);
      this.showTabMenuItems   = this.pref.getBoolPref(kPREF_DIGGLER_TAB_CONTROLS);
      this.showImageMenuItems = this.pref.getBoolPref(kPREF_DIGGLER_IMAGE_CONTROLS);
      // Other prefs
      this.imageBehaviour = this.pref.getIntPref(kPREF_IMAGE_BEHAVIOUR);
      this.showPopups = this.pref.getBoolPref(kPREF_DOM_POPUP);
      // TODO tools menu
    } catch (ex) {
      dump("Diggler failed to syncPrefs: " + ex + "\n");
    }
  },
  
  // nsIObserver
  observe: function(subject, topic, state)
  {
    if (topic != "nsPref:changed")
      return;
    this.syncPrefs();
  }
};

// Add a listener such that commonly read prefs can be cached
prefObserver.addPrefListener();

function digglerSubstituteURL(originalURL, pattern)
{
    // %S - spec, whole url
    // %s - scheme (http, ftp etc.)
    // %b - base address
    // %p - path
    // %f - filename
}

function digglerDoMenu(aEvent)
{
  var id = aEvent.target.getAttribute("id");
  if (id == "diggler-clear") {
    digglerClearLocation();
  }
  else if (id == "diggler-imageon") 
  { 
    digglerSetImageMode(0); 
  }
  else if (id == "diggler-imageonlocal") 
  {
    digglerSetImageMode(1); 
  }
  else if (id == "diggler-imageoff") 
  { 
    digglerSetImageMode(2); 
  } 
  else if (id == "diggler-popupkiller") {
    var killPopups =  !digglerGetKillPopups();
    dump("toggle killpopups to " + killPopups + "\n");
    digglerSetKillPopups(killPopups);
  }
  else if (id == "diggler-newtab")
  {
    BrowserOpenTab();
  }
  else {
    digglerSetUrl(aEvent);
  }
}

function digglerSetKillPopups(killPopups)
{
    prefObserver.pref.setBoolPref(kDOM_POPUP_PREF, killPopups);
}

function digglerGetKillPopups()
{
    return prefObserver.pref.showPopups;
}

function digglerSetUrl(aEvent)
{
  var uriToLoad = aEvent.target.getAttribute("label");
  urlBar = document.getElementById("urlbar");
  urlBar.value = uriToLoad;
  loadURI(uriToLoad);
}

function digglerBuildMenu()
{
  urlBar = document.getElementById("urlbar");
  var url = urlBar.value;
  var siteUrl;

  // Enable/disable the popup killer
  var showPopupMenuItems = prefObserver.showPopupMenuItems;
  var popupKiller = document.getElementById("diggler-popupkiller");
  popupKiller.setAttribute("checked", !digglerGetKillPopups());
  document.getElementById("diggler-popupsep").setAttribute("visible", showPopupMenuItems);
  popupKiller.setAttribute("visible", showPopupMenuItems);
  
  // Enable/disable view images radio buttons
  var showImageMenuItems = prefObserver.showImageMenuItems;
  if (showImageMenuItems) {
    var imageMode = digglerGetImageMode();
    var imageEl;
    if (imageMode == 0)
      imageEl = document.getElementById("diggler-imageon");
    else if (imageMode == 1)
      imageEl = document.getElementById("diggler-imageonlocal");
    else if (imageMode == 2)
      imageEl = document.getElementById("diggler-imageoff");
    if (imageEl)
      imageEl.setAttribute("checked", "true");
  }
  // This code stinks, there must be a better way
  document.getElementById("diggler-imagesep").setAttribute("visible", showImageMenuItems);
  document.getElementById("diggler-imageon").setAttribute("visible", showImageMenuItems);
  document.getElementById("diggler-imageonlocal").setAttribute("visible", showImageMenuItems);
  document.getElementById("diggler-imageoff").setAttribute("visible", showImageMenuItems);


  // Hide/show new tab menu item
  var showTabMenuItems = prefObserver.showTabMenuItems;
  var newTab = document.getElementById("diggler-newtab");
  if (newTab) {
    var hideNewTab = false;
    // count number of tabs in window
    // if (tabs == 1) check "browser.tabs.autoHide"
    //
  }
  document.getElementById("diggler-tabsep").setAttribute("visible", showTabMenuItems);
  document.getElementById("diggler-newtab").setAttribute("visible", showTabMenuItems);

  urlMenu = document.getElementById("diggler-url-menu");

  // Build a list of items from the current url
  digglerClearTempMenuItems(urlMenu);
  if (url.length > 0) {
    var isFirstTempItem = true;

    // Regexp to find the last slash delimited chunk of the url
    siteUrl = url;
    var tmpUrl = url;
    var reChunk = /[^\/]\/[^\/]+\/*$/; /* */
    while (1)
    {
      if (isFirstTempItem) {
        digglerCreateTempMenuSeparator(urlMenu);
        isFirstTempItem = false;
      }
      dump("Adding menu item for URL part = " + url + "\n");
      digglerCreateTempMenuItem(urlMenu, tmpUrl);

      var lastChunk = tmpUrl.search(reChunk);
      if (lastChunk == -1) {
        break;
      }
      // The + 2 bit is here because we want to slice 2 chars into the regexp
      tmpUrl = tmpUrl.slice(0, lastChunk + 2); 
      siteUrl = tmpUrl;
    }
  }
  
  if (siteUrl != null) {
    // If the url use another port than 80 (eg. http://server:8080), then offer port 80 as
    // an alternative
    var portPos=siteUrl.search(':[1-9]');
    if(portPos > 0) {
      dump("Adding menu item for URL on port 80");
      var noportUrl=siteUrl.slice(0,portPos) + '/';
      digglerCreateTempMenuSeparator(urlMenu);
      digglerCreateTempMenuItem(urlMenu,noportUrl);
    }
    // If the url starts with http:// then offer ftp:// as an alternative
    var urlAsFtp = siteUrl.replace(/^http:\/\/www/i, "ftp://ftp");
    if (urlAsFtp == siteUrl) {
      urlAsFtp = siteUrl.replace(/^http:\/\//i, "ftp://");
    }
    if (urlAsFtp != siteUrl) {
      digglerCreateTempMenuSeparator(urlMenu);
      digglerCreateTempMenuItem(urlMenu, urlAsFtp);
    }
    else {
      // If the url starts with ftp:// then offer http:// as an alternative
      var urlAsHttp = siteUrl.replace(/^ftp:\/\/ftp/i, "http://www");
      if (urlAsHttp == siteUrl) {
        urlAsHttp = siteUrl.replace(/^ftp:\/\//i, "http://");
      }
      if (urlAsHttp != siteUrl) {
        digglerCreateTempMenuSeparator(urlMenu);
        digglerCreateTempMenuItem(urlMenu, urlAsHttp);
      }
    }
  }
}

function digglerClearTempMenuItems(aParent)
{
  var children = aParent.childNodes;
  for (var i = 0; i < children.length; i++)
  {
    var index = children[i].getAttribute("tmp");
    if (index)
      aParent.removeChild(children[i]);
  }
}

function digglerCreateTempMenuSeparator(aParent)
{
  var menuitem = document.createElement("menuseparator");
  menuitem.setAttribute("tmp", "separator");
  aParent.appendChild(menuitem);
}

function digglerCreateTempMenuItem(aParent, aLabel)
{
  var menuitem = document.createElement("menuitem");
  menuitem.setAttribute("label", aLabel);
  menuitem.setAttribute("tmp", "item");
  aParent.appendChild(menuitem);
}

function digglerClearLocation()
{
  urlBar = document.getElementById("urlbar");
  urlBar.value = "";
  urlBar.focus();
}

function digglerSetImageMode(mode) 
{ 
  prefObserver.pref.setIntPref(kPREF_IMAGE_BEHAVIOUR, mode); 
} 

function digglerGetImageMode()
{
  return this.imageBehaviour; 
}

function digglerAbout()
{
}

function digglerUpdateTooltip(tipElement)
{
  if (tipElement != document.getElementById("diggler-button"))
  {
    return false;
  }
  return true;
}
