/* ============================================================
 * File  : plugin_cdarchiving.cpp
 * Author: Gilles Caulier <caulier dot gilles at free.fr>
 * Date  : 2003-09-05
 * Description : Albums CD archiving Digikam plugin
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <klocale.h>
#include <kaction.h>
#include <kgenericfactory.h>
#include <klibloader.h>
#include <kconfig.h>
#include <kdebug.h>

#include <digikam/albummanager.h>
#include <digikam/albuminfo.h>

#include "cdarchiving.h"
#include "plugin_cdarchiving.h"


K_EXPORT_COMPONENT_FACTORY( digikamplugin_cdarchiving,
                            KGenericFactory<Plugin_CDArchiving>("digikam"));

// -----------------------------------------------------------
Plugin_CDArchiving::Plugin_CDArchiving(QObject *parent, const char*, const QStringList&)
            : Digikam::Plugin(parent, "CDArchiving")
{
    setInstance(KGenericFactory<Plugin_CDArchiving>::instance());
    setXMLFile("plugins/digikamplugin_cdarchiving.rc");
    KGlobal::locale()->insertCatalogue("digikamplugin_cdarchiving");
    kdDebug() << "Plugin_CDArchiving plugin loaded" << endl;

    m_action_cdarchiving = new KAction (i18n("Archive to CD ..."),        // Menu message.
                                        "cd",                             // Menu icon.
                                        0,             
                                        this,
                                        SLOT(slotActivate()),
                                        actionCollection(),
                                        "cd_archiving");

    m_cdarchiving = 0;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

Plugin_CDArchiving::~Plugin_CDArchiving()
{
    // No need to delete m_cdarchiving as its a QObject child of this
    // and will be deleted automatically
}


/////////////////////////////////////////////////////////////////////////////////////////////////////

void Plugin_CDArchiving::slotActivate()
{
    if (!m_cdarchiving) {
        m_cdarchiving = new CDArchiving(this, m_action_cdarchiving);
    }
    m_cdarchiving->Activate();
}

