/**
 * DimpSlider.js - Extensions to the stock Scriptaculous Slider library
 * which allows us to make the slider act more like a scrollbar.
 *
 * $Horde: dimp/js/src/DimpSlider.js,v 1.6.2.6 2008/03/29 21:01:14 slusarz Exp $
 *
 * Copyright 2007-2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

var DimpSlider = Class.create(Control.Slider, {

    // Changed from original by calling the onClickTrack callback (if present)
    // when we detect a click on the track.
    startDrag: function(e)
    {
        e = Event.extend(e);

        if (!e.isLeftClick()) {
            return;
        }

        e.stop();

        if (this.disabled){
            return;
        }

        this.active = true;

        var handle = e.element(),
            offsets,
            pointer  = [ e.pointerX(), e.pointerY() ],
            val;

        if (handle == this.track) {
            offsets = this.track.cumulativeOffset();
            this.event = e;
            val = (this.isVertical() ? pointer[1] - offsets[1] : pointer[0] - offsets[0]) - (this.handleLength / 2);
            if (this.options.onClickTrack) {
                this.options.onClickTrack(val, this);
            } else {
                this.setValue(this.translateToValue(val));
                this.setOffsets(pointer);
            }
        } else {
            // Find the handle (prevents issues with Safari)
            while ((this.handles.indexOf(handle) == -1) && handle.parentNode) {
                handle = handle.parentNode;
            }

            if (this.handles.indexOf(handle) != -1) {
                this.activeHandle = handle;
                this.activeHandleIdx = this.handles.indexOf(this.activeHandle);
                this.updateStyles();

                this.setOffsets(pointer);
            }
        }
    },

    setOffsets: function(p)
    {
        var offsets = this.activeHandle.cumulativeOffset();
        this.offsetX = p[0] - offsets[0];
        this.offsetY = p[1] - offsets[1];
    },

    updateTrackLength: function()
    {
        this.trackLength = this.maximumOffset() - this.minimumOffset();
    },

    setHandleLength: function(l, noupdate)
    {
        this.handleLength = l;
        this.activeHandle.setStyle({ height: l + 'px' });
        this.setScrollPosition(this.getValue(), noupdate);
    },

    getValue: function(h)
    {
        // Safari 2 fix - v can be NaN here
        var v = this.values[h || 0];
        return (isNaN(v)) ? 0 : v;
    },

    setScrollPosition: function(offset, noupdate)
    {
        // Safari 2 fix - trackLength can be NaN here
        if (isNaN(this.trackLength)) {
            this.trackLength = this.maximumOffset() - this.minimumOffset();
        }

        // Disable the onChange() action for this explicit scrollbar move.
        var oc = this.options.onChange;
        if (noupdate) {
            this.options.onChange = null;
        }
        this.setValue(offset);
        this.options.onChange = oc;

        this.offsetX = this.offsetY = 0;
    },

    clearClick: function()
    {
        this.active = false;
    }

});
