/**
 * compose.js - Javascript code used in the DIMP compose view.
 *
 * $Horde: dimp/js/src/compose.js,v 1.84.2.18 2008/05/20 16:34:13 slusarz Exp $
 *
 * Copyright 2005-2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

var DimpCompose = {
    // Variables defaulting to empty/false:
    //   auto_save_interval, button_pressed, compose_cursor, compose_loaded,
    //   editor_on, mp_padding, resizebcc, resizecc, resizeto, row_height,
    //   uploading
    last_msg: '',
    textarea_ready: true,

    confirmCancel: function()
    {
        if (window.confirm(DIMP.text_compose.cancel)) {
            if (DIMP.conf_compose.auto_save_interval_val) {
                DimpCore.doAction('DeleteDraft', { index: $F('index') });
            }
            if (DIMP.conf_compose.qreply) {
                this.closeQReply();
                return true;
            } else if (DIMP.conf_compose.popup_window) {
                DimpCore.closePopup();
            } else {
                window.location = DIMP.conf.URI_DIMP_INBOX;
            }
        }
        return false;
    },

    closeQReply: function()
    {
        this.last_msg = '';
        var al = $('attach_list').childElements();
        if (al.size()) {
            this.removeAttach(al);
        }
        $('messageCache').setValue('');
        $('draft_index').setValue('');
        $('qreply', 'sendcc', 'sendbcc').invoke('hide');
        [ $('msgData'), $('togglecc').up(), $('togglebcc').up() ].invoke('show');
        if (this.editor_on) {
            this.toggleHtmlEditor();
        }
        Form.reset('compose');

        // Disable auto-save-drafts now.
        if (this.auto_save_interval) {
            window.clearInterval(this.auto_save_interval);
            this.auto_save_interval = null;
        }
    },

    change_identity: function()
    {
        var id = $F('identity'),
            last = this.get_identity($F('last_identity')),
            lastSignature,
            msgval = $('message'),
            msg,
            next = this.get_identity(id),
            nextSignature,
            pos,
            ssm = $('save_sent_mail');

        $('sent_mail_folder_label').setText(next.id[5]);
        $('bcc').setValue(next.id[6]);
        if (ssm) {
            ssm.checked = next.id[4];
        }

        // Finally try and replace the signature.
        if (this.editor_on) {
            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                msg = _editors.message.getHTML();
                break;

            case 'fckeditor':
                msg = FCKeditorAPI.GetInstance('message').GetHTML();
                break;
            }

            msg = msg.replace(/\r\n/g, '\n');
            lastSignature = '<p><!--begin_signature--><!--end_signature--></p>';
            nextSignature = '<p><!--begin_signature-->' + next.sig.replace(/^ ?<br \/>\n/, '').replace(/ +/g, ' ') + '<!--end_signature--></p>';

            // Dot-all functionality achieved with [\s\S], see:
            // http://simonwillison.net/2004/Sep/20/newlines/
            msg = msg.replace(/<p>\s*<!--begin_signature-->[\s\S]*?<!--end_signature-->\s*<\/p>/, lastSignature);
        } else {
            msg = msgval.value.replace(/\r\n/g, '\n');
            lastSignature = last.sig;
            nextSignature = next.sig;
        }

        pos = (last.id[2])
            ? msg.indexOf(lastSignature)
            : msg.lastIndexOf(lastSignature);

        if (pos != -1) {
            if (next.id[2] == last.id[2]) {
                msg = msg.substring(0, pos) + nextSignature + msg.substring(pos + lastSignature.length, msg.length);
            } else if (next.id[2]) {
                msg = nextSignature + msg.substring(0, pos) + msg.substring(pos + lastSignature.length, msg.length);
            } else {
                msg = msg.substring(0, pos) + msg.substring(pos + lastSignature.length, msg.length) + nextSignature;
            }

            msg = msg.replace(/\r\n/g, '\n').replace(/\n/g, '\r\n');
            if (this.editor_on) {
                switch (DIMP.conf_compose.js_editor) {
                case 'xinha':
                    _editors.message.setHTML(msg);
                    break;

                case 'fckeditor':
                    FCKeditorAPI.GetInstance('message').SetHTML(msg);
                    break;
                }
            } else {
                msgval.setValue(msg);
            }
            $('last_identity').setValue(id);
        }
    },

    get_identity: function(id)
    {
        return { id: DIMP.conf_compose.identities[id], sig: DIMP.conf_compose.identities[id][((this.editor_on) ? 1 : 0)].replace(/^\n/, '') };
    },

    uniqueSubmit: function(action)
    {
        var c = $('compose'), db, sb;

        if (DIMP.SpellCheckerObject) {
            DIMP.SpellCheckerObject.resume();
            if (!this.textarea_ready) {
                this.uniqueSubmit.bind(this, action).defer();
                return;
            }
        }

        if (action == 'send_message' || action == 'save_draft') {
            c.setStyle({ cursor: 'wait' });
            this.button_pressed = true;

            switch (action) {
            case 'send_message':
                sb = $('send_button');
                if (sb.visible()) {
                    sb.hide().parentNode.insertBefore(new Element('LABEL', { id: 'send_label' }).insert(DIMP.text_compose.sending), sb);
            }
            break;

            case 'save_draft':
                db = $('draft_button');
                if (db.visible()) {
                    db.hide().parentNode.insertBefore(new Element('LABEL', { id: 'draft_label' }).insert(DIMP.text_compose.saving), db);
                }
                break;
            }

            // Don't send/save until uploading is completed.
            if (this.uploading) {
                (function() { if (this.button_pressed) { this.uniqueSubmit(action); } }).bind(this).delay(0.25);
                return;
            }
        }
        $('action').setValue(action);

        if (action == 'add_attachment') {
            // We need a submit action here because browser security models
            // won't let us access files on user's filesystem otherwise.
            this.uploading = true;
            c.submit();
        } else {
            // Move HTML text to textarea field for submission.
            if (this.editor_on) {
                switch (DIMP.conf_compose.js_editor) {
                case 'xinha':
                    // This onsubmit() is needed because xinha sets an onsubmit
                    // handler to set the value of the textarea, and since we
                    // are overloading the default onsubmit handler, we need
                    // to make sure we explicitly call the function.
                    c.onsubmit();
                    break;

                case 'fckeditor':
                    FCKeditorAPI.GetInstance('message').UpdateLinkedField();
                    break;
                }
            }

            // Use an AJAX submit here so that we can do javascript-y stuff
            // before having to close the window on success.
            DimpCore.doAction('*' + DIMP.conf.compose_url, c.serialize(true), [], this.uniqueSubmitCallback.bind(this));
        }
    },

    uniqueSubmitCallback: function(r)
    {
        var d = r.response, db, sb, elt;
        if (!d) {
            return;
        }

        if (d.imp_compose) {
            $('messageCache').setValue(d.imp_compose);
        }

        if (d.success || d.action == 'add_attachment') {
            switch (d.action) {
            case 'auto_save_draft':
                this.button_pressed = false;
                $('draft_index').setValue(d.draft_index);
                break;

            case 'save_draft':
                this.button_pressed = false;
                if (DIMP.conf_compose.popup_window && DIMP.conf_compose.close_draft) {
                    DIMP.baseWindow.DimpCore.showNotifications(r.msgs);
                    DimpCore.closePopup();
                    return;
                }
                break;

            case 'send_message':
                this.button_pressed = false;
                /* If we loaded compose.php directly (without a base DIMP
                 * window), then redirect to the base page. */
                if (DIMP.baseWindow) {
                    if (d.reply_type == 'reply') {
                        DIMP.baseWindow.DimpBase.flag('answered', d.index, d.reply_folder);
                    }

                    if (d.folder) {
                        DIMP.baseWindow.DimpBase.createFolder(d.folder);
                    }

                    if (DIMP.conf_compose.popup_window) {
                        DIMP.baseWindow.DimpCore.showNotifications(r.msgs);
                        DimpCore.closePopup();
                        return;
                    } else if (DIMP.conf_compose.qreply) {
                        this.closeQReply();
                    }
                } else if (DIMP.conf_compose.qreply) {
                    this.closeQReply();
                } else if (DIMP.conf_compose.popup_window) {
                    DimpCore.closePopup();
                    return;
                } else {
                    window.location = DIMP.conf.URI_DIMP_INBOX + '#folder:INBOX';
                }
                break;

            case 'add_attachment':
                this.uploading = false;
                if (d.success) {
                    this.addAttach(d.info.number, d.info.name, d.info.type, d.info.size);
                } else {
                    this.button_pressed = false;
                }
                if (DIMP.conf_compose.attach_limit != -1 &&
                    $('attach_list').childElements().size() > DIMP.conf_compose.attach_limit) {
                    $('upload').disabled = false;
                    elt = new Element('DIV', [ DIMP.text_compose.attachment_limit ]);
                } else {
                    elt = new Element('INPUT', { type: 'file', name: 'file_1' });
                    elt.observe('change', this.uploadAttachment.bind(this));
                }
                elt.id = 'upload';
                $('attach_cell').replaceChild(elt, $('upload_wait'));
                this.resizeMsgArea();
                break;
            }
        } else {
            this.button_pressed = false;
        }

        // Re-enable buttons if needed.
        if (!this.button_pressed) {
            db = $('draft_button');
            sb = $('send_button');
            if (!sb.visible()) {
                $('send_label').remove();
                sb.show();
            }
            if (!db.visible()) {
                $('draft_label').remove();
                db.show();
            }
        }

        DimpCore.showNotifications(r.msgs);
    },

    toggleHtmlEditor: function(noupdate)
    {
        if (!DIMP.conf_compose.rte_avail) {
            return;
        }
        noupdate = noupdate || false;
        if (DIMP.SpellCheckerObject) {
            DIMP.SpellCheckerObject.resume();
        }

        var msg, oEditor, text;

        if (this.editor_on) {
            this.editor_on = false;

            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                msg = _editors.message;
                text = msg.getHTML();
                $(msg._htmlArea).remove();
                msg = _editors = null;
                break;

            case 'fckeditor':
                oEditor = FCKeditorAPI.GetInstance('message');
                text = oEditor.GetHTML();
                $('messageParent').childElements().invoke('hide');
                $('message').show();
                break;
            }

            DimpCore.doAction('Html2Text', { text: text }, [], this.setMessageText.bind(this), { asynchronous: false });
        } else {
            this.editor_on = true;
            if (!noupdate) {
                DimpCore.doAction('Text2Html', { text: $('message').value }, [], this.setMessageText.bind(this), { asynchronous: false });
            }

            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                xinha_init();
                Event.observe(window, 'resize', this.resizeXinha.bind(this));
                break;

            case 'fckeditor':
                oFCKeditor.Height = this.getMsgAreaHeight();
                // Try to reuse the old fckeditor instance.
                try {
                    oEditor = FCKeditorAPI.GetInstance('message');
                    oEditor.SetHTML($('message').value);
                    $('messageParent').childElements().invoke('show');
                    $('message').hide();
                } catch (e) {
                    oFCKeditor.ReplaceTextarea();
                }
                Event.observe(window, 'resize', this.resizeFCKeditor.bind(this));
                break;
            }
        }
        $('htmlcheckbox').checked = this.editor_on;
        $('html').setValue(this.editor_on ? 1 : 0);
    },

    toggleHtmlCheckbox: function()
    {
        if (!this.editor_on || window.confirm(DIMP.text_compose.toggle_html)) {
            this.toggleHtmlEditor();
        }
    },

    resizeXinha: function()
    {
        $('messageParent').select('.htmlarea').first().setStyle({ height: this.getMsgAreaHeight() + 'px' });
    },

    resizeFCKeditor: function()
    {
        $('messageParent').select('iframe').last().setStyle({ height: this.getMsgAreaHeight() + 'px' });
    },

    getMsgAreaHeight: function()
    {
        // Need an extra 2 pixels of padding since even if $('message') has
        // no padding, the browser (FF at least) adds a pixel of padding on
        // the top and bottom of the textarea.
        return document.viewport.getHeight() - $('messageParent').cumulativeOffset()[1] - this.mp_padding - 2;
    },

    initializeSpellChecker: function()
    {
        if (!DIMP.conf_compose.rte_avail) {
            return;
        }

        if (typeof DIMP.SpellCheckerObject != 'object') {
            // If we fired before the onload that initializes the spellcheck,
            // wait.
            this.initializeSpellChecker.bind(this).defer();
            return;
        }

        DIMP.SpellCheckerObject.onBeforeSpellCheck = function() {
            if (!this.editor_on) {
                return;
            }
            DIMP.SpellCheckerObject.htmlAreaParent = 'messageParent';
            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                DIMP.SpellCheckerObject.htmlArea = _editors.message._htmlArea;
                _editors.message._textArea.setValue(_editors.message.outwardHtml(_editors.message.getHTML()));
                break;

            case 'fckeditor':
                DIMP.SpellCheckerObject.htmlArea = $('message').adjacent('iframe[id*=message]').first();
                $('message').setValue(FCKeditorAPI.GetInstance('message').GetHTML());
                this.textarea_ready = false;
                break;
            }
        }.bind(this);
        DIMP.SpellCheckerObject.onAfterSpellCheck = function() {
            if (!this.editor_on) {
                return;
            }
            DIMP.SpellCheckerObject.htmlArea = DIMP.SpellCheckerObject.htmlAreaParent = null;
            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                _editors.message.setHTML(_editors.message.inwardHtml(_editors.message._textArea.value));
                break;

            case 'fckeditor':
                var ed = FCKeditorAPI.GetInstance('message');
                ed.SetHTML($('message').value);
                ed.Events.AttachEvent('OnAfterSetHTML', function() { this.textarea_ready = true; }.bind(this));
                break;
            }
        }.bind(this);
    },

    setMessageText: function(r)
    {
        var ta = $('message');
        if (!ta) {
            ta = new Element('TEXTAREA', { id: 'message', name: 'message', style: 'width:100%;' }).insert(r.response.text);
            $('messageParent').appendChild(ta);
        } else {
            ta.setValue(r.response.text);
        }

        if (!this.editor_on) {
            this.resizeMsgArea();
        }
    },

    fillForm: function(msg, header, focus, noupdate)
    {
        // On IE, this can get loaded before DOM;loaded. Check for an init
        // value and don't load until it is available.
        if (!this.resizeto) {
            this.fillForm.bind(this, msg, header, focus, noupdate).defer();
            return;
        }

        var bcc_add,
            fo,
            identity = this.get_identity($F('last_identity')),
            msgval = $('message');

        if (this.last_msg != '' &&
            this.last_msg != msgval.value.replace(/\r/g, '') &&
            !window.confirm(DIMP.text_compose.fillform)) {
            return;
        }

        // Set auto-save-drafts now if not already active.
        if (DIMP.conf_compose.auto_save_interval_val && !this.auto_save_interval) {
            this.auto_save_interval = window.setInterval(function() {
                var cur_msg;
                if (this.editor_on) {
                    switch (DIMP.conf_compose.js_editor) {
                    case 'xinha':
                        cur_msg = _editors.message.getHTML();
                        break;

                    case 'fckeditor':
                        cur_msg = FCKeditorAPI.GetInstance('message').GetHTML();
                        break;
                    }
                } else {
                    cur_msg = msgval.value;
                }
                cur_msg = cur_msg.replace(/\r/g, '');
                if (cur_msg != '' && this.last_msg != cur_msg) {
                    this.uniqueSubmit('auto_save_draft');
                    this.last_msg = cur_msg;
                }
            }.bind(this), DIMP.conf_compose.auto_save_interval_val * 60000);
        }

        if (this.editor_on) {
            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                _editors.message.setHTML(msg);
                this.last_msg = _editors.message.getHTML();
                break;

            case 'fckeditor':
                fo = FCKeditorAPI.GetInstance('message');
                fo.SetHTML(msg);
                this.last_msg = fo.GetHTML();
                break;
            }
            this.last_msg = this.last_msg.replace(/\r/g, '');
        } else {
            msgval.setValue(msg);
            this.setCursorPosition(msgval);
            this.last_msg = msgval.value.replace(/\r/g, '');
        }

        $('to').setValue(header.to);
        this.resizeto.resizeNeeded();
        if (header.cc) {
            $('cc').setValue(header.cc);
            this.resizecc.resizeNeeded();
        }
        if (DIMP.conf_compose.cc) {
            this.toggleCC('cc');
        }
        if (header.bcc) {
            $('bcc').setValue(header.bcc);
            this.resizebcc.resizeNeeded();
        }
        if (identity.id[6]) {
            bcc_add = $('bcc').value;
            if (bcc_add) {
                bcc_add += ', ';
            }
            $('bcc').setValue(bcc_add + identity.id[6]);
        }
        if (DIMP.conf_compose.bcc) {
            this.toggleCC('bcc');
        }
        $('subject').setValue(header.subject);
        $('in_reply_to').setValue(header.in_reply_to);
        $('references').setValue(header.references);
        $('reply_type').setValue(header.replytype);

        Field.focus(focus || 'to');
        this.resizeMsgArea();

        if (DIMP.conf_compose.show_editor) {
            if (!this.editor_on) {
                this.toggleHtmlEditor(noupdate || false);
            }
            if (focus == 'message') {
                this.focusEditor();
            }
        }
    },

    focusEditor: function()
    {
        try {
            switch (DIMP.conf_compose.js_editor) {
            case 'xinha':
                _editors.message.focusEditor();
                break;

            case 'fckeditor':
                FCKeditorAPI.GetInstance('message').Focus();
                break;
            }
        } catch (e) {
            this.focusEditor.bind(this).delay(0.1);
        }
    },

    addAttach: function(number, name, type, size)
    {
        var div = new Element('DIV').insert(name + ' [' + type + '] (' + size + ' KB) '),

            input = new Element('INPUT', { type: 'button', atc_id: number, value: DIMP.text_compose.remove });
        div.appendChild(input);
        $('attach_list').appendChild(div);
        input.observe('click', this.removeAttach.bind(this, [ input.up() ]));
        this.resizeMsgArea();
    },

    removeAttach: function(e)
    {
        var ids = [];
        e.each(function(n) {
            n = $(n);
            ids.push(n.firstDescendant().readAttribute('atc_id'));
            n.remove();
        });
        DimpCore.doAction('DeleteAttach', { atc_indices: ids, imp_compose: $F('messageCache') });
        this.resizeMsgArea();
    },

    resizeMsgArea: function()
    {
        if (!this.compose_loaded || this.editor_on) {
            return;
        }

        var m, msg = $('message');
        this.mp_padding = $('messageParent').getHeight() - msg.getHeight();

        if (!this.row_height) {
            m = msg.cloneNode(false);
            // Change the ID and name to not conflict with msg node.
            m.id = m.name = null;
            m.setStyle({ visibility: 'hidden' });
            document.body.appendChild(m);
            m.writeAttribute('rows', 1);
            this.row_height = m.getHeight();
            m.writeAttribute('rows', 2);
            this.row_height = m.getHeight() - this.row_height;
            m.remove();
        }

        /* Logic: Determine the size of a given textarea row, divide that size
         * by the available height, round down to the lowest integer row, and
         * resize the textarea. */
        msg.writeAttribute('rows', parseInt(this.getMsgAreaHeight() / this.row_height) - 1);
        // IE 7 needs this.
        msg.disabled = false;
    },

    uploadAttachment: function()
    {
        var div, u = $('upload');
        $('submit_frame').observe('load', this.attachmentComplete.bind(this));
        this.uniqueSubmit('add_attachment');
        u.stopObserving('change');
        div = new Element('DIV', { id: 'upload_wait' }).insert(DIMP.text_compose.uploading + ' ' + u.value);
        $('attach_cell').replaceChild(div, u);
    },

    attachmentComplete: function()
    {
        var doc, sf = $('submit_frame');
        sf.stopObserving('load');
        doc = sf.contentDocument || sf.contentWindow.document;
        DimpCore.doActionComplete({ responseText: doc.body.innerHTML }, this.uniqueSubmitCallback.bind(this));
    },

    toggleCC: function(type)
    {
        $('send' + type).show();
        $('toggle' + type).up().hide();
    },

    /* Sets the cursor to the given position. */
    setCursorPosition: function(input)
    {
        var msg, pos, range;

        switch (DIMP.conf_compose.compose_cursor) {
        case 'top':
            pos = 0;
            msg = $('message');
            msg.setValue('\n' + msg.value);
            break;

        case 'bottom':
            pos = $('message').value.length;
            break;

        case 'sig':
            pos = $('message').value.replace(/\r\n/g, '\n').lastIndexOf(this.get_identity($F('last_identity')).sig) - 1;
            break;

        default:
            return;
        }

        if (input.setSelectionRange) {
            /* This works in Mozilla */
            Field.focus(input);
            input.setSelectionRange(pos, pos);
        } else if (input.createTextRange) {
            /* This works in IE */
            range = input.createTextRange();
            range.collapse(true);
            range.moveStart('character', pos);
            range.moveEnd('character', 0);
            Field.select(range);
            range.scrollIntoView(true);
        }
    },

    /* Open the addressbook window. */
    openAddressbook: function()
    {
        window.open(DIMP.conf_compose.abook_url, 'contacts', 'toolbar=no,location=no,status=no,scrollbars=yes,resizable=yes,width=550,height=300,left=100,top=100');
    }
};

var ResizeTextArea = Class.create({
    // Variables defaulting to empty:
    //   defaultRows, field, onResize
    maxRows: 5,

    initialize: function(field, onResize)
    {
        this.field = $(field);

        this.defaultRows = Math.max(this.field.readAttribute('rows'), 1);
        this.onResize = onResize;

        var func = this.resizeNeeded.bindAsEventListener(this);
        this.field.observe("click", func);
        this.field.observe("keyup", func);

        this.resizeNeeded();
    },

    resizeNeeded: function()
    {
        var lines = this.field.getValue().split('\n'),
            cols = this.field.readAttribute('cols'),
            newRows = lines.size();
            oldRows = this.field.readAttribute('rows');

        lines.each(function(line) {
            if (line.length >= cols) {
                newRows += Math.floor(line.length / cols);
            }
        });

        if (newRows != oldRows) {
            this.field.writeAttribute('rows', (newRows > oldRows) ? Math.min(newRows, this.maxRows) : Math.max(this.defaultRows, newRows));

            if (this.onResize) {
                this.onResize();
            }
        }
    }
});

document.observe('dom:loaded', function() {
    var DC = DimpCompose,
        boundResize = DC.resizeMsgArea.bind(DC),
        C = DimpCore.clickObserveHandler,
        sf;

    DC.initializeSpellChecker();
    $('upload').observe('change', DC.uploadAttachment.bind(DC));

    // Automatically resize address fields.
    DC.resizeto = new ResizeTextArea('to', boundResize);
    DC.resizecc = new ResizeTextArea('cc', boundResize);
    DC.resizebcc = new ResizeTextArea('bcc', boundResize);

    // Safari requires a submit target iframe to be at least 1x1 size or else
    // it will open content in a new window.  See:
    //   http://blog.caboo.se/articles/2007/4/2/ajax-file-upload
    if (Prototype.Browser.WebKit) {
        sf = $('submit_frame');
        sf.writeAttribute({ position: 'absolute', width: '1px', height: '1px' });
        sf.setStyle({ left: '-999px' });
        sf.show();
    }

    /* Attach click handlers. */
    if ($('compose_close')) {
        C({ d: $('compose_close'), f: DC.confirmCancel.bind(DC) });
    }
    C({ d: $('send_button'), f: DC.uniqueSubmit.bind(DC, 'send_message') });
    C({ d: $('draft_button'), f: DC.uniqueSubmit.bind(DC, 'save_draft') });
    [ 'cc', 'bcc' ].each(function(a) {
        C({ d: $('toggle' + a), f: DC.toggleCC.bind(DC, a) });
    });
    if ($('htmlcheckbox')) {
        C({ d: $('htmlcheckbox'), f: DC.toggleHtmlCheckbox.bind(DC) });
    }
    if ($('compose_specialchars')) {
        C({ d: $('compose_specialchars'), f: function() { window.open(DIMP.conf_compose.specialchars_url, 'chars', 'height=220,width=400'); } });
    }

    $('writemsg').select('.composeAddrbook').each(function(a) {
        C({ d: a, f: DC.openAddressbook.bind(DC) });
    });

    /* Attach other handlers. */
    $('identity').observe('change', DC.change_identity.bind(DC));

    // Various events that may cause the textarea to grow larger than the
    // window size.
    $('togglecc').observe('click', boundResize);
    $('togglebcc').observe('click', boundResize);
    Event.observe(window, 'resize', boundResize);

});

Event.observe(window, 'load', function() {
    DimpCompose.compose_loaded = true;
    DimpCompose.resizeMsgArea();
});
