#!/usr/bin/php4 -q
<?php
/* Script for updating the database structure.
 *
 * $Id: updatedb.php,v 1.16 2004/06/07 12:28:03 x99laine Exp $
*/


/*
 * Initialisation
*/

ini_set('include_path',ini_get('include_path').":/usr/share/pear:/usr/share/php");
require("Console/Getopt.php");

// if mysql.so is not loaded, and cannot be loaded, bail out! 
if (!extension_loaded('mysql')) {
  if (!dl('mysql.so')) {
    echo 
    "E: The MySQL module is not enabled in your PHP4 CGI configuration\n".
    "   and I was unable to load it myself.\n\n".
    "   Please fix your php.ini by adding the following line and run this\n".
    "   script again :\n\n".
    "   extension=mysql.so\n\n";
    exit(1);
  }
}


/**
 * Displays an information message.
 */
function info($msg)
{
  global $opt_quiet;
  if (!$opt_quiet)
    echo "I: $msg\n";
}


/**
 * Displays an error message.
 */
function error($msg)
{
  echo "E: $msg\n";
}


/**
 * Displays program usage.
 */
function syntax()
{
  echo 
  "\nSyntax\n".
  "  updatedb.php [options]\n\n".
  "Options\n".
  " -q quiet mode\n\n".
  " -d database\n".
  " -h host\n".
  " -u user\n".
  " -p password\n\n";
}


/**
 * Upgrades the database from one version to the next
 */
function upgradeDb($oldversion)
{
  // upgrade master tables
  info("Processing : diogenes_*");
  switch($oldversion) {
  default:
    info(" - no changes needed.");
    break;
  }


  // upgrade barrels
  $res = mysql_query("select alias from diogenes_site");
  while (list($alias) = mysql_fetch_row($res))
  {
    info("Processing : {$alias}_menu, {$alias}_page and {$alias}_option");

    switch($oldversion) {
    case "0.9.9.3":
      info(" - upgrading : {$alias}_menu");
      // these field where NULL, change to NOT NULL
      mysql_query("ALTER TABLE `{$alias}_menu` CHANGE `link` `link` TEXT NOT NULL");
      mysql_query("ALTER TABLE `{$alias}_menu` CHANGE `ordre` `ordre` SMALLINT( 6 ) UNSIGNED NOT NULL");
      mysql_query("ALTER TABLE `{$alias}_menu` CHANGE `MIDpere` `MIDpere` SMALLINT( 6 ) UNSIGNED NOT NULL");
    
      // break down old 'link' column into 'link' and 'PID'
      mysql_query("ALTER TABLE `{$alias}_menu` ADD `PID` SMALLINT( 6 ) UNSIGNED NOT NULL");
      $res2 = mysql_query("select MID,link from {$alias}_menu");
      while (list($MID,$link) = mysql_fetch_row($res2)) {
        switch (substr($link,0,3)) {
        case "PI:":
          $pid = substr($link,3);
          mysql_query("UPDATE `{$alias}_menu` SET link='',PID='$pid' WHERE MID='$MID'");
          break;
        case "SE:":
          $adr = substr($link,3);
          mysql_query("UPDATE `{$alias}_menu` SET link='$adr' WHERE MID='$MID'");
          break;
        }
      }
      mysql_free_result($res2);
    
      info(" - creating : {$alias}_option");
      mysql_query("CREATE TABLE `{$alias}_option` (name VARCHAR( 32 ) NOT NULL, value TEXT NOT NULL, PRIMARY KEY (`name`)) TYPE=MyISAM;");    
    
      info(" - registering title, description and keywords");
      $res2 = mysql_query("select title,description,keywords from diogenes_site where alias='$alias'");
      list($title,$description,$keywords) = mysql_fetch_row($res2);
      mysql_query("replace into `{$alias}_option` set name='title',value='$title'");
      mysql_query("replace into `{$alias}_option` set name='description',value='$description'");
      mysql_query("replace into `{$alias}_option` set name='keywords',value='$keywords'");
      break;

    case "0.9.10":
      info(" - adding 'template' field");
      mysql_query("ALTER TABLE `{$alias}_page` ADD `template` VARCHAR(255) NOT NULL");
      info(" - dropping 'hits' field");
      mysql_query("ALTER TABLE `{$alias}_page` DROP `hits`");
      info(" - replacing 'visible' field by 'status'");
      mysql_query("ALTER TABLE `{$alias}_page` DROP `visible`");
      mysql_query("ALTER TABLE `{$alias}_page` ADD `status` tinyint(1) unsigned NOT NULL");
      info(" - modifying 'perms' and 'wperms' to add 'forbidden' access");
      mysql_query("ALTER TABLE `{$alias}_page` CHANGE `perms` `perms` ENUM( 'public', 'auth', 'user', 'admin', 'forbidden' ) DEFAULT 'public' NOT NULL");
      mysql_query("ALTER TABLE `{$alias}_page` CHANGE `wperms` `wperms` ENUM( 'public', 'auth', 'user', 'admin', 'forbidden' ) DEFAULT 'admin' NOT NULL");
      break;
    
    default:
      info(" - no changes needed.");
      break;
    }
  }


  // upgrade master tables
  info("Post-processing : diogenes_*");
  switch($oldversion) {
  case "0.9.9.3":
    info(" - dropping fields : title, description, keywords");
    mysql_query("ALTER TABLE `diogenes_site` DROP `title`");
    mysql_query("ALTER TABLE `diogenes_site` DROP `description`");
    mysql_query("ALTER TABLE `diogenes_site` DROP `keywords`");
    break;

  default:
    info(" - no changes needed.");
    break;
  }

}


/*
 * Main routine
*/

// parse options
$opts = Console_GetOpt::getopt($argv, "qd:h:u:p:");

// default values
$dbdb = "diogenes";
$dbhost = "localhost";
$dbuser = "diogenes";
$dbpwd = "";
$opt_quiet=false;

if ( PEAR::isError($opts) ) {
  echo $opts->getMessage();
  syntax();
  exit(1);
} else {
  $opts = $opts[0];
  foreach ( $opts as $opt) {
    switch ($opt[0]) {
    case "q":
      $opt_quiet=true;
      break;
    case "d":
      $dbdb = $opt[1];
      break;
    case "u":
      $dbuser = $opt[1];
      break;
    case "h":
      $dbhost = $opt[1];
      break;
    case "p":
      $dbpwd = $opt[1];
      break;
    }
  }
}

info("host : $dbhost");
info("user : $dbuser");
info("pass : ".(($dbpwd != "") ? "true" : "false"));
info("database : $dbdb");

if ( !@mysql_connect($dbhost,$dbuser,$dbpwd) or
     !@mysql_select_db($dbdb) ) 
{
  error("Could not connect to database server!");
  exit(1);
}

// database versions history
$versions = array("0.9.9.3", "0.9.10", "0.9.12");

// retrieve the current database version
$res = mysql_query("SELECT value FROM diogenes_option WHERE name='dbversion'");
if (list($dbversion) = mysql_fetch_row($res)) {
  mysql_free_result($res);
} else {
  $dbversion = $versions[0];
}

// check we know the current database version
if (!in_array($dbversion, $versions)) {
  info("Unknown database format version.");
  exit(1);
}

// runs the successive updates
$from = array_search($dbversion, $versions);
$to = sizeof($versions)-1;

for($pos = $from; $pos < $to; $pos++) {
  $oldversion = $versions[$pos];
  $newversion = $versions[$pos+1];
  info("Upgrading from DB format '$oldversion' to '$newversion'");
  upgradeDb($oldversion);
  mysql_query("REPLACE INTO diogenes_option SET name='dbversion',value='$newversion'");
}

?>
