<?php
require_once 'diogenes.common.inc.php';
require_once 'diogenes.toplevel.inc.php';
require_once 'diogenes.barrel.options.inc.php';

$page = new $globals->toplevel(true);

$page->assign('greeting',__("List of sites"));
$page->assign('msg_alias',__("alias"));
$page->assign('msg_title',__("title"));
$page->assign('msg_actions',__("actions"));
$page->assign('msg_desc',__("description"));
$page->assign('msg_keywords',__("keywords"));
$page->assign('msg_create',__("Create a new site"));
$page->assign('msg_create_note',__("The site alias may only contain letters, numbers and underscores."));
$page->assign('msg_submit',__("Submit"));
$page->assign('msg_vhost',__("vhost (see note)"));
$page->assign('msg_vhost_note', __("<b>vhost note</b>: If you intend to serve this site from a virtualhost, you should enter the name of the virtualhost in this field."));
$page->assign('msg_flags',__("flags"));

$page->assign('post',$page->script_self());

$action = isset($_REQUEST["action"]) ? $_REQUEST["action"] : "list";
switch($action) {
  case "create":
    if (isset($_REQUEST["target"])) {
      $page->create_barrel($_REQUEST["target"]);
    }
    $action="list";
    break;
  case "update":
    if (isset($_REQUEST["target"])) {
      // build flags
      $flags = isset($_REQUEST['flags']) ? implode(",",array_values($_REQUEST['flags'])) : "";
      $globals->db->query("update diogenes_site set vhost='{$_REQUEST['vhost']}',flags='$flags' where alias='{$_REQUEST['target']}'");
      $opts = new DiogenesBarrelOptions($_REQUEST['target']);
      $opts->updateOption('description', $_REQUEST['description']);
      $opts->updateOption('title', $_REQUEST['title']);
      $opts->updateOption('keywords', $_REQUEST['keywords']);
    }
    $action="list";
    break;
  case "edit":
    if (isset($_REQUEST["target"])) {
      $res = $globals->db->query("select alias,vhost,flags from diogenes_site where alias='{$_REQUEST['target']}'");
      if (!list($target,$vhost,$flags) = mysql_fetch_row($res)) {
        $page->info("Could not find specified site!");
        $action = "list";
        break;
      }
      mysql_free_result($res);
      $page->assign('target',$target);
      $page->assign('v_vhost',$vhost);
      $flags = new flagset($flags);
      $flag_opts = array('exec' => __("PHP execution"), 'tpl' => __("custom templates"));
      $page->assign('v_flag_opts', $flag_opts);
      foreach($flag_opts as $key=>$val) {
        if ($flags->hasFlag($key))
	  $page->append('v_flags', $key);
      }
      $opts = new DiogenesBarrelOptions($target);
      $page->assign('v_desc',$opts->description);
      $page->assign('v_title',$opts->title);
      $page->assign('v_keywords',$opts->keywords);

    }
    break;
  case "delete":
    if (isset($_REQUEST["target"])) {
      $page->destroy_barrel($_REQUEST["target"]);
    }
    $action="list";
    break;
  default:
    $action="list";
}

if ($action == "list") {
  $res = $globals->db->query("select alias,vhost from diogenes_site");
  $odd = false;
  while (list($s_alias,$s_vhost) = mysql_fetch_row($res)) {
    $opts = new DiogenesBarrelOptions($s_alias);
    $page->append('sites',array($odd ? "odd" : "even",$s_alias,$opts->title,$opts->description,
                  array( array(__("view"), $page->urlBarrel($s_alias,$s_vhost) ),
                         array(__("edit"), "?action=edit&amp;target=$s_alias"),
                         array(__("admin"), $page->urlBarrel($s_alias,$s_vhost,"admin/")),
                         array(__("delete"), "javascript:del('$s_alias');")
                  ) ) );
    $odd = !$odd;
  }
  mysql_free_result($res);
} // $action == "list"

$page->assign('action',$action);
$page->display('toplevel-sites.tpl');
?>
