<?php
require_once 'diogenes.common.inc.php';
require_once 'diogenes.toplevel.inc.php';
require_once 'diogenes.logger-view.inc.php';
// dependency on PEAR
require_once 'System.php';

$page = new $globals->toplevel(true);

$action = isset($_REQUEST['action']) ? $_REQUEST['action'] : "";

switch ($action) {
case "cvs-rcs":
  $page->info("converting spool from CVS to RCS..");
  $res = $globals->db->query("select alias from diogenes_site");
  while(list($site) = mysql_fetch_row($res)) {
    $page->info("processing '$site'..");
    $spool = new DiogenesSpool($page,$site);
    $page->info("-> deleting 'CVS' subdirectories from spool..");
    $goners = System::find($spool->datadir.' -type d');
    foreach($goners as $goner) {
      if (basename($goner) == "CVS")
        System::rm("-r $goner");
    }
    $page->info("-> changing files in spool to read-only..");
    $modfiles = System::find($spool->datadir.' -type f');
    foreach($modfiles as $modfile) {
      chmod($modfile,0444);
    }
  }
  $globals->updateOption("rcs","DiogenesRcs");
  break;

case "rcs-cvs":
  $page->info("converting spool from RCS to CVS..");
  if (!is_dir("{$globals->rcsroot}/CVSROOT")) {
    $page->info("-> no CVSROOT not found, running init..");
    if ($ret = shell_exec("cvs -d".escapeshellarg($globals->rcsroot)." init"))
      $page->info($ret);
  }

  // remove current spool dirs and do a clean checkout of each site
  $res = $globals->db->query("select alias from diogenes_site");
  while(list($site) = mysql_fetch_row($res)) {
    $page->info("processing '$site'..");
    $page->info("-> removing '{$globals->spoolroot}/$site'..");
    System::rm("-r {$globals->spoolroot}/$site");
    $page->info("-> doing a checkout of module '$site'..");
    $spool = new DiogenesCvs($page,$site,$_SESSION['session']->username,true);
  }
  $globals->updateOption("rcs","DiogenesCvs");
  break;
  
case "options":
  $globals->updateOption("menu_style", $_REQUEST['menu_style']);
  if (isset($_REQUEST['menu_theme']))
    $globals->updateOption("menu_theme", $_REQUEST['menu_theme']);
  $globals->updateOption("template_dir", $_REQUEST['template_dir']);
  $globals->updateOption("template", $_REQUEST['template']);
  break;
}


// fill out values
$page->assign('menu_styles', $globals->menu_styles);
$page->assign('menu_style', $globals->menu_style);
if ($globals->menu_style == 1 || $globals->menu_style == 2) {
  $page->assign('menu_themes', $globals->menu_themes);
  $page->assign('menu_theme', $globals->menu_theme);
}
$page->assign('template_dir', $globals->template_dir);
$page->assign('template', $globals->template);
$page->assign('templates', $page->getTemplates());


// translations
$page->assign('greeting', __("Global options"));
$page->assign('msg_menu_options', __("menu options"));
$page->assign('msg_menu_style', __("menu style"));
$page->assign('msg_menu_theme', __("menu theme"));
$page->assign('msg_template_options', __("template options"));
$page->assign('msg_site_template_dir', __("templates directory"));
$page->assign('msg_site_template', __("default template"));
$page->assign('msg_submit', __("Submit"));
$page->assign('msg_convert',__("Convert"));
$page->assign('msg_vcs',__("version control system"));

switch ($globals->rcs) {
case "DiogenesRcs":
  $page->assign('msg_current_vcs',__("You are currently using RCS as the version control system for your barrels."));
  $page->append('conversions',array("rcs-cvs", __("You can switch to a full CVS repository by clicking here.")));
  break;

case "DiogenesCvs":
  $page->assign('msg_current_vcs',__("You are currently using CVS as the version control system for your barrels."));
  $page->append('conversions',array("cvs-rcs", __("You can switch back to RCS by clicking here.")));
  break;
}

$page->display('toplevel-options.tpl');
?>
