<?php
/*
 * Copyright (C) 2003-2004 Polytechnique.org
 * http://opensource.polytechnique.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


require_once 'diogenes.page.inc.php';
require_once 'diogenes.barrel.options.inc.php';

/** This class is used to display a page of a Diogenes barrel,
 *  that is an RCS-managed website with a virtual directory
 *  structure.
 *
 * @version $Id: diogenes.barrel.inc.php,v 1.142 2004/06/07 12:28:03 x99laine Exp $
 */
class DiogenesBarrel extends DiogenesPage
{
  /** The database table holding the menus */
  var $table_menu;

  /** The database table holding the pages */
  var $table_page;
  
  /** The site's flags. */
  var $flags;

  /** The site's options. */
  var $options;
  
  /** Information about the current location */
  var $pathinfo;
  
  /** The current directory/page id */
  var $PID;

  /** If the barrel is running on a virtualhost. */
  var $vhost;

  /** The barrel's alias. */
  var $alias;

  /** Can the current user edit this page? */
  var $canedit = false;

  /** The constructor.
   */
  function DiogenesBarrel()
  {
    global $globals;

    // call parent constructor
    $this->DiogenesPage();

    // break down PATH_INFO into site and location components
    $this->pathinfo = $this->parsePathInfo($_SERVER['PATH_INFO']);
    if (!$this->pathinfo)
      $this->kill404("Invalid location specified!");
    $this->alias = $this->pathinfo['alias'];

    // Retrieve site-wide info from database
    $res = $globals->db->query("select alias,vhost,flags from diogenes_site where alias='{$this->alias}'");
    if (!list($this->alias,$this->vhost,$flags) = mysql_fetch_row($res)) {
      $this->kill404("Could not find the requested site!");
    }

    $this->table_menu = "{$this->alias}_menu";
    $this->table_page = "{$this->alias}_page";
    $this->flags = new flagset($flags);    
    $this->options = new DiogenesBarrelOptions($this->alias);
    $this->spool = new DiogenesSpool($this,$this->alias);
  }


  /** Check the user has the right permissions.
   *  Read the user's permissions for the current site from database.
   *
   * @param level the required permissions level
   */
  function checkPerms($level) {
    global $globals;

    if ($level != "public")
      $_SESSION['session']->doAuth($this);

    $_SESSION['session']->setBarrelPerms($this->alias);

    if (!$_SESSION['session']->hasPerms($level))
      $this->kill(__("You are not authorized to view this page!"), 403);
  }


  /** Read the contents for the current location.
   */
  function doContent()
  {
    global $globals;

  // Retrieve information specific to the current page

    // enable directory index
    $file = $this->pathinfo['file'] ? $this->pathinfo['file'] : $globals->htmlfile;

    // read from Db
    $res = $globals->db->query("SELECT PID,title,perms,wperms,template,status FROM {$this->table_page} WHERE ".
                         "location='{$this->pathinfo['dir']}'");
    if ( !list($this->PID,$page_title,$page_perms,$page_wperms,$page_template,$page_status) = mysql_fetch_row($res) ) {
      $this->kill404("Directory not found!");
    }
    
    // check the permissions for the current location
    if (!$this->pathinfo['file'] || $page_perms != 'public' || isset($_REQUEST['rev'])) {
      $this->startSession();

      // handle login/logout requests
      if (isset($_REQUEST['dologout'])) 
        $this->doLogout();
      if (isset($_REQUEST['doauth'])) 
        $this->checkPerms('auth');

      $this->checkPerms($page_perms);
 
      // can we edit this page?
      $this->canedit = $_SESSION['session']->hasPerms($page_wperms);
    }

  // now we can display the page
    // check the location is valid
    if (!$this->spool->checkPath($this->PID,$file,false))
      $this->kill404("Malformed location!");

    // check that the page is 'live'
    switch ($page_status) {
    case 0:
      break;
    case 1:
      $this->assign('page_content', "<p>".__("This page is currently under construction.")."<p>");
      $this->display('');
      exit;
    default:
      $this->assign('page_content', "<p>".__("This page is currently unavailable.")."<p>");
      $this->display('');
      exit;
    }
    
    // if necessary, do a checkout
    if (isset($_REQUEST['rev'])) {
      $rcs = $this->getRcs();
      $path = $rcs->checkout($this->PID,$file,$_REQUEST['rev'],System::mktemp("-d"));
    } else {
      $path = $this->spool->spoolPath($this->PID,$file);
    }

    if (!is_file($path))
      $this->kill404("File not found!");

    if (!$this->pathinfo['file']) {
      // this is a page, display it within header/footer framework
      $this->doPage($path, $page_title, $page_template);
    } else {
      // otherwise, we send back the raw file
      $type = mime_content_type($path);
      header("Content-Type:$type");
      header("Last-modified:".gmdate("D, d M Y H:i:s T", filemtime($path)));
      readfile($path);
    }

  }


  /** Display a page within the header/footer framework.
   *
   * @param path the path of the file
   * @param title the title of the page
   */
  function doPage($path, $title, $template)
  {
    global $globals;

    $this->assign('page',stripslashes($title));
    
    // source page or pass it to the template as an argument
    if ($this->flags->hasFlag("exec")) {
      $this->assign('page_include', $path); 
    } else {
      $this->assign('page_content', file_get_contents($path));
    }

    $this->display('', $this->getTemplate($template));
  }


  /** Return an RCS handle. */
  function getRcs()
  {
    global $globals;
    return new $globals->rcs($this,$this->alias,$_SESSION['session']->username);
  }

 
  /** Returns the master template for the current context.
   *
   * @param template
   */
  function getTemplate($template = '')
  {
    if ($template)
    {
      // we have a page-specific template, get its full path
      $tpl = $this->templatePath($template);
    } else if ($this->options->template) {
      // we have default site template, get is full path
      $tpl = $this->templatePath($this->options->template);
    } else {
      // fall back on the system-wide default template
      $tpl = parent::getTemplate();
    }
    return $tpl; 
  }
  
 
  /** Returns the available master templates. */
  function getTemplates()
  {
    // the system-wide templates
    $templates = parent::getTemplates();

    // lookup templates in the template directory
    if ($this->flags->hasFlag('tpl') && $this->options->template_dir) {
      $dir = $this->spool->spoolPath($this->options->template_dir);
      $files = System::find($dir.' -maxdepth 1 -name *.tpl');
      foreach ($files as $file)
        $templates["barrel:".basename($file)] = "[barrel] ".basename($file);
    }
    return $templates; 
  }


  /** Is the user an administrator for the current barrel ? */
  function isAdmin() {
    return isset($_SESSION['session']) && $_SESSION['session']->hasPerms('admin');
  }


  /** Build the page's "head" tag.
   */
  function makeHead() {
    global $globals;
  
    // site name
    $this->assign('site', stripslashes($this->options->title));
    
    // meta
    array_push($this->head, '<meta name="description" content="'.stripslashes($this->options->description).'" />');
    array_push($this->head, '<meta name="keywords" content="'.stripslashes($this->options->keywords).'" />');

    // stylesheets
    array_push($this->head, '<link rel="stylesheet" href="'.$this->url("common.css").'" type="text/css" />');
    if ($this->options->menu_style == 1 || $this->options->menu_style == 2) 
      array_push($this->head, '<link rel="stylesheet" href="'.$this->url("phplayersmenu/{$this->options->menu_theme}/style.css").'" type="text/css" />');
    array_push($this->head, '<link rel="stylesheet" href="'.$this->urlSite($globals->cssfile).'" type="text/css" />');

    // favicon
    if ($this->options->favicon)
      array_push($this->head, '<link rel="icon" href="'.$this->urlSite($this->options->favicon).'" type="image/png" />');
  }


  /** Build the barrel's menu.
   */
  function makeMenu() {
    global $globals;

    // menu style & theme
    $this->assign('menustyle', $this->options->menu_style);
    $this->assign('menutheme', $this->options->menu_theme);
    
    // build the Diogenes part of the menu
    array_push($this->menu,array(1,__("Home"),$this->urlSite("")));
    if ($this->isLogged()) {
      array_push($this->menu, array(1,__("Logout"), "?dologout=1") );
    } else {
      array_push($this->menu, array(1,__("Login"), "?doauth=1") );
    }
    
    if ($this->isAdmin()) {
      array_push($this->menu, array(0, __("Administration"), $this->urlSite("admin/"), 1));
      if ($this->PID)
        array_push($this->menu, array(1, __("Page properties"), $this->urlSite("admin/pages?PID={$this->PID}")));
    } elseif ($this->canedit && $this->PID) {
      array_push($this->menu, array(0, __("Edit this page"), "", 1));
      array_push($this->menu, array(1, __("Raw editor"), $this->urlSite("admin/edit?dir={$this->PID}&amp;file={$globals->htmlfile}")));
      array_push($this->menu, array(1, __("HTML editor"), $this->urlSite("admin/ekit?dir={$this->PID}&amp;file={$globals->htmlfile}")));
    }
   
    // if this is an error page, we need to bail out here
    if (!isset($this->table_menu))
      return;
   
    // try to figure out the current MID from the current PID
    // and build filiation
    $filiation = array();
    $res = $this->dbh->query("select MID from {$this->table_menu} where PID='{$this->PID}'");
    while (list($MID) = mysql_fetch_row($res))
      $filiation = $this->menuToRoot($MID, $filiation);
    mysql_free_result($res);

    // add the user-defined part of the menu
    $this->menu = array_merge($this->menu,$this->menuRecurse(0,$filiation,0));
  }


  /** Return the filiation to get to the root element.
   *
   * @param MID
   * @param path
   */
  function menuToRoot($MID, $path) {
    /* add ourself to the path */
    array_push($path,$MID);

    if ($MID) {
      /* recursion */
      $res = $this->dbh->query("select MIDpere from {$this->table_menu} where MID=$MID");
      list($MIDpere) = mysql_fetch_row($res);
      mysql_free_result($res);

      return $this->menuToRoot($MIDpere, $path);
    } else {
      /* termination */
      return $path;
    }
  }


  /** Recursively add menu entries
   *
   * @param MIDpere
   * @param filiation
   * @param level
   */
  function menuRecurse($MIDpere, $filiation, $level) {
    // the produced output
    $out = array();

    $res = $this->dbh->query("select m.MID,m.title,m.link,m.PID,p.location ".
                       "from {$this->table_menu} as m ".
                       "left join {$this->table_page} as p on m.PID=p.PID ".
                       "where MIDpere=$MIDpere order by ordre");

    while(list($mid,$title,$link,$pid,$location) = mysql_fetch_row($res)) {
      $title = stripslashes($title);
      $aclass =  ($MIDpere && !($level%2))  ? "class='odd' " : "";
      $entry = htmlentities(stripslashes($title), ENT_QUOTES);
      $link = $pid ? $this->urlSite($location ? "$location/" : "") : $link;      
      // decide whether this menu should be expanded
      $expanded = ($this->options->menu_min_level == 0) || 
                  ($level+1 < $this->options->menu_min_level) || 
                   in_array($mid, $filiation);
      array_push($out, array($level, $entry, $link, $expanded));      
      $out = array_merge($out, $this->menuRecurse($mid, $filiation, $level+1));
    }

    // free MySQL result and return output
    mysql_free_result($res);
    return $out;
  }


  /** 
   * Break down a PATH_INFO into site, page id and file
   * Directories *must* be accessed with a final slash.
   *
   * @param path the path to parse
   */
  function parsePathInfo($path) {
    if (empty($path) || !preg_match("/^\/([^\/]+)\/((.+)\/)?([^\/]*)$/",$path,$asplit))
      return false;
    
    $split['alias'] = $asplit[1];
    $split['dir'] = isset($asplit[3]) ? $asplit[3] : "";
    $split['file'] = isset($asplit[4]) ? $asplit[4] : "";
    return $split;
  }


  /** Return the current URI.
   */
  function script_uri() {
    if ($this->vhost)
      return preg_replace("/^(.*)\/site\/{$this->alias}\/(.*)/", "/\$2",$_SERVER['REQUEST_URI']);
    else
      return $_SERVER['REQUEST_URI'];
  }


  /** Returns the path to a given template. */
  function templatePath($template)
  {
    global $globals;
    
    $bits = split(":", $template);
    switch ($bits[0]) {
    case "global":
      $path = $globals->template_dir."/". $bits[1];
      break;
    case "barrel":
      $path = $this->spool->spoolPath($this->options->template_dir, $bits[1]);
      break;
    default:
      $path = parent::templatePath($template);
    }
    return $path;
  }
 

  /** Returns the URL to one of the barrel's pages relative to
   *  the current location.
   *
   * @param rel
   */
  function urlSite($rel) {
    $tosite = $this->pathinfo['dir'] ? str_repeat("../",1+substr_count($this->pathinfo['dir'],"/")) : "";
    return $tosite.$rel ? $tosite.$rel : "./";
  }

}

?>
