<?php
/*
 * Copyright (C) 2003-2004 Polytechnique.org
 * http://opensource.polytechnique.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


require_once 'diogenes.page.inc.php';
require_once 'diogenes.barrel.options.inc.php';

/** This class describes a toplevel Diogenes page.
 *
 * @version $Id: diogenes.toplevel.inc.php,v 1.52 2004/06/07 12:28:03 x99laine Exp $
 */
class DiogenesToplevel extends DiogenesPage {

  /** The constructor.
   *
   * @param admin is this an admin page?
   */
  function DiogenesToplevel($admin = false)
  {
    // page basics
    $this->DiogenesPage();
    $this->assign('site',"Diogenes");  
    $this->assign('page', $admin ? __("Toplevel administration") : __("Home"));

    // start session
    $this->startSession();

    // handle logout request
    if (isset($_REQUEST['dologout'])) 
      $this->doLogout();

    // do auth
    if ($admin || isset($_REQUEST['doauth']))
      $_SESSION['session']->doAuth($this);
    
    if ($admin && !$_SESSION['session']->hasPerms("root"))
      $this->kill(__("You are not authorized to view this page!"), 403);
  }


  /** Create a new Diogenes barrel. This creates the database, RCS and
   *  spool entries for the new barrel.
   */
  function create_barrel($alias) {
    global $globals;

    /* sanity check */
    if (!preg_match("/^[a-zA-Z0-9_]+$/",$alias) or
        in_array($alias, $globals->invalidaliases)) 
    {
      $this->info("Invalid barrel name!");
      return;
    }

    $res = $this->dbh->query("select alias from diogenes_site where alias='$alias'");
    if (mysql_num_rows($res) > 0) {
      $this->info("Entry '{$alias}' already exists in table 'diogenes_site'!");
      return;
    }

    if (file_exists("{$globals->rcsroot}/$alias")) {
      $this->info("Directory '{$globals->rcsroot}/$alias' already exists!");
      return;
    }

    if (!is_dir($globals->rcsroot) || !is_writable($globals->rcsroot)) {
      $this->info("Directory '{$globals->rcsroot}' is not writable!");
      return;
    }

    /* log this event */
    $_SESSION['log']->log("barrel_create","$alias:*");

    /* create DB entry */
    $this->dbh->query("insert into diogenes_site set alias='$alias'");

    $this->dbh->query("CREATE TABLE {$alias}_menu ("
    . "MID smallint(6) unsigned NOT NULL auto_increment,"
    . "MIDpere smallint(6) unsigned NOT NULL,"
    . "ordre smallint(6) unsigned NOT NULL,"
    . "title tinytext NOT NULL,"
    . "link text NOT NULL,"
    . "PID smallint(6) unsigned NOT NULL,"
    . "PRIMARY KEY  (MID)"
    . ") TYPE=MyISAM;");

    $this->dbh->query("CREATE TABLE {$alias}_page ("
    . "PID smallint(6) unsigned NOT NULL auto_increment,"
    . "location tinytext NOT NULL,"
    . "title tinytext NOT NULL,"
    . "status tinyint(1) unsigned NOT NULL default '0',"
    . "perms enum('public','auth','user','admin','forbidden') NOT NULL default 'public',"
    . "wperms enum('public','auth','user','admin','forbidden') NOT NULL default 'admin',"
    . "template varchar(255) NOT NULL,"
    . "PRIMARY KEY  (PID)"
    . ") TYPE=MyISAM;");
    
    $this->dbh->query("CREATE TABLE {$alias}_option ("
    . "name VARCHAR( 32 ) NOT NULL,"
    . "value TEXT NOT NULL,"
    . "PRIMARY KEY (name)"
    . ") TYPE=MyISAM;");

    /* set the barrel's title */
    $opt = new DiogenesBarrelOptions($alias);
    $opt->updateOption('title',$alias);

    /* create entry for the homepage */
    $this->dbh->query("insert into {$alias}_page set location='temp'");
    $homepage = mysql_insert_id();
    $this->dbh->query("update {$alias}_page set location='',title='Home',perms='public' where PID='$homepage'");

    /* create home page & copy CSS template */
    $rcs = new $globals->rcs($this,$alias,$_SESSION['session']->username,true);
    $rcs->newdir("",$homepage);
    $rcs->commit($homepage,$globals->htmlfile,"");
    $rcs->commit($homepage,$globals->cssfile,
                        file_get_contents("{$globals->root}/{$globals->cssfile}") );
  }


  /** Destroy a Diogenes barrel. This removes the related database, RCS
   *  and spool entries.
   */
  function destroy_barrel($alias) {
    global $globals;

    /** Sanity check */
    if (!$alias) {
      $this->info("Empty alias supplied!");
      return;
    }

    /* log this event */
    $_SESSION['log']->log("barrel_delete","$alias:*");

    system("rm -rf ".escapeshellarg("{$globals->spoolroot}/$alias"));
    system("rm -rf ".escapeshellarg("{$globals->rcsroot}/$alias"));

    $this->dbh->query("drop table {$alias}_menu");
    $this->dbh->query("drop table {$alias}_page");
    $this->dbh->query("drop table {$alias}_option");
    $this->dbh->query("delete from diogenes_perm where alias='$alias'");
    $this->dbh->query("delete from diogenes_site where alias='$alias'");
  }

    
  /** Build the contents of the page's "head" tag.
   */
  function makeHead()
  {
    array_push($this->head, '<meta name="description" content="Diogenes content management system" />');
    array_push($this->head, '<meta name="keywords" content="Diogenes, Polytechnique.org, Jeremy Lain" />');
    array_push($this->head, '<link rel="stylesheet" href="'.$this->url("common.css").'" type="text/css" />');
    array_push($this->head, '<link rel="stylesheet" href="'.$this->url("toplevel.css").'" type="text/css" />');
    array_push($this->head, '<link rel="icon" href="'.$this->url("images/favicon.png").'" type="image/png" />');
  }


  /** Build the page's menu.
   */
  function makeMenu()
  {
    global $globals;
    
    // menu style & theme
    $this->assign('menustyle', $globals->menu_style);
    $this->assign('menutheme', $globals->menu_theme);

    // menu items
    array_push($this->menu, array(0,"Diogenes", "", 1));
    array_push($this->menu, array(1,__("Home"), $this->url("")));
    array_push($this->menu, array(1,__("User manual"), __("http://diogenes-doc.polytechnique.org/en-user/")) );

    if ($this->isLogged()) {
      array_push($this->menu, array(1,__("Preferences"),$this->url("prefs.php")) );
      array_push($this->menu, array(1,__("Logout"), $this->url("?dologout=1")) );
    } else {
      array_push($this->menu, array(1,__("Login"), $this->url("?doauth=1")) );
    }
    if ($this->isRoot()) {
      array_push($this->menu, array(0,__("Sites"), "", 1));
      array_push($this->menu, array(1, __("Root manual"), __("http://diogenes-doc.polytechnique.org/en-root/")) );
      array_push($this->menu, array(1,__("List of sites"), $this->url("toplevel/")) );
      array_push($this->menu, array(1,__("Administrators"),$this->url("toplevel/admins.php")) );
      array_push($this->menu, array(1,__("Global options"),$this->url("toplevel/options.php")) );
      array_push($this->menu, array(0,__("Users"), "", 1));
      array_push($this->menu, array(1,__("User accounts"),$this->url("toplevel/accounts.php")) );
      array_push($this->menu, array(1,__("Browse user log"),$this->url("toplevel/logger.php")) );
      array_push($this->menu, array(1,__("Logger actions"),$this->url("toplevel/logger_actions.php")) );
    }
  }

}

?>
