<?php
/*
 * Copyright (C) 2003-2004 Polytechnique.org
 * http://opensource.polytechnique.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/** Class for handling database requests. It is a wrapper around a permanent
 *  MySQL database connection with some commonly used functions.
 *
 * @version $Id: diogenes.database.inc.php,v 1.11 2004/05/24 12:29:33 x99laine Exp $
 */
class DiogenesDatabase {
  /** The id of the permanent database connection. */
  var $connect_id;
  /** Are we in debugging mode. */
  var $_trace=false;
  /** mysql_queries */
  var $_trace_data = Array();

  /** The constructor.
   *
   * @param database
   * @param host
   * @param user
   * @param password
   */
  function DiogenesDatabase($database, $host, $user, $password) {
    // make sure that we have MySQL support
    if (!extension_loaded('mysql')) {
      echo "MySQL support needs to be activated in your PHP configuration!<br>";
      echo "Add a line with 'extension=mysql.so' in your php.ini file.";
      exit;
    }
    
    if(empty($user)){
      $this->connect_id=@mysql_pconnect();
    } else {
      $this->connect_id=@mysql_pconnect($host, $user, $password);
    }

    if ($this->connect_id) {
      @mysql_select_db($database,$this->connect_id);
      return $this->connect_id;
    } else {
      return 0;
    }
  }


  /** Deactivate trace mode.
   */
  function trace_off() {
      $this->_trace = false;
  }

  
  /** Activate trace mode.
   */
  function trace_on() {
      $this->_trace = true;
  }


  /** Formats tracing information for output.
   *
   * @param page
   * @param template
   */
  function trace_format(&$page,$template='') {
      global $globals;
      if(empty($template))
          $template = $globals->libroot . '/templates/database-debug.tpl';
      $page->assign_by_ref('trace_data', $this->_trace_data);
      return $page->fetch($template);
  }


  /** Execute a database query.
   *
   * @param query
   */
  function query($query) {
    if (!empty($query)) {
      
      $res = mysql_query($query, $this->connect_id);

      if($this->_trace) {
        $error = $this->error();
        
        $_res = mysql_query("EXPLAIN $query", $this->connect_id);
        $explain = Array();
        while($row = @mysql_fetch_assoc($_res)) $explain[] = $row;
        $this->_trace_data[] = Array(
            'query' => $query,
            'error' => $error,
            'explain' => $explain
        );
        @mysql_free_result($_res);
      }

      return $res;
    }
  }


  /** Return insert_id
   */
  function insert_id()
  {
    return @mysql_insert_id($this->connect_id);
  }


  /** Return the last error.
   */
  function error() {
    return @mysql_error($this->connect_id);
  }


  /** Return the number rows affected by the last query.
   */
  function affected_rows() {
    return @mysql_affected_rows($this->connect_id);
  }


  /** Return an array with the possibly values of a set column.
   *
   * @param table
   * @param column
   */
  function get_set($table,$column) {
    $res = $this->query("show columns from $table like '$column'");
    $line = mysql_fetch_assoc($res);
    $set = $line['Type'];
    $set = substr($set,5,strlen($set)-7);
    return preg_split("/','/",$set);
  }

}

?>
