<?php
/*
 * Copyright (C) 2003-2004 Polytechnique.org
 * http://opensource.polytechnique.org/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


/** This class handles Diogenes spool operations.
 *
 * @version $Id: diogenes.spool.inc.php,v 1.8 2004/06/01 11:54:45 x99laine Exp $
 */
class DiogenesSpool {
  /** The barrel we are running on */
  var $alias;
  /** Absolute directory location for the barrel's spool. */
  var $datadir;

  /** The caller. It needs to define the 3 following methods :
   * 
   * @see info, kill, log
   */
  var $caller;

  /** The constructor.
   *
   * @param caller the caller
   * @param alias the alias to work on
   */
  function DiogenesSpool(&$caller,$alias) {
    global $globals;
    $this->datadir = "{$globals->spoolroot}/$alias";
    $this->caller =& $caller;
    $this->alias = $alias;
  }


  /** Report an information.
   *
   * @param msg
   */
  function info($msg) {
    $this->caller->info($msg);
  }


  /** Die with a given error message.
   *
   * @param msg
   */
  function kill($msg) {
    $this->caller->kill($msg);
  }


  /** Record an action to the log.
   *
   * @param action
   * @param data
   */
  function log($action,$data) {
    $this->caller->log($action, $data);
  }


  /** Check that a path is valid.
   *
   * @param parent parent directory
   * @param entry the item
   * @param fatal should we consider a failure to be fatal?
   */
  function checkPath($parent,$entry,$fatal = true) {
    $ret = preg_match("/^([a-zA-Z0-9\-_]+[\.,\/]?)*$/",$parent)
        && preg_match("/^([a-zA-Z0-9\-_]+[\.,]?)*$/",$entry);

    if (!$ret && $fatal)
      $this->kill("malformed path ('$parent','$entry')");
    
    return $ret;
  }


  /** Add missing tags to a Diogenes page to make it a proper HTML file
   *
   * @param html
   * @see importHtmlString
   */
  function exportHtmlString($html)
  {
    // if we have the body open & close tags, return raw file
    if (preg_match("/<body(\s[^>]*|)>(.*)<\/body>/si",$html))
      return $html;
    
    return "<html>\n<head><title>Diogenes page</title></head>\n<body>$html</body>\n</html>\n";
  }


  /** Makes a Diogenes page from a proper HTML file, that is return everything
   *  inside the "body" tags.
   *
   * @param html
   * @see exportHtmlString
   */
  function importHtmlString($html)
  {
    // if we cannot find the body open & close tags, return raw file
    if (!preg_match("/<body(\s[^>]*|)>(.*)<\/body>/si",$html,$matches))
      return $html;

    return $matches[2];
  }


  /** Return the path of a spool "item" (file or directory).
   *
   * @param parent parent directory (optional)
   * @param entry the item
   */
  function spoolPath($parent="",$entry="") {
    $this->checkPath($parent,$entry);
    return $this->datadir.($parent ? "/$parent": "") . ($entry ? "/$entry" : "");
  }

}

?>
