/*
 * Decompiled with CFR 0.152.
 */
package de.xeinfach.kafenio;

import de.xeinfach.kafenio.KafenioAppletObserver;
import de.xeinfach.kafenio.KafenioPanel;
import de.xeinfach.kafenio.KafenioPanelConfiguration;
import de.xeinfach.kafenio.KafenioToolBar;
import de.xeinfach.kafenio.SplashScreen;
import de.xeinfach.kafenio.component.ExternalEditorFrame;
import de.xeinfach.kafenio.interfaces.KafenioContainerInterface;
import de.xeinfach.kafenio.interfaces.KafenioControllerSaveContentInterface;
import de.xeinfach.kafenio.util.LeanLogger;
import de.xeinfach.kafenio.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class KafenioApplet
extends JApplet
implements KafenioControllerSaveContentInterface,
KafenioContainerInterface {
    private static LeanLogger log = new LeanLogger("KafenioApplet.class");
    private KafenioToolBar kafenioToolBar1;
    private KafenioToolBar kafenioToolBar2;
    private JPanel toolbarPanel;
    private KafenioPanel kafenioPanel;
    private KafenioAppletObserver appletRegister;
    private JLabel jlblStatus;
    private Vector vcTools;
    private KafenioPanelConfiguration config;
    private ExternalEditorFrame externalEditorFrame;
    private SplashScreen splash;

    public KafenioApplet() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.appletRegister = KafenioAppletObserver.getInstance();
    }

    public void init() {
        this.showSplash();
        this.getContentPane().removeAll();
        this.appletRegister.registerNewApplet(this);
        this.config = this.readConfig();
        if (this.config.isDebugMode()) {
            LeanLogger.setCurrentLogLevel(4);
        }
        this.kafenioPanel = new KafenioPanel(this.config);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(this.config.getBgcolor());
        this.getContentPane().add((Component)this.kafenioPanel, "Center");
        this.validate();
        this.splash.destroy();
    }

    private synchronized KafenioPanelConfiguration readConfig() {
        KafenioPanelConfiguration kafenioPanelConfiguration = new KafenioPanelConfiguration();
        kafenioPanelConfiguration.setKafenioParent(this);
        kafenioPanelConfiguration.setMode(1);
        kafenioPanelConfiguration.setCodeBase(Utils.checkNullOrEmpty(this.getParameter("BASEURL"), this.getCodeBase().toString()));
        kafenioPanelConfiguration.setBgcolor(Utils.checkNullOrEmpty(this.getParameter("BGCOLOR")));
        kafenioPanelConfiguration.setRawDocument(Utils.checkNullOrEmpty(this.getParameter("DOCUMENT")));
        kafenioPanelConfiguration.setShowViewSource(this.checkBoolean(this.getParameter("SOURCEVIEW")));
        kafenioPanelConfiguration.setBase64(this.checkBoolean(this.getParameter("BASE64")));
        if (Utils.checkNullOrEmpty(this.getParameter("STYLESHEET")) != null) {
            kafenioPanelConfiguration.setStyleSheetFileList(KafenioPanel.tokenize(this.getParameter("STYLESHEET")));
        }
        kafenioPanelConfiguration.setShowToolbar(this.checkBoolean(this.getParameter("TOOLBAR")));
        kafenioPanelConfiguration.setShowToolbar2(this.checkBoolean(this.getParameter("TOOLBAR2")));
        kafenioPanelConfiguration.setShowMenuBar(this.checkBoolean(this.getParameter("MENUBAR")));
        kafenioPanelConfiguration.setLanguage(Utils.checkNullOrEmpty(this.getParameter("LANGCODE")));
        kafenioPanelConfiguration.setCountry(Utils.checkNullOrEmpty(this.getParameter("LANGCOUNTRY")));
        kafenioPanelConfiguration.setShowMenuIcons(this.checkBoolean(this.getParameter("MENUICONS")));
        kafenioPanelConfiguration.setImageDir(Utils.checkNullOrEmpty(this.getParameter("IMAGEDIR"), ""));
        if (Utils.checkNullOrEmpty(this.getParameter("FILEDIR")) != null) {
            kafenioPanelConfiguration.setFileDir(Utils.checkNullOrEmpty(this.getParameter("FILEDIR"), ""));
        } else {
            kafenioPanelConfiguration.setFileDir(Utils.checkNullOrEmpty(this.getParameter("IMAGEDIR"), ""));
        }
        kafenioPanelConfiguration.setTreePilotSystemID(Utils.checkNullOrEmpty(this.getParameter("SYSTEMID"), ""));
        kafenioPanelConfiguration.setServletUrl(Utils.checkNullOrEmpty(this.getParameter("SERVLETURL"), ""));
        kafenioPanelConfiguration.setServletMode(Utils.checkNullOrEmpty(this.getParameter("SERVLETMODE"), ""));
        kafenioPanelConfiguration.setPostUrl(Utils.checkNullOrEmpty(this.getParameter("POSTCONTENTURL"), ""));
        kafenioPanelConfiguration.setContentParameter(Utils.checkNullOrEmpty(this.getParameter("CONTENTPARAMETER"), ""));
        kafenioPanelConfiguration.setOutputmode(Utils.checkNullOrEmpty(this.getParameter("OUTPUTMODE"), ""));
        kafenioPanelConfiguration.setDebugMode(this.checkBoolean(this.getParameter("DEBUG")));
        String string = Utils.checkNullOrEmpty(this.getParameter("BUTTONS"));
        String string2 = Utils.checkNullOrEmpty(this.getParameter("BUTTONS2"));
        String string3 = Utils.checkNullOrEmpty(this.getParameter("MENUITEMS"));
        kafenioPanelConfiguration.setCustomToolBar1(string);
        kafenioPanelConfiguration.setCustomToolBar2(string2);
        kafenioPanelConfiguration.setCustomMenuItems(string3);
        return kafenioPanelConfiguration;
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.appletRegister.unregisterApplet(this);
        this.kafenioToolBar1 = null;
        this.kafenioToolBar2 = null;
        this.toolbarPanel = null;
        this.kafenioPanel = null;
        this.appletRegister = null;
        this.jlblStatus = null;
        this.vcTools = null;
        this.config = null;
        this.externalEditorFrame = null;
        System.gc();
    }

    public boolean checkBoolean(String string) {
        return "true".equalsIgnoreCase(string);
    }

    public String getDocumentText() {
        return this.kafenioPanel.getDocumentText();
    }

    public String getDocumentBody() {
        return this.kafenioPanel.getDocumentBody();
    }

    public void setDocumentText(String string) {
        this.kafenioPanel.setDocumentText(string);
    }

    public String getContents() {
        return this.getDocumentBody();
    }

    public boolean saveAppletContents() {
        return this.kafenioPanel.postContentBody();
    }

    public void saveAllAppletsContent() {
        this.appletRegister.saveAllAppletContents();
    }

    public void detachFrame() {
        if (this.externalEditorFrame == null) {
            this.setVisible(false);
            this.externalEditorFrame = new ExternalEditorFrame("Kafenio", this);
            this.externalEditorFrame.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.externalEditorFrame.setContentPane(this.getRootPane());
            this.externalEditorFrame.setVisible(true);
        } else {
            this.setRootPane(this.externalEditorFrame.getRootPane());
            this.externalEditorFrame.setVisible(true);
            this.externalEditorFrame.dispose();
            this.externalEditorFrame = null;
            this.validate();
            this.setVisible(true);
        }
    }

    private void showSplash() {
        this.splash = new SplashScreen(30);
        log.info("Info: Displaying splash image for max. 30 seconds.");
        new Thread(this.splash).start();
    }
}

