%define name directory_administrator
%define version 1.5.1
%define release 1
%define prefix /usr
%define ruddo Manuel Amador (Rudd-O) <amadorm@usm.edu.ec>

Name:		%name
Summary:	User/group/access control management tool for LDAP directories
Summary(pt_BR): Administrador de usu=E1rios/controle de acesso/grupos para LDAP
Summary(es):    Administrador de usuarios/grupos y control de acceso para directorios LDAP
Version:	 %version
Release:	%release
Copyright:	GPL
Group:		System/Configuration/Other
Group(es):	Sistema/Configuracin/Otro
URL:		http://diradmin.open-it.org/
Vendor:	%{ruddo}
Packager:	%{ruddo}
Source:		directory_administrator-%{version}.tar.gz
BuildRequires:	gnome-libs-devel openldap-devel
BuildRoot:	%{_tmppath}/%{name}-root

%description
Directory administrator is a smart LDAP directory management tool. It can be used to manage
UNIX and SAMBA network user accounts and groups in a single sign-on setup, corporate address
book information, host-based access control and advanced mail routing. It's extremely easy to
install and use, yet powerful at the same time. Along with popular software, it's the
preferred solution for single sign-on maintenance.

%description -l es
Directory administrator es una herramienta inteligente para administrar directorios LDAP
Permite administrar usuarios y grupos UNIX y SAMBA en un entorno single sign-on, controles
de acceso por equipo, informacion organizacional y rutas de correo electronico para aquellos
servidores de correo que lo soporten.  Es muy sencilla de instalar y usar, y al mismo
tiempo muy poderosa.

%prep
%setup

%build
./configure --prefix=%{prefix}
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%attr(0755,root,root) %{prefix}/bin/directory_administrator
%attr(0644,root,root) %{prefix}/share/applications/*
%attr(0644,root,root) %{prefix}/share/pixmaps/directory_administrator/*
%doc AUTHORS NEWS COPYING ChangeLog TODO README doc

%changelog
* Fri Dec 20 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.3-1
- Bugfixes
- From now on, this changelog shows only RPM spec changes

* Tue Nov 19 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.2.1-1
- Fixed compile issues in older platforms
- Fixed member list issues in group properties dialog (thanks to
  Christof Meerwald)
- Cosmetic fixes

* Mon Nov 18 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.2-1
- Keyboard navigation on the icon list, perfect for large directories
- Type ahead find to quickly locate an icon by typing its display
  name or part of it
- Enabled multiple icon selection for dragging and dropping several
  icons onto group lists, deleting several entries from the directory
  and (in the future) moving entries between organizational units

* Fri Nov 15 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.15-1
- Fixed bug which wouldn't let you grant access to particular servers
  or none at all when creating a user
- Unicode support for all attributes: accented characters are supported
  for all attributes which accept them

* Wed Nov 13 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.14-1
- Fixed bug that wouldn't let you modify entries without
  person/inetOrgPerson objectclass

* Tue Nov 12 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.13-1
- (Christof Meerwald) fixed bug whenever updating a SAMBA account would
  remove its password if it wasn't changed

* Fri Nov 08 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.12-1
- Made more robust against corrupted directory entries

* Thu Nov 07 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.11-1
- Fixed horrible compiled error that insulted you
- Improved SAMBA support (Christof Meerwald)
- Removed Mandrake menu support

* Wed Nov 06 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.10-1
- Fixed adding users as secondary members of groups
- Corrected handling of host "*", host-based access-control according to RFC
- Laid down initial infrastructure to support multiple views and directory tree
- Performance fixes: now entries are cached on a list in memory to be used in drop-down lists and the like

* Thu Jun 20 2002 Manuel Amador (Rudd-O) <amadorm@usm.edu.ec> 1.1.9-1mdk
- (you're welcome, Lenny! ;-)     )
- Fixed horrible bug that triggered on removal of any attribute
- Incorporated patch from Vincent Danen to fix md5 passwords

* Mon Jun 17 2002 Vincent Danen <vdanen@mandrakesoft.com> 1.1.8-2rph
- patch to fix how unix md5 passwords are stored

* Thu Jun 13 2002 Vincent Danen <vdanen@mandrakesoft.com> 1.1.8-1rph
- rebuild for rpmhelp.net (ML/8.2)

* Mon Apr 08 2002 Lenny Cartier <lenny@mandrakesoft.com> 1.1.8-1mdk
- 1.1.8

* Wed Mar 27 2002 Lenny Cartier <lenny@mandrakesoft.com> 1.1.7-1mdk
- updated to 1.1.7 ( thx Manuel Amador )

* Thu Dec 06 2001 Lenny Cartier <lenny@mandrakesoft.com> 1.1.3-1mdk
- 1.1.3

vv
