/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com 
*/


#include <gnome.h>
#include "profile.h"
#include "users.h"
#include "groups.h"
#include "interface.h"
#include "dir_entry.h"

GtkWidget *create_messagebox_with_message (char *messagetext);

void fill_users_dropdown (GtkWidget * dropdown);
void fill_groups_dropdown (GtkWidget * dropdown);

gchar *get_lowest_uid (connection_profile * usethisone);
gchar *get_lowest_gid (connection_profile * usethisone);

/*GList *get_user_ou_list (connection_profile * usethisone);
GList *get_group_ou_list (connection_profile * usethisone);
*/
/*GList *get_user_list (connection_profile * usethisone);
GList *get_group_list (connection_profile * usethisone);
*/
GList *get_user_dn_list_from_cache ();
GList *get_user_uid_list_from_cache ();
GList *get_group_cn_list_from_cache ();
GList *get_orgunit_dn_list_from_cache ();

void open_website(void);

void app_interactive_connect(void);
void app_interactive_disconnect(void);
int app_is_connected(void);
int app_connect(char *profilename);
void app_refresh(void);

int app_delete_interactive(GList* dns);
void app_delete_dir_entry(char*dn);
void app_add_dir_entry(dir_entry *d);
void cached_dir_entries_remove_bydn(char*dn);
void cached_dir_entries_add(dir_entry*d);
void cached_dir_entries_refetch(connection_profile* c);
dir_entry* cached_dir_entries_getbydn(char* dn);
dir_entry* cached_dir_entries_getbyuid(char* uid);
dir_entry* cached_dir_entries_getbygidnumber(int gid);


void app_enable_editing_controls (void );
void app_disable_editing_controls (void );


GList *get_user_uid_list_from_cache(void);
GList*get_user_dn_list_from_cache(void);
GList*get_group_cn_list_from_cache(void);
GList*get_orgunit_dn_list_from_cache(void);

void app_set_progress(gfloat progress);

dir_entry* cached_dir_entries_getgroupbygidnumber(int gid);
dir_entry* cached_dir_entries_getgroupbycn(gchar*cn);

gboolean cached_dir_entries_has_groups(void);
gboolean cached_dir_entries_has_ous(void);



void app_enable_filtercontrols (void);
void app_disable_filtercontrols (void);

void app_filter_fill (void );
