/* Copyright (C) 2000,2001,2002 Manuel Amador (Rudd-O)
   This file is part of Directory administrator.

   Directory administrator is free software; you can redistribute it 
   and/or modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   Directory administrator is distributed in the hope that it will be 
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with Directory administrator; if not, send e-mail to amador@alomega.com 
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "appsupport.h"
#include "appglobals.h"
#include "profile.h"
#include "appfunctions.h"
#include "prefsdialog.h"

void
list_profiles_fill (GtkWidget * widget)
{

  GList *loopix = g_list_first (connection_profile_list);
  gchar *fila[1];

  g_assert (widget);
  gtk_clist_clear ((GtkCList *) widget);

  while (loopix)
    {
      fila[0] =
	connection_profile_get_name ((connection_profile *) loopix->data);
      gtk_clist_append ((GtkCList *) widget, fila);

      loopix = g_list_next (loopix);
    }

  app_reference = widget;
}


gboolean
on_button4_clicked_handler (GtkButton * button, GtkWidget * list_reference)
{
  connection_profile *newone;
  gchar *nombrecitocojudo;


  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a profile name"));
      return (FALSE);
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server address"));
      return (FALSE);
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (connection_profile_list_getbyname
      (connection_profile_list, nombrecitocojudo) != NULL)
    {
//    g_print("\nItem was found on the list.  Not admissible.");
      gtk_widget_show (create_messagebox_with_message
		       ("An entry with this name already exists"));
      return (FALSE);
    }


  newone =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
                            gtk_toggle_button_get_active ((GtkToggleButton *)
                                                lookup_widget ((GtkWidget *)
                                                               button,
                                                               "entry_login_tls")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));
  connection_profile_list =
    connection_profile_list_add (connection_profile_list, newone);
  if (list_reference)
    list_profiles_fill (list_reference);
  return (TRUE);

}

void
on_login_modify_finish (GtkButton * button, GtkCList * list_reference)
{
  connection_profile *newone = NULL;
  connection_profile *oldone = NULL;
  gchar *nombrecitocojudo = NULL;


  //gets the text from the list reference, first row selected, column 0, and puts it into nombrecitocojudo
  gtk_clist_get_text (list_reference,
		      GPOINTER_TO_INT (list_reference->selection->data), 0,
		      &nombrecitocojudo);

  oldone =
    connection_profile_list_getbyname (connection_profile_list,
				       nombrecitocojudo);
  g_assert (oldone);

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a profile name"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_login_server"));
  if (strlen (nombrecitocojudo) == 0)
    {
      gtk_widget_show (create_messagebox_with_message
		       ("You need to supply a server address"));
      return;
    }

  nombrecitocojudo =
    gtk_entry_get_text ((GtkEntry *)
			lookup_widget ((GtkWidget *) button,
				       "entry_profile_name"));

  newone =
    connection_profile_new (gtk_entry_get_text
			    ((GtkEntry *)
			     lookup_widget ((GtkWidget *) button,
					    "entry_profile_name")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_dn")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_pw")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_server")),
                            gtk_toggle_button_get_active ((GtkToggleButton *)
                                                lookup_widget ((GtkWidget *)
                                                               button,
                                                               "entry_login_tls")),
			    gtk_entry_get_text ((GtkEntry *)
						lookup_widget ((GtkWidget *)
							       button,
							       "entry_login_treeroot")));

  connection_profile_list =
    connection_profile_list_remove (connection_profile_list, oldone);
  connection_profile_list =
    connection_profile_list_add (connection_profile_list, newone);
  g_assert (list_reference);
  list_profiles_fill (GTK_WIDGET (list_reference));
  gtk_widget_destroy (lookup_widget (GTK_WIDGET (button), "login"));

}



void
fill_loginshells_list (GtkWidget * widget)
{


  GList *loopix = g_list_first (preferences.logindefaults.shells);
  gchar *fila[1];

  g_print ("\ncalled: fill_loginshells_list\n");

  g_assert (widget);
  gtk_clist_clear ((GtkCList *) widget);

  while (loopix)
    {
      fila[0] = loopix->data;
      gtk_clist_append ((GtkCList *) widget, fila);
      loopix = g_list_next (loopix);
    }

}


void
fill_login (GtkWidget * about, char *profilename)
{

  connection_profile *conprof = NULL;

  conprof =
    connection_profile_list_getbyname (connection_profile_list, profilename);
  if (conprof == NULL)
    {
      g_print
	("***ERROR! no such profile! could not get data about selected profile");
      return;
    }

  g_print
    ("\n\nNow a dialog box with the profile information should pop up\n");

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_profile_name")),
		      connection_profile_get_name (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_dn")),
		      connection_profile_get_dn (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_pw")),
		      connection_profile_get_password (conprof));

  gtk_entry_set_text (GTK_ENTRY (lookup_widget (about, "entry_login_server")),
		      connection_profile_get_server (conprof));

#ifdef HAVE_TLS
  if (conprof->tls)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (about, "entry_login_tls")),
		      TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget (about, "entry_login_tls")),
		      FALSE);
#else
  gtk_widget_set_sensitive( (lookup_widget (about, "entry_login_tls")), FALSE );
#endif

  gtk_entry_set_text (GTK_ENTRY
		      (lookup_widget (about, "entry_login_treeroot")),
		      connection_profile_get_treeroot (conprof));

}

void fill_prefsdialog (GtkWidget* widget) {

	if (preferences.avoidconflicts) {
		gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget(widget,"avoidconflicts"),TRUE);
	} else {
		gtk_toggle_button_set_active((GtkToggleButton*) lookup_widget(widget,"avoidconflicts"),FALSE);
	}

	if (preferences.avoidconflictscope == ORGUNIT) {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget(widget,"sameorgunit")), TRUE);
	} else {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget(widget,"entiredirectory")), TRUE);
	}

}

