#!/usr/bin/perl -w

use strict;

my $config_load_warning_level = 2.0;
my $picture = "online.png";

print "Content-Type: image/png\n\n";

my $test_disc_cover = `./disc-cover -v | grep "^Disc-Cover"`;

if (! -f "disc-cover" or $test_disc_cover eq "")
{
	$picture = "offline.png";
}

my $load = 0.0;

my $OS = `uname`;
chomp $OS;

if ($OS eq "SunOS")
{
	my $fake;
	($fake,$fake,$load) = split ' ', `top 0 | head -1`;
	$load =~ s/,//g;
}
elsif ($OS eq "Linux")
{
	open(LOAD, "/proc/loadavg");
	($load) = split(' ',<LOAD>);
	close (LOAD);
}
else
{
	print STDERR "Error (online.cgi): unknown OS, do not know how to request CPU load\n";
}

if ($load > $config_load_warning_level)
{
        $picture = "busy.png";
}


open PICTURE, "$picture" or die "$!";

binmode PICTURE;

binmode STDOUT;
print <PICTURE>;
