#
# DITrack module: command line parsing
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: cmdline.py 1132 2007-01-21 13:18:37Z oleg $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/Util/cmdline.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import sys

class DuplicateOptionError(Exception):
    "Duplicate option supplied"
    def __init__(self, option):
        self.option = option

class InvalidValueTypeError(Exception):
    "Option parameter type is invalid"
    def __init__(self, option):
        self.option = option

class MissingParameterError(Exception):
    "Option requires a parameter, but none specified"
    def __init__(self, option):
        self.option = option

class OptSpecError(Exception):
    "Error in options specification passed to ParseResults()"
    def __init__(self, option):
        self.option = option

class UnknownOptionError(Exception):
    "Unknown option supplied"
    def __init__(self, option):
        self.option = option

class Option:
    def __init__(self, name, descr, type, arg, aliases):
        self.name = name
        self.descr = descr
        self.type = type
        self.arg = arg
        self.aliases = aliases

    def print_description(self):
        s = "  " + self.aliases[0]
        if len(self.aliases) > 1:
            assert len(self.aliases) == 2
            s = s + " [" + self.aliases[1] + "]"

        if len(self.arg):
            s = s + " " + self.arg

        print "%-28s: %s" % (s, self.descr)

class ParseResults:
    def __init__(self, options):
        "Parse arguments array according to options specification options"
        self.fixed = []
        self.var = { }
        self.var_alias = { }
        self.warnings = []

        optmap = { }
        for o in options:
            for a in o.aliases:
                    optmap[a] = o

        assign_next = assign_next_type = ""

        for v in sys.argv[1:]:
            if len(assign_next):
                if v[0] == '-':
                    self.warnings.append("'%s' is treated as the argument " + \
                            "for '%s'" % (v[0], assign_next))

                if assign_next_type == "int":
                    try:
                        v = int(v)
                    except ValueError:
                        raise InvalidValueTypeError(v)

                self.var[optmap[assign_next].name] = v

                self.var_alias[optmap[assign_next].name] = v_a


                assign_next = ""
                continue
                    
            if optmap.has_key(v):
                    o = optmap[v]

                    if self.var.has_key(o.name):
                        raise DuplicateOptionError(v)

                    if o.type == "boolean":
                        self.var[o.name] = 1
                        self.var_alias[o.name] = v
                    elif (o.type == "string") or (o.type == "int"):
                        assign_next = v
                        assign_next_type = o.type
                        v_a = v
                    else:
                        raise OptSpecError(optname)
            else:
                if v[0] == '-':
                    raise UnknownOptionError(v)
                else:
                    self.fixed.append(v)

        if len(assign_next):
            raise MissingParameterError(assign_next)

        for o in options:
            if (o.type == "boolean") and (not self.var.has_key(o.name)):
                self.var[o.name] = 0
