#
# dt - DITrack command-line client globals
#
# Copyright (c) 2006-2007 The DITrack Project, www.ditrack.org.
#
# $Id: globals.py 1398 2007-03-06 00:38:06Z vss $
# $HeadURL: https://127.0.0.1/ditrack/src/tags/0.5/DITrack/dt/globals.py $
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
#  * Redistributions of source code must retain the above copyright notice, 
# this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright notice, 
# this list of conditions and the following disclaimer in the documentation 
# and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
# POSSIBILITY OF SUCH DAMAGE.
#

import datetime
import os.path
import stat
import sys
import time

import DITrack.Util.common

class Globals:
    def __init__(self):

	# Our version.
	self.version = "0.5"
	self.dt_title = "DITrack command-line client, version %s" % \
	    self.version

	# Figure out the binary name.
	self.binname = os.path.basename(sys.argv[0])

	# Username.
	self.username = os.environ["USER"]

	# Timezone string.
	if time.daylight:
	    tz = time.altzone
	else:
	    tz = time.timezone

	if tz > 0:
	    offs = "-"
	elif tz == 0:
	    offs = " "
	else:
	    offs = "+"
	    tz = -tz

	self.timezone_string = offs + \
	    ("%02d%02d" % (tz / 3600, (tz / 60) % 60))

	# Path to svn executable.
	self.svn_path = "svn"

	# Editor is not necessarily required for any command.
	self.editor = ""

	self.text_delimiter = "=" * 78

    def fmt_timestamp(self):
	"""
	Returns the current time string formatted.
	"""

	weekdays = ("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun")

	now = datetime.datetime.now()

	return now.strftime("%s %F %T ") + weekdays[now.weekday()] +    \
	    " " + self.timezone_string

    def get_editor(self):
	"Figure out user editor; bail out if something goes wrong."

	if len(self.editor):
	    return

	notdefined = "Text editor is not defined (use EDITOR "  \
	    "environment variable)"

	if not os.environ.has_key("EDITOR"):
	    DITrack.Util.common.err(notdefined)

	self.editor = os.environ["EDITOR"]

	msg = "Text editor '" + self.editor + "' (set with "    \
	    "EDITOR environment variable) "

	if len(self.editor) == 0:
	    DITrack.Util.common.err(notdefined)

	if self.editor[0] == "/":

	    if not os.path.exists(self.editor):
		DITrack.Util.common.err(msg + "doesn't exist")

	    if not os.path.isfile(self.editor):
		DITrack.Util.common.err(msg + "is not a file")

	    st = os.stat(self.editor)
	    if not (st[stat.ST_MODE] & stat.S_IEXEC):
		DITrack.Util.common.err(msg + "is not executable")

    def get_username(self, opts, db):
	"""
	Figure out the user name, using the environment and passed options
	OPTS. Ensures that the user name is valid for the DB database.
	"""

	name = None

	if "user" in opts.var:
	    name = opts.var["user"]
	elif "DITRACK_USER" in os.environ:
	    name = os.environ["DITRACK_USER"]
	elif "USER" in os.environ:
	    name = os.environ["USER"]
	else:
	    DITrack.Util.common.err("Can't figure out user name to use: "
		"neither a command line option, nor environment variables "
		"(DITRACK_USER, USER) are specified.")

	assert name

        if name not in db.cfg.users:
            # XXX: specify how we've figured out the user name
            # XXX: specify the database path
            DITrack.Util.common.err("Invalid user name: '%s'" % name)

	self.username = name
