#include "jog.h"
#include <stdio.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qregion.h>
#include <math.h>

#include "jog.xpm"
#include "thumb.xpm"

QJogDial::QJogDial(QWidget *parent, char *name) : QDial(parent, name)
{
	pix=new QPixmap((const char **)jog_xpm);
	thumb=new QPixmap((const char **)thumb_xpm);
	connect(this, SIGNAL(valueChanged(int)), this, SLOT(adjustValue(int)));

	setMinValue(0);
	setMaxValue(40);
	setValue(50);
	last_painted=-1;
}

QJogDial::QJogDial()
{
	pix=new QPixmap((const char **)jog_xpm);
	thumb=new QPixmap((const char **)thumb_xpm);
	connect(this, SIGNAL(valueChanged(int)), this, SLOT(adjustValue(int)));
}

QJogDial::~QJogDial()
{
	delete pix;
	delete thumb;
}

void QJogDial::paintEvent(QPaintEvent *ev)
{
	QRegion r=QRegion(0, 0, width()-1, height()-1, QRegion::Ellipse);
	setMask(r);
	QPixmap pm=*pix;
	QPainter p;
	p.begin(&pm, this);

	last_painted=value();

	draw(p);

	bitBlt(this, 0, 0, &pm);
}

void QJogDial::draw(QPainter &p)
{
	int pos=value();
	if(pos == 40)
		pos=0;
	double ang=2*3.141526*(double)pos/40.0+3.141526/2;

	int x=(int)(14*cos(ang));
	int y=(int)(14*sin(ang));
	x+=rect().width()/2-thumb->width()/2;
	y+=rect().height()/2-thumb->height()/2;

	p.drawPixmap(x, y, *thumb);
}

void QJogDial::repaintScreen(const QRect *cr)
{
//	if(value() == last_painted)
//		return;
	last_painted=value();
	QPixmap pm=*pix;
	QPainter p;
	p.begin(&pm, this);

	draw(p);

	bitBlt(this, 0, 0, &pm);
}

void QJogDial::adjustValue(int val)
{
	int up=val>prevValue();

	if(val-prevValue() > 30 || val-prevValue() < -30)
		up=!up;

	if(val == 0 && prevValue() == 40)
		return;
	if(val == 40 && prevValue() == 0)
		return;
	if(val == 40 && prevValue() != 0)
		setValue(0);
	else if(val == 0 && prevValue() != 40)
		setValue(40);
	if(val == prevValue())
		return;
	if(up)
		emit jogUp();
	else
		emit jogDown();
}
