#include "loader.h"
#include "jack.h"
#include "config.h"
#ifdef HAVE_LIBMAD
#include "mp3.h"
#endif
#ifdef HAVE_LIBAUDIOFILE
#include "audiofile.h"
#endif
#ifdef HAVE_LIBMPEG3
#include "mpeg.h"
#endif
#ifdef HAVE_LIBVORBIS
#include "ogg.h"
#endif
#ifdef HAVE_LIBCDDA_PARANOIA
#include "cdda.h"
#endif
#include <pthread.h>
#include "config.h"

QLoaderEvent::QLoaderEvent(StreamSource *s, QString f, Type t) : QEvent((QEvent::Type)t)
{
	Source=s;
	File=f;
	Error=0;
}

QLoaderEvent::~QLoaderEvent()
{
}

QString QLoaderEvent::file()
{
	return File;
}

StreamSource *QLoaderEvent::source()
{
	return Source;
}

bool QLoaderEvent::error()
{
	return Error;
}

void QLoaderEvent::setError()
{
	Error=true;
}

Loader::Loader(QString f, QWidget *d)
{
	Source=0;
	File=f;
	Dest=d;
}

Loader::~Loader()
{
}

void Loader::run()
{
    StreamSource *new_source=0;

	pthread_detach(pthread_self());

	if(File.left(7) == "cdda://")
	{
#ifdef HAVE_LIBCDDA_PARANOIA
		new_source=new CDDAStreamSource(Dest);
#else
		QLoaderEvent *e=new QLoaderEvent(0, File);
		e->setError();
		e->setLoader(this);
		postEvent(Dest, e);
		return;
#endif
	}

	if(!new_source)
	{
		char *ext=strrchr(File, '.');
		if(!ext)
			ext="";
   
		if(ext)
		{
#ifdef HAVE_LIBMAD
			if(!strcasecmp(ext, ".mp3") ||
			   !strcasecmp(ext, ".mp2") ||
			   !strcasecmp(ext, ".mus"))
			{
				new_source=new Mp3StreamSource(Dest);
			}
#endif
#ifdef HAVE_LIBMPEG3
			if(!strcasecmp(ext, ".mpg") || !strcasecmp(ext, ".mpeg"))
			{
				new_source=new MpegStreamSource(Dest);
			}
#endif
#ifdef HAVE_LIBVORBIS
			if(!strcasecmp(ext, ".ogg"))
			{
				new_source=new OggStreamSource(Dest);
			}
#endif
		}
	}

#ifdef HAVE_LIBAUDIOFILE
    if(!new_source)
		new_source=new AudiofileStreamSource(Dest);
#endif

	if(!new_source)
	{	
		QLoaderEvent *e=new QLoaderEvent(0, File);
		e->setError();
		e->setLoader(this);
		postEvent(Dest, e);
		return;
	}

	Source=new_source;
	QLoaderEvent *e=new QLoaderEvent(Source, File);
	e->setLoader(this);


	if(Source->attach(File) < 0)
	{
		delete Source;
		e->setError();
		postEvent(Dest, e);
		return;
	}
	else
	{
		Source->generate_wave();
	}

	postEvent(Dest, e);
}

void QLoaderEvent::setLoader(Loader *l)
{
	e_loader=l;
}

Loader *QLoaderEvent::loader()
{
	return e_loader;
}

