#include "pump.h"
#include "jack.h"
#include "mainwnd.h"
#include "meterset.h"
#include <math.h>
#include <qapplication.h>
#include <pthread.h>
#include <unistd.h>

#define BLKSIZE 1024

Pump::Pump()
{
	s_stop=false;
}

Pump::~Pump()
{
	clear_sync.lock();
	s_stop=true;
	clear_sync.unlock();
	pump_wait.wakeOne();
	while(!finished())
		usleep(10000);
}

void Pump::run()
{
    struct sched_param p;
    p.sched_priority=50;

    if(seteuid(0) < 0)
    {
        printf("Audio player cannot su to root\n");
    }
    else
    {
        if(pthread_setschedparam(pthread_self(), SCHED_FIFO, &p) < 0)
        {
            printf("Cannot set audio player schduling policy to realtime\n");
        }
    }
    seteuid(getuid());

	QValueList<StreamSource *>::Iterator it;
	for(;;)
	{
		clear_sync.lock();
		for(it=Streams.begin();it != Streams.end();it++)
		{
			Source=(*it);
			if(Source->player && Source->playing)
			{
				while(Source->player->buffer->write_space() >= BLKSIZE*2*sizeof(float))
				{
					int samps=Source->get_buffer(buffer, BLKSIZE);
					if(!samps)
						break;

					int i;
					for(i=0;i<samps;++i)
					{
						interleaved[i*2]=((float)*(short *)(&buffer[i*sizeof(short)]))/32767.0;
						if(interleaved[i*2] > 1.0)
							interleaved[i*2]=1.0;
						interleaved[i*2+1]=((float)*(short *)(&buffer[(samps+i)*sizeof(short)]))/32767.0;
						if(interleaved[i*2+1] > 1.0)
							interleaved[i*2+1]=1.0;
					}
					if(Source)
					{
						Source->player->buffer->write((char *)interleaved, sizeof(float)*samps*2);

						int bytes=Source->player->buffer->peek((char *)interleaved, sizeof(float)*samps*2);
						samps=bytes/(sizeof(float)*2);

						int max_l=0, max_r=0, avg_l, avg_r, val;
						double sum_l=0, sum_r=0;

						for(i=0;i<samps;++i)
						{
							val=(int)(interleaved[i*2]*32767.0);
							if(val < 0)
								val=-val;
							sum_l+=sqrt(val);
							if(val > max_l)
								max_l=val;
							val=(int)(interleaved[i*2+1]*32767.0);
							if(val < 0)
								val=-val;
							sum_r+=sqrt(val);
							if(val > max_r)
								max_r=val;
						}
						avg_l=(int)pow(sum_l/1024.0, 2.0);
						avg_r=(int)pow(sum_r/1024.0, 2.0);

						QValueList<MeterSet *>::Iterator it;
						for(it=meters.begin();it!=meters.end();++it)
						{
							if(Source && (*it)->player() == Source->player)
								(*it)->setMeterValues((double)avg_l/32767.0, (double)avg_r/32767.0, (double)max_l/32767.0, (double)max_r/32768.0);
						}
					}
					else
						break;
				}
			}
			else
			{
				QValueList<MeterSet *>::Iterator it;
				for(it=meters.begin();Source && it!=meters.end();++it)
					if(Source && (*it)->player() == Source->player)
						(*it)->setMeterValues(0.0, 0.0, 0.0, 0.0);
			}
		}
		for(it=Streams.begin();it != Streams.end();it++)
		{
			Source=(*it);
			Source->prefetch();
		}

		clear_sync.unlock();
		QValueList<MeterSet *>::Iterator im;
		for(im=meters.begin();im!=meters.end();++im)
			(*im)->updateMeters();
		pump_wait.wait();
		if(s_stop)
			return;
	}
}

void Pump::removeStream(StreamSource *s)
{
	clear_sync.lock();
	Source=0;
	QValueList<StreamSource *>::Iterator it;
	it=Streams.find(s);
	if(it != Streams.end())
		Streams.remove(it);
	clear_sync.unlock();
}

void Pump::work()
{
	pump_wait.wakeOne();
}

void Pump::addStream(StreamSource *s)
{
	Streams.append(s);
}

void Pump::addMeters(MeterSet *m)
{
	if(meters.find(m) == meters.end())
		meters.append(m);
}

void Pump::removeMeters(MeterSet *m)
{
	QValueList<MeterSet *>::Iterator it=meters.find(m);
	if(it == meters.end())
		return;
	meters.remove(it);
}
