/* vim: sta et sw=4
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include <libxml/globals.h>
#ifdef LIBXML_CATALOG_ENABLED
#include <libxml/catalog.h>
#endif

void load_default_catalogs(void);

/*
 * Look for catalogs from one of the following, in the indicated
 * order of preference:
 *
 * 1. XML_CATALOG_FILES
 * 2. /etc/xml/catalog
 * 3. SGML_CATALOG_FILES
 * 4. /etc/sgml/catalog
 * 5. A whole bunch of old SGML catalog locations from Debian
 */

void
load_default_catalogs(void)
{
#ifdef LIBXML_CATALOG_ENABLED
    const char *xmlcat = getenv("XML_CATALOG_FILES");
    
    if(xmlcat) {
        xmlLoadCatalogs(xmlcat);
    } else if(xmlLoadCatalog("/etc/xml/catalog") == 0) {
        /* loaded it no problem */
    } else {
        const char *sgmlcat = getenv("SGML_CATALOG_FILES");
        if(sgmlcat) {
            xmlLoadCatalogs(sgmlcat);
            xmlCatalogConvert();    /* Internally convert SGML catalogs to XML ones */
        } else {
            xmlLoadCatalogs("/etc/sgml/catalog:/usr/local/share/sgml/catalog:/usr/local/lib/sgml/catalog:/usr/lib/sgml/catalog");
            xmlCatalogConvert();
        }
    }
#endif
}
