#include <stdlib.h>

typedef unsigned int hashkey_t;
typedef char * hashvalue_t;

struct hashentry {
	struct hashentry *next;
	hashkey_t key;
	hashvalue_t value;
};

struct hashtable {
	struct hashentry **table;
	int size;
	int num_elements;
};

#define HASH_SIZE 512

struct hashtable *hash_new(int size);
void hash_delete(struct hashtable *hashtable);
int hash_put(struct hashtable *hashtable, hashkey_t key, hashvalue_t value);
int hash_get(struct hashtable *hashtable, hashkey_t key, hashvalue_t *valueptr);
int hash_remove(struct hashtable *hashtable, hashkey_t key);

int hash_keyequal(hashkey_t k1, hashkey_t k2);
int hash_hashkey(struct hashtable *hashtable, hashkey_t key);
void hash_destructor(hashkey_t key, hashvalue_t value);

