<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns:l="http://docbook2x.sourceforge.net/xsl/localization"
                xmlns:exslt="http://exslt.org/common"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: messages.xsl,v 1.8 2003/05/24 13:52:38 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X.  Facilitates L10Nized user messages.
                         
     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:param name="message-language" select="'en'" />

<!-- ==================================================================== -->

<xsl:template name="l10n-message-choose-language">
  <xsl:param name="key" />
  <xsl:param name="languages" select="$message-language" />
  <xsl:variable name="first" select="
    translate(substring-before($languages, ':'),
              'ABCDEFGHIJKLMNOPQRSTUVWXYZ_',
              'abcdefghijklmnopqrstuvwxyz-')" />

  <xsl:choose>
    <xsl:when test="$first = ''">
      <xsl:value-of select="$languages" />
    </xsl:when>
  
    <xsl:when test="$l10n-data/l:locale[@lang=$first]/l:message[@key=$key]">
      <xsl:value-of select="$first" />
    </xsl:when>

    <xsl:otherwise>
      <xsl:call-template name="l10n-message-choose-language">
        <xsl:with-param name="key" select="$key" />
        <xsl:with-param name="languages" 
                        select="substring-after($languages, ':')" />
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="l:a1" mode="l10n-substitution">
  <xsl:param name="arg-1" />
  <xsl:value-of select="$arg-1" />
</xsl:template>
<xsl:template match="l:a2" mode="l10n-substitution">
  <xsl:param name="arg-2" />
  <xsl:value-of select="$arg-1" />
</xsl:template>
<xsl:template match="l:a3" mode="l10n-substitution">
  <xsl:param name="arg-3" />
  <xsl:value-of select="$arg-1" />
</xsl:template>
<xsl:template match="l:a4" mode="l10n-substitution">
  <xsl:param name="arg-5" />
  <xsl:value-of select="$arg-1" />
</xsl:template>
<xsl:template match="l:a5" mode="l10n-substitution">
  <xsl:param name="arg-5" />
  <xsl:value-of select="$arg-1" />
</xsl:template>

<!-- ==================================================================== -->

<doc:template name="user-message" xmlns="">
  <refpurpose>Emit a user message</refpurpose>
  <refdescription>
    <para>
      This template is used in place of <function>xsl:message</function>.
       It traces the path of the given node to help in debugging and allows
       messages to be localized.
    </para>
  </refdescription>
  <refparameter>
    <variablelist>
      <varlistentry>
        <term><parameter>node</parameter></term>
        <listitem><para>
          The node to get to trace the path to.
          Default is the context node.
        </para></listitem>
      </varlistentry>
      <varlistentry>
        <term><parameter>arg</parameter></term>
        <listitem><para>
          Additional string argument to message, if any.
        </para></listitem>
      </varlistentry>
      <varlistentry>
        <term><parameter>key</parameter></term>
        <listitem><para>
          The standard message text.  If a localization/customization
          exists, it is keyed under this text and displayed instead
          of the standard message text.
        </para></listitem>
      </varlistentry>
    </variablelist>
  </refparameter>
</doc:template>

<xsl:template name="user-message">
  <xsl:param name="node" select="." />
  <xsl:param name="trace-node" select="true()" />
  <xsl:param name="arg-1" />
  <xsl:param name="arg-2" />
  <xsl:param name="arg-3" />
  <xsl:param name="arg-4" />
  <xsl:param name="arg-5" />
  <xsl:param name="key" />
  <xsl:param name="content" />

  <xsl:variable name="lang">
    <xsl:call-template name="l10n-message-choose-language">
      <xsl:with-param name="key" select="$key" />
    </xsl:call-template>
  </xsl:variable>

  <xsl:message>
    <xsl:if test="$trace-node">
      <xsl:call-template name="print-node-xpath">
        <xsl:with-param name="node" select="$node" />
      </xsl:call-template>

      <xsl:text>: </xsl:text>
    </xsl:if>

    <xsl:variable 
      name="message"
      select="($l10n-data/l:locale[@lang=$lang]/l:message[@key=$key])[last()]" />

    <xsl:choose>
      <xsl:when test="$message">
        <xsl:apply-templates select="$message/node()" 
                             mode="l10n-substitution">
          <xsl:with-param name="arg-1" select="$arg-1" />
          <xsl:with-param name="arg-2" select="$arg-2" />
          <xsl:with-param name="arg-3" select="$arg-3" />
          <xsl:with-param name="arg-4" select="$arg-4" />
          <xsl:with-param name="arg-5" select="$arg-5" />
        </xsl:apply-templates>
      </xsl:when>

      <xsl:when test="$content != '' and function-available('exslt:node-set')">
        <xsl:apply-templates select="exslt:node-set($content)/node()" 
                             mode="l10n-substitution">
          <xsl:with-param name="arg-1" select="$arg-1" />
          <xsl:with-param name="arg-2" select="$arg-2" />
          <xsl:with-param name="arg-3" select="$arg-3" />
          <xsl:with-param name="arg-4" select="$arg-4" />
          <xsl:with-param name="arg-5" select="$arg-5" />
        </xsl:apply-templates>
      </xsl:when>

      <xsl:otherwise>
        <xsl:value-of select="$key" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:message>
</xsl:template>

<!-- ==================================================================== -->

<doc:template name="print-node-xpath" xmlns="">
  <refpurpose>Display the path of a node</refpurpose>
  <refdescription>
    <para>
      This template displays the address of the given node in 
      XPath notation.
    </para>
  </refdescription>

  <refparameter>
    <variablelist>
      <varlistentry>
        <term><parameter>node</parameter></term>
        <listitem><para>
          The node to get to trace the path to.
          Default is the context node.
        </para></listitem>
      </varlistentry>
    </variablelist>
  </refparameter>
</doc:template>

<xsl:template name="print-node-xpath">
  <xsl:param name="node" select="." />

  <xsl:for-each select="$node/ancestor-or-self::*">
    <xsl:value-of select="concat('/', name())" />
    <xsl:choose>
      <xsl:when test="@id">
        <xsl:text>[@id='</xsl:text>
        <xsl:value-of select="@id" />
        <xsl:text>']</xsl:text>
      </xsl:when>

      <xsl:otherwise>
        <xsl:value-of select="concat(
          '[',
          count(preceding-sibling::*[name() = name(current())])+1,
          ']')" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

   
</xsl:stylesheet>

