<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes=""
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: glossary.xsl,v 1.5 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="glossary[glossentry[1]/preceding-sibling::*]">
  <xsl:call-template name="SS-section">
    <xsl:with-param name="content">
      <xsl:apply-templates select="glossentry" />
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="glossary">
  <xsl:call-template name="SS-section">
    <xsl:apply-templates select="(glossdiv[1]/preceding-sibling::*)"/>
    <xsl:apply-templates select="glossdiv" />
  </xsl:call-template>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="glosslist">
  <xsl:apply-templates />
</xsl:template>
  
<!-- ==================================================================== -->

<xsl:template match="glossdiv">
  <xsl:apply-templates />
</xsl:template>



<!-- ==================================================================== -->

<xsl:template match="glossentry">
  <TP>
    <xsl:apply-templates/>
  </TP>
</xsl:template>
  
<xsl:template match="glossentry/glossterm">
  <TPtag><xsl:apply-templates/></TPtag>
</xsl:template>

<xsl:template match="glossentry/acronym">
  <TPtag><xsl:apply-templates/></TPtag>
</xsl:template>
  
<xsl:template match="glossentry/abbrev">
  <TPtag><xsl:apply-templates/></TPtag>
</xsl:template>
  
<xsl:template match="glossentry/revhistory">
</xsl:template>

<xsl:template match="glossentry/glossdef">
  <TPitem>
    <xsl:apply-templates/>
  </TPitem>
</xsl:template>

<!-- ==================================================================== -->
  
<xsl:template match="glossentry/glosssee|glossseealso">
  <para>
    <xsl:call-template name="gentext-rendering">
      <xsl:with-param name="content">
        <xsl:choose>
          <xsl:when test="./@otherterm">
            <xsl:apply-templates select="key('id', ./@otherterm)" 
                                 mode="glosssee.xref" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="." />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
  </para>
</xsl:template>

<xsl:template match="glossentry" mode="glosssee.xref">
  <xsl:apply-templates mode="glosssee.xref" />
</xsl:template>

<xsl:template match="glossentry/glossterm[1]" mode="glosssee.xref">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="*" mode="glosssee.xref">
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
