<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns:gt="http://docbook2x.sourceforge.net/xsl/gentext-title"
                exclude-result-prefixes="doc gt"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: synop.xsl,v 1.4 2003/06/15 21:39:55 stevecheng Exp $
     ********************************************************************

     &copy; 2001 Steve Cheng <stevecheng@users.sourceforge.net>

     Part of docbook2X, DocBook to man page conversion.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="synopsis">
  <verbatim>
    <xsl:apply-templates />
  </verbatim>
</xsl:template>


<!-- ==================================================================== -->

<xsl:template match="cmdsynopsis">
  <para>
    <xsl:apply-templates mode="cmdsynopsis.mode" />
  </para>
</xsl:template>

<xsl:template match="*" mode="cmdsynopsis.mode">
  <xsl:value-of select="." />
</xsl:template>

<xsl:template match="sbr" mode="cmdsynopsis.mode">
  <sp length="1" />
</xsl:template>

<xsl:template match="command|option" mode="cmdsynopsis.mode">
  <xsl:if test="preceding-sibling::*">
    <xsl:call-template name="cmdsynopsis-gentext-sepchar" />
  </xsl:if>

  <b>
    <xsl:apply-templates mode="cmdsynopsis.mode" />
  </b>
</xsl:template>

<xsl:template match="replaceable" mode="cmdsynopsis.mode">
  <xsl:if test="preceding-sibling::*">
    <xsl:call-template name="cmdsynopsis-gentext-sepchar" />
  </xsl:if>

  <b>
    <xsl:apply-templates mode="cmdsynopsis.mode" />
  </b>
</xsl:template>

<xsl:template match="group|arg" mode="cmdsynopsis.mode">
  <xsl:if test="preceding-sibling::* and not(parent::arg)">
    <xsl:call-template name="cmdsynopsis-gentext-sepchar" />
  </xsl:if>

  <xsl:call-template name="arg-gentext-choice-start" />
  <xsl:apply-templates mode="cmdsynopsis.mode" />
  <xsl:call-template name="arg-gentext-choice-end" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<!-- Member of groups -->

<xsl:template match="group/*" mode="cmdsynopsis.mode" priority="2.0">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>
  <xsl:apply-templates mode="cmdsynopsis.mode" />
</xsl:template>

<xsl:template match="group/group" mode="cmdsynopsis.mode" priority="2.5">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>

  <xsl:call-template name="arg-gentext-choice-start" />
  <xsl:apply-templates mode="cmdsynopsis.mode" />
  <xsl:call-template name="arg-gentext-choice-end" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<xsl:template match="group/arg" mode="cmdsynopsis.mode" priority="2.5">
  <xsl:if test="position()>1">
    <xsl:call-template name="arg-gentext-or-separator" />
  </xsl:if>

  <xsl:apply-templates mode="cmdsynopsis.mode" />
  <xsl:call-template name="arg-gentext-rep" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="funcsynopsis">
  <para>
    <xsl:apply-templates />
  </para>
</xsl:template>

<xsl:template match="*" mode="funcsynopsis.mode">
  <xsl:value-of select="." />
</xsl:template>

<xsl:template match="funcsynopsisinfo">
  <verbatim>
    <xsl:apply-templates mode="funcsynopsis.mode" />
  </verbatim>
  <sp length="1" />
</xsl:template>

<xsl:template match="funcprototype">
  <para>
    <xsl:apply-templates />

    <xsl:if test="$funcsynopsis-style='kr'">
      <sp length="1" />
      <xsl:apply-templates select="./paramdef" mode="kr-funcsynopsis-mode"/>
    </xsl:if>
  </para>
</xsl:template>

<xsl:template match="funcdef">
  <xsl:apply-templates mode="funcsynopsis.mode" />
</xsl:template>

<xsl:template match="function" mode="funcsynopsis.mode">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-decoration">
      <i><xsl:apply-templates mode="funcsynopsis.mode" /></i>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcsynopsis.mode" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="void">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-style='ansi'">
      <xsl:text>(void);</xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>();</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="varargs">
  <xsl:text>(...);</xsl:text>
</xsl:template>

<xsl:template match="paramdef">
  <xsl:choose>
    <xsl:when test="preceding-sibling::*[position()=1 and local-name() = 'paramdef']">
      <xsl:text>, </xsl:text>
    </xsl:when>
    <xsl:otherwise>
      <xsl:text>(</xsl:text>
    </xsl:otherwise>
  </xsl:choose>
  
  <xsl:choose>
    <xsl:when test="$funcsynopsis-style='kr'">
      <xsl:apply-templates select="./parameter" mode="funcsynopsis.mode" />
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcsynopsis.mode" />
    </xsl:otherwise>
  </xsl:choose>
  
  <xsl:if test="not(following-sibling::*[position()=1 and local-name() = 'paramdef'])">
    <xsl:text>);</xsl:text>
  </xsl:if>
</xsl:template>

<xsl:template match="paramdef/parameter" mode="funcsynopsis.mode">
  <xsl:choose>
    <xsl:when test="$funcsynopsis-decoration">
      <i><xsl:apply-templates mode="funcsynopsis.mode" /></i>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates mode="funcsynopsis.mode" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="paramdef" mode="kr-funcsynopsis-mode">
  <xsl:apply-templates mode="funcsynopsis.mode" />
  <xsl:text>;</xsl:text>
</xsl:template>

<xsl:template match="funcparams">
  <xsl:text>(</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>)</xsl:text>
</xsl:template>

<!-- ==================================================================== -->
<!-- FIXME: bring back classsynopsis stuff ! -->

</xsl:stylesheet>
