<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: division.xsl,v 1.16 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->
<xsl:template match="/">
  <xsl:variable name="isnode">
    <xsl:apply-templates select="child::*" mode="is-texinfo-node" />
  </xsl:variable>
              
  <xsl:choose>

    <!-- Set entails multiple files, so special case -->
    <xsl:when test="/set">
      <xsl:apply-templates />
    </xsl:when>
    
    <!-- Otherwise, document element is always texinfo -->
    <xsl:otherwise>
      <texinfo>
        <xsl:attribute name="file">
          <xsl:call-template name="get-texinfo-file-name" />
        </xsl:attribute>

        <xsl:for-each select="child::*">
          <xsl:call-template name="make-texinfo-directory" />
        </xsl:for-each>
    
        <!-- Non-node elements need to have a Top node created for them -->
        <xsl:if test="$isnode != '1'">
          <xsl:for-each select="child::*">
            <xsl:call-template name="make-texinfo-node" />
            <xsl:call-template name="make-texinfo-section" />
          </xsl:for-each>
        </xsl:if>

        <xsl:apply-templates />
      </texinfo>
    </xsl:otherwise>

  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="set">
  <texinfoset>
    <xsl:apply-templates />
  </texinfoset>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="set/book">
  <texinfo>
    <xsl:attribute name="file">
      <xsl:call-template name="get-texinfo-file-name" />
    </xsl:attribute>
        
    <xsl:call-template name="make-texinfo-directory" />

    <xsl:call-template name="section" />
  </texinfo>
</xsl:template>

<xsl:template match="book">
  <xsl:call-template name="section" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template match="part">
  <xsl:call-template name="section">
    <xsl:with-param name="level">majorheading</xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="partintro">
  <xsl:apply-templates />
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>

