<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: qandaset.xsl,v 1.10 2003/05/24 13:52:45 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     ******************************************************************** -->

<!-- ==================================================================== -->

<xsl:template match="qandaentry[ancestor::qandaset/@defaultlabel='qanda']"
              name="qandaentry-with-label-qanda">
  <varlistentry>
    <term>
      <xsl:text>&#xA0;&#xA0;</xsl:text>
      <xsl:call-template name="anchor" />
      <xsl:call-template name="gentext-label">
        <xsl:with-param name="element-name" select="'question'" />
      </xsl:call-template>
    </term>

    <listitem>
      <xsl:apply-templates select="question" />
    </listitem>
  </varlistentry>

  <varlistentry>
    <term>
      <xsl:text>&#xA0;&#xA0;</xsl:text>
      <xsl:call-template name="gentext-label">
        <xsl:with-param name="element-name" select="'answer'" />
      </xsl:call-template>
    </term>

    <listitem>
      <xsl:apply-templates select="answer" />
    </listitem>
  </varlistentry>

</xsl:template>

<xsl:template match="qandaentry[ancestor::qandaset/@defaultlabel='label']"
              name="qandaentry-with-label-label">
  <varlistentry>
    <term>
      <xsl:text>&#xA0;&#xA0;</xsl:text>
      <xsl:call-template name="anchor" />
      <xsl:apply-templates select="label" mode="qanda-label" />
    </term>

    <listitem>
      <xsl:apply-templates select="question" />
    </listitem>
  </varlistentry>

  <varlistentry>
    <term>
      <xsl:text>&#xA0;&#xA0;</xsl:text>
      <xsl:apply-templates select="label" mode="qanda-label" />
    </term>

    <listitem>
      <xsl:apply-templates select="answer" />
    </listitem>
  </varlistentry>

</xsl:template>

<xsl:template match="qandaentry[ancestor::qandaset/@defaultlabel='none']"
              name="qandaentry-with-label-none">
  <xsl:call-template name="anchor" />
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="qandaentry[ancestor::qandaset/@defaultlabel='number']"
              name="qandaentry-with-label-number">
  <varlistentry>
    <term>
      <xsl:text>&#xA0;&#xA0;</xsl:text>
      <xsl:call-template name="anchor" />
      <xsl:number level="single" from="qandadiv|qandaset" format="1." />
    </term>

    <listitem>
      <xsl:apply-templates select="question|answer" />
    </listitem>
  </varlistentry>
</xsl:template>

<xsl:template match="qandaentry">
  <xsl:call-template name="qandaentry-with-label-qanda" />
</xsl:template>

<xsl:template match="question">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="answer">
  <xsl:apply-templates />
</xsl:template>

<xsl:template match="qandaset[@defaultlabel='none']|qandadiv[ancestor::qandaset/@defaultlabel='none']">
  <xsl:if test="title">
    <xsl:call-template name="make-caption" />
  </xsl:if>

  <xsl:apply-templates />
</xsl:template>

<xsl:template match="qandaset[@defaultlabel!='none']|qandadiv[ancestor::qandaset/@defaultlabel!='none']">
  <xsl:if test="title">
    <xsl:call-template name="make-caption" />
  </xsl:if>

  <xsl:choose>
    <xsl:when test="qandadiv">
      <xsl:apply-templates />
    </xsl:when>

    <xsl:otherwise>
      <varlist>
        <xsl:apply-templates />
      </varlist>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- ==================================================================== -->

<xsl:template match="label"></xsl:template>
<xsl:template match="label" mode="qanda-label">
  <xsl:apply-templates />
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
