<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: texinode-impl-default.xsl,v 1.5 2003/05/24 13:52:46 stevecheng Exp $
     ********************************************************************

     &copy; 2000 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to Texinfo.

     Derived from files in Norman Walsh's XSL DocBook Stylesheet
     Distribution and Mark Burton's dbtotexi stylesheets.

     Implementation of Texinfo node handling without any extensions.
     It assumes that node names passed to it are unique without checking
     against a hashtable.

     ******************************************************************** -->


<xsl:template name="get-texinfo-node-name">
  <xsl:param name="node" select="." />
  <xsl:param name="sugname">
    <xsl:apply-templates select="$node" mode="for-texinfo-node-name" />
  </xsl:param>

  <xsl:choose>
    <xsl:when test="$sugname = ''">
      <!-- This message will be repeated for each reference to the same
           node, but without extensions we can't do anything about it.
           -->
      <xsl:call-template name="user-message">
        <xsl:with-param name="node" select="$node" />
        <xsl:with-param name="key">No readable node name; using generate-id</xsl:with-param>
        <xsl:with-param name="arg" select="generate-id($node)" />
      </xsl:call-template>

      <xsl:value-of select="generate-id($node)" />
    </xsl:when>

    <xsl:otherwise>
      <xsl:value-of select="$sugname" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>
  
</xsl:stylesheet>

